/*
 * Decompiled with CFR 0.152.
 */
package xyz.przemyk.simpleplanes.entities;

import com.mojang.math.Quaternion;
import com.mojang.math.Vector3f;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.SimpleMenuProvider;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Explosion;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.fmllegacy.common.registry.IEntityAdditionalSpawnData;
import net.minecraftforge.fmllegacy.network.NetworkHooks;
import net.minecraftforge.fmllegacy.network.PacketDistributor;
import net.minecraftforge.registries.ForgeRegistries;
import xyz.przemyk.simpleplanes.MathUtil;
import xyz.przemyk.simpleplanes.SimplePlanesMod;
import xyz.przemyk.simpleplanes.client.PlaneSound;
import xyz.przemyk.simpleplanes.container.RemoveUpgradesContainer;
import xyz.przemyk.simpleplanes.network.PlaneNetworking;
import xyz.przemyk.simpleplanes.network.RotationPacket;
import xyz.przemyk.simpleplanes.network.SUpgradeRemovedPacket;
import xyz.przemyk.simpleplanes.network.UpdateUpgradePacket;
import xyz.przemyk.simpleplanes.setup.SimplePlanesConfig;
import xyz.przemyk.simpleplanes.setup.SimplePlanesDataSerializers;
import xyz.przemyk.simpleplanes.setup.SimplePlanesItems;
import xyz.przemyk.simpleplanes.setup.SimplePlanesRegistries;
import xyz.przemyk.simpleplanes.setup.SimplePlanesUpgrades;
import xyz.przemyk.simpleplanes.upgrades.Upgrade;
import xyz.przemyk.simpleplanes.upgrades.UpgradeType;
import xyz.przemyk.simpleplanes.upgrades.engines.EngineUpgrade;

public class PlaneEntity
extends Entity
implements IEntityAdditionalSpawnData {
    public static final EntityDataAccessor<Integer> MAX_HEALTH = SynchedEntityData.m_135353_(PlaneEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    public static final EntityDataAccessor<Integer> HEALTH = SynchedEntityData.m_135353_(PlaneEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    public static final EntityDataAccessor<Float> MAX_SPEED = SynchedEntityData.m_135353_(PlaneEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135029_);
    public static final EntityDataAccessor<String> MATERIAL = SynchedEntityData.m_135353_(PlaneEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135030_);
    public static final EntityDataAccessor<Integer> ROCKING_TICKS = SynchedEntityData.m_135353_(PlaneEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    public static final EntityDataAccessor<Integer> TIME_SINCE_HIT = SynchedEntityData.m_135353_(PlaneEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    public static final EntityDataAccessor<Float> DAMAGE_TAKEN = SynchedEntityData.m_135353_(PlaneEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135029_);
    public static final EntityDataAccessor<Boolean> PARKED = SynchedEntityData.m_135353_(PlaneEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    public static final EntityDataAccessor<Quaternion> Q = SynchedEntityData.m_135353_(PlaneEntity.class, SimplePlanesDataSerializers.QUATERNION_SERIALIZER);
    public Quaternion Q_Client = new Quaternion(Quaternion.f_80118_);
    public Quaternion Q_Prev = new Quaternion(Quaternion.f_80118_);
    private int onGroundTicks;
    public HashMap<ResourceLocation, Upgrade> upgrades = new HashMap();
    public EngineUpgrade engineUpgrade = null;
    public float rotationRoll;
    public float prevRotationRoll;
    private float deltaRotation;
    private float deltaRotationLeft;
    private int deltaRotationTicks;
    private Block planksMaterial;
    public boolean mountMessage;
    private int damageTimeout;
    public int notMovingTime;
    public int goldenHeartsTimeout = 0;
    private final int networkUpdateInterval;
    public static final ResourceLocation FIREPROOF_MATERIALS = new ResourceLocation("simpleplanes", "fireproof_materials");
    private int lerpSteps;
    private int lerpStepsQ;
    private double lerpX;
    private double lerpY;
    private double lerpZ;
    private boolean rocking;
    private float rockingIntensity;
    private float rockingAngle;
    private float prevRockingAngle;
    private static final TempMotionVars TEMP_MOTION_VARS = new TempMotionVars();

    public PlaneEntity(EntityType<? extends PlaneEntity> entityTypeIn, Level worldIn) {
        this(entityTypeIn, worldIn, Blocks.f_50705_);
    }

    public PlaneEntity(EntityType<? extends PlaneEntity> entityTypeIn, Level worldIn, Block material) {
        super(entityTypeIn, worldIn);
        this.networkUpdateInterval = entityTypeIn.m_20682_();
        this.f_19793_ = 0.9999f;
        this.setMaterial(material);
        this.setMaxSpeed(1.0f);
    }

    public PlaneEntity(EntityType<? extends PlaneEntity> entityTypeIn, Level worldIn, Block material, double x, double y, double z) {
        this(entityTypeIn, worldIn, material);
        this.m_6034_(x, y, z);
    }

    protected void m_8097_() {
        this.f_19804_.m_135372_(MAX_HEALTH, (Object)10);
        this.f_19804_.m_135372_(HEALTH, (Object)10);
        this.f_19804_.m_135372_(Q, (Object)Quaternion.f_80118_);
        this.f_19804_.m_135372_(MAX_SPEED, (Object)Float.valueOf(0.25f));
        this.f_19804_.m_135372_(MATERIAL, (Object)Blocks.f_50705_.getRegistryName().toString());
        this.f_19804_.m_135372_(ROCKING_TICKS, (Object)0);
        this.f_19804_.m_135372_(TIME_SINCE_HIT, (Object)0);
        this.f_19804_.m_135372_(DAMAGE_TAKEN, (Object)Float.valueOf(0.0f));
        this.f_19804_.m_135372_(PARKED, (Object)true);
    }

    public float getMaxSpeed() {
        return ((Float)this.f_19804_.m_135370_(MAX_SPEED)).floatValue();
    }

    public void setMaxSpeed(float maxSpeed) {
        this.f_19804_.m_135381_(MAX_SPEED, (Object)Float.valueOf(maxSpeed));
    }

    public Quaternion getQ() {
        return new Quaternion((Quaternion)this.f_19804_.m_135370_(Q));
    }

    public void setQ(Quaternion q) {
        this.f_19804_.m_135381_(Q, (Object)q);
    }

    public Quaternion getQ_Client() {
        return new Quaternion(this.Q_Client);
    }

    public void setQ_Client(Quaternion q) {
        this.Q_Client = q;
    }

    public Quaternion getQ_Prev() {
        return this.Q_Prev.m_80161_();
    }

    public void setQ_prev(Quaternion q) {
        this.Q_Prev = q;
    }

    public Block getMaterial() {
        return this.planksMaterial;
    }

    public void setHealth(int health) {
        this.f_19804_.m_135381_(HEALTH, (Object)Math.max(health, 0));
    }

    public int getHealth() {
        return (Integer)this.f_19804_.m_135370_(HEALTH);
    }

    public int getMaxHealth() {
        return (Integer)this.f_19804_.m_135370_(MAX_HEALTH);
    }

    public void setParked(Boolean val) {
        this.f_19804_.m_135381_(PARKED, (Object)val);
    }

    public boolean getParked() {
        return (Boolean)this.f_19804_.m_135370_(PARKED);
    }

    public ItemStack getPickedResult(HitResult target) {
        return this.getItemStack();
    }

    public void setMaterial(String material) {
        this.f_19804_.m_135381_(MATERIAL, (Object)material);
        Block block = (Block)ForgeRegistries.BLOCKS.getValue(new ResourceLocation(material));
        this.planksMaterial = block == null ? Blocks.f_50705_ : block;
    }

    public void setMaterial(Block material) {
        this.f_19804_.m_135381_(MATERIAL, (Object)material.getRegistryName().toString());
        this.planksMaterial = material;
    }

    public boolean isPowered() {
        return this.m_6084_() && (this.isCreative() || this.engineUpgrade != null && this.engineUpgrade.isPowered());
    }

    public InteractionResult m_6096_(Player player, InteractionHand hand) {
        ItemStack itemStack = player.m_21120_(hand);
        if (player.m_6144_() && itemStack.m_41619_()) {
            boolean hasPlayer = false;
            for (Entity passenger : this.m_20197_()) {
                if (!(passenger instanceof Player)) continue;
                hasPlayer = true;
                break;
            }
            if (!hasPlayer || ((Boolean)SimplePlanesConfig.THIEF.get()).booleanValue()) {
                this.m_20153_();
            }
            return InteractionResult.SUCCESS;
        }
        if (itemStack.m_41720_() == SimplePlanesItems.WRENCH.get()) {
            if (!this.f_19853_.f_46443_) {
                NetworkHooks.openGui((ServerPlayer)((ServerPlayer)player), (MenuProvider)new SimpleMenuProvider((id, inv, p) -> new RemoveUpgradesContainer(id, this.m_142049_()), TextComponent.f_131282_), buf -> buf.m_130130_(this.m_142049_()));
                return InteractionResult.CONSUME;
            }
            return InteractionResult.SUCCESS;
        }
        if (this.tryToAddUpgrade(player, itemStack)) {
            return InteractionResult.SUCCESS;
        }
        if (!this.f_19853_.f_46443_) {
            return player.m_20329_((Entity)this) ? InteractionResult.CONSUME : InteractionResult.FAIL;
        }
        return player.m_20201_() == this.m_20201_() ? InteractionResult.FAIL : InteractionResult.SUCCESS;
    }

    protected boolean tryToAddUpgrade(Player playerEntity, ItemStack itemStack) {
        Optional<UpgradeType> upgradeTypeOptional = SimplePlanesUpgrades.getUpgradeFromItem(itemStack.m_41720_());
        return upgradeTypeOptional.map(upgradeType -> {
            if (this.canAddUpgrade((UpgradeType)((Object)upgradeType))) {
                Upgrade upgrade = upgradeType.instanceSupplier.apply(this);
                this.addUpgrade(playerEntity, itemStack, upgrade);
                return true;
            }
            return false;
        }).orElse(false);
    }

    protected void addUpgrade(Player playerEntity, ItemStack itemStack, Upgrade upgrade) {
        upgrade.onApply(itemStack, playerEntity);
        if (!playerEntity.m_7500_()) {
            itemStack.m_41774_(1);
        }
        UpgradeType upgradeType = upgrade.getType();
        this.upgrades.put(upgradeType.getRegistryName(), upgrade);
        if (upgradeType.isEngine) {
            this.engineUpgrade = (EngineUpgrade)upgrade;
        }
        if (!this.f_19853_.f_46443_) {
            PlaneNetworking.INSTANCE.send(PacketDistributor.TRACKING_ENTITY.with(() -> this), (Object)new UpdateUpgradePacket(upgrade.getType().getRegistryName(), this.m_142049_(), (ServerLevel)this.f_19853_, true));
        }
    }

    public boolean m_6469_(DamageSource source, float amount) {
        boolean creativePlayer;
        this.setTimeSinceHit(20);
        this.setDamageTaken(this.getDamageTaken() + 10.0f * amount);
        if (this.m_6673_(source) || this.damageTimeout > 0) {
            return false;
        }
        if (this.f_19853_.f_46443_ || this.m_146910_()) {
            return false;
        }
        int health = this.getHealth();
        if (health < 0) {
            return false;
        }
        health = (int)((float)health - amount);
        this.setHealth(health);
        this.damageTimeout = 10;
        boolean isPlayer = source.m_7639_() instanceof Player;
        boolean bl = creativePlayer = isPlayer && ((Player)source.m_7639_()).m_150110_().f_35937_;
        if (creativePlayer || isPlayer && this.getDamageTaken() > 30.0f || health <= 0) {
            if (!creativePlayer) {
                if (source == SimplePlanesMod.DAMAGE_SOURCE_PLANE_CRASH) {
                    this.explode();
                }
                if (this.f_19853_.m_46469_().m_46207_(GameRules.f_46137_)) {
                    this.dropItem();
                }
            }
            this.m_6074_();
        }
        return true;
    }

    private void explode() {
        ((ServerLevel)this.f_19853_).m_8767_((ParticleOptions)ParticleTypes.f_123762_, this.m_20185_(), this.m_20186_(), this.m_20189_(), 5, 1.0, 1.0, 1.0, 2.0);
        ((ServerLevel)this.f_19853_).m_8767_((ParticleOptions)ParticleTypes.f_123759_, this.m_20185_(), this.m_20186_(), this.m_20189_(), 10, 1.0, 1.0, 1.0, 1.0);
        this.f_19853_.m_46511_((Entity)this, this.m_20185_(), this.m_20186_(), this.m_20189_(), 4.0f, Explosion.BlockInteraction.BREAK);
    }

    protected void dropItem() {
        ItemStack itemStack = this.getItemStack();
        this.m_19983_(itemStack).m_20331_(true);
    }

    public boolean m_6087_() {
        return true;
    }

    public void m_8119_() {
        Entity controllingPassenger;
        Entity entity;
        super.m_8119_();
        if (Double.isNaN(this.m_20184_().m_82553_())) {
            this.m_20256_(Vec3.f_82478_);
        }
        this.f_19859_ = this.m_146908_();
        this.f_19860_ = this.m_146909_();
        this.prevRotationRoll = this.rotationRoll;
        if (this.f_19853_.f_46443_ && !this.m_6109_()) {
            this.tickLerp();
            this.m_20256_(Vec3.f_82478_);
            this.tickDeltaRotation(this.getQ_Client());
            this.tickUpgrades();
            return;
        }
        this.m_5834_();
        TempMotionVars tempMotionVars = this.getMotionVars();
        if (this.m_20068_()) {
            tempMotionVars.gravity = 0.0;
            tempMotionVars.maxLift = 0.0f;
            tempMotionVars.push = 0.0f;
            tempMotionVars.passiveEnginePush = 0.0f;
        }
        if ((entity = (controllingPassenger = this.m_6688_())) instanceof Player) {
            Player playerEntity = (Player)entity;
            tempMotionVars.moveForward = playerEntity.f_20902_;
            tempMotionVars.moveStrafing = playerEntity.f_20900_;
        } else {
            tempMotionVars.moveForward = 0.0f;
            tempMotionVars.moveStrafing = 0.0f;
            this.m_6858_(false);
        }
        tempMotionVars.turnThreshold = (double)((Integer)SimplePlanesConfig.TURN_THRESHOLD.get()).intValue() / 100.0;
        if ((double)Math.abs(tempMotionVars.moveForward) < tempMotionVars.turnThreshold) {
            tempMotionVars.moveForward = 0.0f;
        }
        if ((double)Math.abs(tempMotionVars.moveStrafing) < tempMotionVars.turnThreshold) {
            tempMotionVars.moveStrafing = 0.0f;
        }
        tempMotionVars.passengerSprinting = this.m_20142_();
        Quaternion q = this.f_19853_.f_46443_ ? this.getQ_Client() : this.getQ();
        MathUtil.EulerAngles angelsOld = MathUtil.toEulerAngles(q).copy();
        Vec3 oldMotion = this.m_20184_();
        boolean parked = this.updateParkedState(tempMotionVars);
        if (this.f_19853_.f_46443_ && this.isPowered() && !parked) {
            PlaneSound.tryToPlay(this);
        }
        if (this.m_20184_().m_82553_() > 0.05) {
            q = this.tickRotateMotion(tempMotionVars, q, this.m_20184_());
        }
        boolean doPitch = true;
        if (this.getOnGround() || this.isOnWater()) {
            doPitch = this.tickOnGround(tempMotionVars);
        } else {
            --this.onGroundTicks;
            if (!tempMotionVars.passengerSprinting) {
                tempMotionVars.push = tempMotionVars.passiveEnginePush;
            }
        }
        if (doPitch) {
            this.tickPitch(tempMotionVars);
        }
        this.tickMotion(tempMotionVars);
        this.tickRotation(tempMotionVars);
        this.tickUpgrades();
        if (this.onGroundTicks > -50 && oldMotion.m_82553_() < 0.002 && this.m_20184_().m_82553_() < 0.002) {
            this.m_20256_(Vec3.f_82478_);
        }
        this.updateRocking();
        this.m_20090_();
        if (!this.f_19861_ || MathUtil.getHorizontalDistanceSqr(this.m_20184_()) > (double)1.0E-5f || (this.f_19797_ + this.m_142049_()) % 4 == 0) {
            double speedAfter;
            double speedDiff;
            float f2;
            double speedBefore = Math.sqrt(MathUtil.getHorizontalDistanceSqr(this.m_20184_()));
            boolean onGroundOld = this.f_19861_;
            Vec3 motion = this.m_20184_();
            if (motion.m_82556_() > 0.25 || tempMotionVars.moveForward != 0.0f) {
                this.f_19861_ = true;
            }
            this.m_6478_(MoverType.SELF, motion);
            boolean bl = this.f_19861_ = motion.m_7098_() == 0.0 ? onGroundOld : this.f_19861_;
            if (this.f_19862_ && !this.f_19853_.f_46443_ && ((Boolean)SimplePlanesConfig.PLANE_CRASH.get()).booleanValue() && this.onGroundTicks <= 0 && (f2 = (float)((speedDiff = speedBefore - (speedAfter = Math.sqrt(MathUtil.getHorizontalDistanceSqr(this.m_20184_())))) * 10.0 - 5.0)) > 5.0f) {
                this.crash(f2);
            }
        }
        q.m_80148_(new Quaternion(Vector3f.f_122227_, (float)((double)this.rotationRoll - angelsOld.roll), true));
        q.m_80148_(new Quaternion(Vector3f.f_122222_, (float)((double)this.m_146909_() - angelsOld.pitch), true));
        q.m_80148_(new Quaternion(Vector3f.f_122225_, (float)((double)this.m_146908_() - angelsOld.yaw), true));
        q = MathUtil.normalizeQuaternion(q);
        this.setQ_prev(this.getQ_Client());
        this.setQ(q);
        this.tickDeltaRotation(q);
        if (this.f_19853_.f_46443_ && this.m_6109_()) {
            this.setQ_Client(q);
            PlaneNetworking.INSTANCE.sendToServer((Object)new RotationPacket(this.getQ()));
        } else {
            ServerPlayer player = (ServerPlayer)this.getPlayer();
            if (player != null) {
                player.f_8906_.f_9739_ = 0;
            }
        }
        if (this.damageTimeout > 0) {
            --this.damageTimeout;
        }
        if (this.f_19853_.f_46443_ && this.getTimeSinceHit() > 0) {
            this.setTimeSinceHit(this.getTimeSinceHit() - 1);
        }
        if (this.getDamageTaken() > 0.0f) {
            this.setDamageTaken(this.getDamageTaken() - 1.0f);
        }
        if (!this.f_19853_.f_46443_ && this.getHealth() > this.getMaxHealth() & this.goldenHeartsTimeout > (this.getOnGround() ? 300 : 100)) {
            this.setHealth(this.getHealth() - 1);
            this.goldenHeartsTimeout = 0;
        }
        if (this.goldenHeartsTimeout < 1000 && this.isPowered()) {
            ++this.goldenHeartsTimeout;
        }
        this.tickLerp();
    }

    public void tickUpgrades() {
        ArrayList upgradesToRemove = new ArrayList();
        ArrayList upgradesToUpdate = new ArrayList();
        this.upgrades.forEach((rl, upgrade) -> {
            upgrade.tick();
            if (upgrade.removed) {
                upgradesToRemove.add(rl);
            } else if (upgrade.updateClient && !this.f_19853_.f_46443_) {
                upgradesToUpdate.add(rl);
            }
        });
        for (ResourceLocation name : upgradesToRemove) {
            this.upgrades.remove(name);
        }
        if (this.f_19797_ % this.networkUpdateInterval == 0) {
            for (ResourceLocation name : upgradesToUpdate) {
                PlaneNetworking.INSTANCE.send(PacketDistributor.TRACKING_ENTITY.with(() -> this), (Object)new UpdateUpgradePacket(name, this.m_142049_(), (ServerLevel)this.f_19853_));
            }
        }
    }

    public int getFuelCost() {
        return (Integer)SimplePlanesConfig.PLANE_FUEL_COST.get();
    }

    private boolean updateParkedState(TempMotionVars tempMotionVars) {
        Vec3 oldMotion = this.m_20184_();
        boolean parked = !(!this.isOnWater() && !this.m_20096_() || !(oldMotion.m_82553_() < 0.1) || tempMotionVars.passengerSprinting || tempMotionVars.moveStrafing != 0.0f || this.notMovingTime <= 20 || !this.f_19861_ && !this.isOnWater() || tempMotionVars.moveForward != 0.0f);
        this.setParked(parked);
        return parked;
    }

    protected TempMotionVars getMotionVars() {
        TEMP_MOTION_VARS.reset();
        PlaneEntity.TEMP_MOTION_VARS.maxPushSpeed = this.getMaxSpeed() * 10.0f;
        return TEMP_MOTION_VARS;
    }

    protected void tickDeltaRotation(Quaternion q) {
        MathUtil.EulerAngles angels1 = MathUtil.toEulerAngles(q);
        this.m_146926_((float)angels1.pitch);
        this.m_146922_((float)angels1.yaw);
        this.rotationRoll = (float)angels1.roll;
        float d = (float)MathUtil.wrapSubtractDegrees(this.f_19859_, this.m_146908_());
        if (this.rotationRoll >= 90.0f && this.prevRotationRoll <= 90.0f) {
            d = 0.0f;
        }
        int diff = 3;
        this.deltaRotationTicks = Math.min(10, Math.max((int)Math.abs(this.deltaRotationLeft) * 5, this.deltaRotationTicks));
        this.deltaRotationLeft = (float)((double)this.deltaRotationLeft * 0.7);
        this.deltaRotationLeft += d;
        this.deltaRotationLeft = Mth.m_14177_((float)this.deltaRotationLeft);
        this.deltaRotation = Math.min(Math.abs(this.deltaRotationLeft), (float)diff) * Math.signum(this.deltaRotationLeft);
        this.deltaRotationLeft -= this.deltaRotation;
        if (!(this.deltaRotation > 0.0f)) {
            --this.deltaRotationTicks;
        }
    }

    protected void tickRotation(TempMotionVars tempMotionVars) {
        double turn;
        float f1 = 1.0f;
        float moveStrafing = tempMotionVars.moveStrafing;
        int yawdiff = 3;
        float roll = this.rotationRoll;
        if (MathUtil.degreesDifferenceAbs(this.m_146909_(), 0.0) < 45.0) {
            for (int i = 0; i < 360; i += 180) {
                if (!(Mth.m_14145_((float)this.rotationRoll, (float)i) < 80.0f)) continue;
                roll = MathUtil.lerpAngle(0.1f * f1, this.rotationRoll, i);
                break;
            }
        }
        if (this.getOnGround() || this.isOnWater()) {
            turn = moveStrafing > 0.0f ? (double)yawdiff : (moveStrafing == 0.0f ? 0.0 : (double)(-yawdiff));
            this.rotationRoll = roll;
        } else if (MathUtil.degreesDifferenceAbs(this.rotationRoll, 0.0) > 30.0) {
            turn = moveStrafing > 0.0f ? (double)(-yawdiff) : (moveStrafing == 0.0f ? 0.0 : (double)yawdiff);
            this.rotationRoll = roll;
        } else {
            if (moveStrafing == 0.0f) {
                this.rotationRoll = MathUtil.lerpAngle180(0.2f, this.rotationRoll, 0.0f);
            } else if (moveStrafing > 0.0f) {
                this.rotationRoll = Math.min(this.rotationRoll + f1, 15.0f);
            } else if (moveStrafing < 0.0f) {
                this.rotationRoll = Math.max(this.rotationRoll - f1, -15.0f);
            }
            double rollOld = MathUtil.toEulerAngles((Quaternion)this.getQ()).roll;
            turn = MathUtil.degreesDifferenceAbs(rollOld, 0.0) < 90.0 ? Mth.m_14008_((double)(rollOld * (double)tempMotionVars.yawMultiplayer), (double)(-yawdiff), (double)yawdiff) : Mth.m_14008_((double)((180.0 - rollOld) * (double)tempMotionVars.yawMultiplayer), (double)(-yawdiff), (double)yawdiff);
            if (moveStrafing == 0.0f) {
                turn = 0.0;
            }
        }
        this.m_146922_((float)((double)this.m_146908_() - turn));
    }

    protected void tickMotion(TempMotionVars tempMotionVars) {
        Vec3 pushVec;
        if (!this.isPowered()) {
            tempMotionVars.push = 0.0f;
        }
        Vec3 motion = this.m_20184_();
        double speed = motion.m_82553_();
        speed -= speed * speed * tempMotionVars.dragQuad + speed * tempMotionVars.dragMul + tempMotionVars.drag;
        if ((speed = Math.max(speed, 0.0)) > tempMotionVars.maxSpeed) {
            speed = Mth.m_14139_((double)0.2, (double)speed, (double)tempMotionVars.maxSpeed);
        }
        if (speed == 0.0) {
            motion = Vec3.f_82478_;
        }
        if (motion.m_82553_() > 0.0) {
            motion = motion.m_82490_(speed / motion.m_82553_());
        }
        if ((pushVec = new Vec3(this.getTickPush(tempMotionVars))).m_82553_() != 0.0 && motion.m_82553_() > 0.1) {
            double dot = MathUtil.normalizedDotProduct(pushVec, motion);
            pushVec = pushVec.m_82490_(Mth.m_14008_((double)(1.0 - dot * speed / (tempMotionVars.maxPushSpeed * ((double)tempMotionVars.push + 0.05))), (double)0.0, (double)2.0));
        }
        motion = motion.m_82549_(pushVec);
        motion = motion.m_82520_(0.0, tempMotionVars.gravity, 0.0);
        this.m_20256_(motion);
    }

    protected Vector3f getTickPush(TempMotionVars tempMotionVars) {
        return this.transformPos(new Vector3f(0.0f, 0.0f, tempMotionVars.push));
    }

    protected void tickPitch(TempMotionVars tempMotionVars) {
        float pitch = 0.0f;
        if (tempMotionVars.moveForward > 0.0f) {
            pitch = 1.3f;
        } else if (tempMotionVars.moveForward < 0.0f) {
            pitch = -1.3f;
        }
        this.m_146926_(this.m_146909_() + pitch);
    }

    protected boolean tickOnGround(TempMotionVars tempMotionVars) {
        this.notMovingTime = this.m_20184_().m_82556_() < 0.01 && this.getOnGround() ? ++this.notMovingTime : 0;
        if (this.notMovingTime > 200 && this.getHealth() < this.getMaxHealth() && this.getPlayer() != null) {
            this.setHealth(this.getHealth() + 1);
            this.notMovingTime = 100;
        }
        boolean speedingUp = true;
        this.onGroundTicks = this.onGroundTicks < 0 ? 5 : --this.onGroundTicks;
        float pitch = this.getGroundPitch();
        if (this.isPowered() && tempMotionVars.moveForward > 0.0f || this.isOnWater()) {
            pitch = 0.0f;
        } else if (this.m_20184_().m_82553_() > tempMotionVars.takeOffSpeed) {
            pitch /= 2.0f;
        }
        this.m_146926_(MathUtil.lerpAngle(0.1f, this.m_146909_(), pitch));
        if (MathUtil.degreesDifferenceAbs(this.m_146909_(), 0.0) > 1.0 && this.m_20184_().m_82553_() < 0.1) {
            tempMotionVars.push /= 5.0f;
        }
        if (this.m_20184_().m_82553_() < tempMotionVars.takeOffSpeed) {
            speedingUp = false;
        }
        if (tempMotionVars.moveForward < 0.0f) {
            tempMotionVars.push = -tempMotionVars.groundPush;
        }
        if (!this.isPowered() || tempMotionVars.moveForward == 0.0f) {
            tempMotionVars.push = 0.0f;
        }
        BlockPos pos = new BlockPos(this.m_20185_(), this.m_20186_() - 1.0, this.m_20189_());
        float f = this.f_19853_.m_8055_(pos).getFriction((LevelReader)this.f_19853_, pos, (Entity)this);
        tempMotionVars.dragMul *= (double)(20.0f * (3.0f - f));
        return speedingUp;
    }

    protected float getGroundPitch() {
        return 15.0f;
    }

    protected Quaternion tickRotateMotion(TempMotionVars tempMotionVars, Quaternion q, Vec3 motion) {
        float d;
        float yaw = MathUtil.getYaw(motion);
        float pitch = MathUtil.getPitch(motion);
        if (MathUtil.degreesDifferenceAbs(yaw, this.m_146908_()) > 5.0 && (this.getOnGround() || this.isOnWater())) {
            this.m_20256_(motion.m_82490_(0.98));
        }
        if ((d = (float)MathUtil.degreesDifferenceAbs(pitch, this.m_146909_())) > 180.0f) {
            d -= 180.0f;
        }
        d /= 60.0f;
        d = Math.min(1.0f, d);
        d *= d;
        d = 1.0f - d;
        double speed = this.m_20184_().m_82553_();
        double lift = Math.min(speed * tempMotionVars.liftFactor, (double)tempMotionVars.maxLift) * (double)d;
        double cosRoll = (1.0 + 4.0 * Math.max(Math.cos(Math.toRadians(MathUtil.degreesDifferenceAbs(this.rotationRoll, 0.0))), 0.0)) / 5.0;
        d = (float)((double)d * cosRoll);
        this.m_20256_(MathUtil.rotationToVector(MathUtil.lerpAngle180(0.1f, yaw, this.m_146908_()), (double)MathUtil.lerpAngle180(tempMotionVars.pitchToMotion * d, pitch, this.m_146909_()) + (lift *= cosRoll), speed));
        if (!this.getOnGround() && !this.isOnWater() && motion.m_82553_() > 0.1) {
            if (MathUtil.degreesDifferenceAbs(pitch, this.m_146909_()) > 90.0) {
                pitch = Mth.m_14177_((float)(pitch + 180.0f));
            }
            if (Math.abs(this.m_146909_()) < 85.0f) {
                yaw = MathUtil.getYaw(this.m_20184_());
                if (MathUtil.degreesDifferenceAbs(yaw, this.m_146908_()) > 90.0) {
                    yaw -= 180.0f;
                }
                Quaternion q1 = MathUtil.toQuaternion(yaw, pitch, this.rotationRoll);
                q = MathUtil.lerpQ(tempMotionVars.motionToRotation, q, q1);
            }
        }
        return q;
    }

    public Vector3f transformPos(Vector3f relPos) {
        MathUtil.EulerAngles angels = MathUtil.toEulerAngles(this.getQ_Client());
        angels.yaw = -angels.yaw;
        angels.roll = -angels.roll;
        relPos.m_122251_(MathUtil.toQuaternion(angels.yaw, angels.pitch, angels.roll));
        return relPos;
    }

    @Nullable
    public Entity m_6688_() {
        List list = this.m_20197_();
        return list.isEmpty() ? null : (Entity)list.get(0);
    }

    public void m_7378_(CompoundTag compound) {
        if (compound.m_128441_("max_speed")) {
            this.f_19804_.m_135381_(MAX_SPEED, (Object)Float.valueOf(compound.m_128457_("max_speed")));
        }
        if (compound.m_128441_("max_health")) {
            int maxHealth = compound.m_128451_("max_health");
            if (maxHealth <= 0) {
                maxHealth = 20;
            }
            this.f_19804_.m_135381_(MAX_HEALTH, (Object)maxHealth);
        }
        if (compound.m_128441_("health")) {
            int health = compound.m_128451_("health");
            if (health <= 0) {
                health = 1;
            }
            this.f_19804_.m_135381_(HEALTH, (Object)health);
        }
        if (compound.m_128441_("material")) {
            this.setMaterial(compound.m_128461_("material"));
        }
        if (compound.m_128441_("upgrades")) {
            CompoundTag upgradesNBT = compound.m_128469_("upgrades");
            this.deserializeUpgrades(upgradesNBT);
        }
    }

    private void deserializeUpgrades(CompoundTag upgradesNBT) {
        for (String key : upgradesNBT.m_128431_()) {
            ResourceLocation resourceLocation = new ResourceLocation(key);
            UpgradeType upgradeType = (UpgradeType)SimplePlanesRegistries.UPGRADE_TYPES.getValue(resourceLocation);
            if (upgradeType == null) continue;
            Upgrade upgrade = upgradeType.instanceSupplier.apply(this);
            upgrade.deserializeNBT(upgradesNBT.m_128469_(key));
            this.upgrades.put(resourceLocation, upgrade);
            if (!upgradeType.isEngine) continue;
            this.engineUpgrade = (EngineUpgrade)upgrade;
        }
    }

    public void m_7380_(CompoundTag compound) {
        compound.m_128405_("health", ((Integer)this.f_19804_.m_135370_(HEALTH)).intValue());
        compound.m_128405_("max_health", ((Integer)this.f_19804_.m_135370_(MAX_HEALTH)).intValue());
        compound.m_128350_("max_speed", ((Float)this.f_19804_.m_135370_(MAX_SPEED)).floatValue());
        compound.m_128359_("material", (String)this.f_19804_.m_135370_(MATERIAL));
        compound.m_128365_("upgrades", (Tag)this.getUpgradesNBT());
    }

    private CompoundTag getUpgradesNBT() {
        CompoundTag upgradesNBT = new CompoundTag();
        for (Upgrade upgrade : this.upgrades.values()) {
            upgradesNBT.m_128365_(upgrade.getType().getRegistryName().toString(), (Tag)upgrade.serializeNBT());
        }
        return upgradesNBT;
    }

    protected boolean m_7341_(Entity entityIn) {
        return true;
    }

    public boolean canBeRiddenInWater(Entity rider) {
        return this.upgrades.containsKey(SimplePlanesUpgrades.FLOATY_BEDDING.getId());
    }

    public boolean m_5829_() {
        return true;
    }

    public Packet<?> m_5654_() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }

    public void m_7350_(EntityDataAccessor<?> key) {
        super.m_7350_(key);
        if (MATERIAL.equals(key) && this.f_19853_.m_5776_()) {
            Block block = (Block)ForgeRegistries.BLOCKS.getValue(new ResourceLocation((String)this.f_19804_.m_135370_(MATERIAL)));
            this.planksMaterial = block == null ? Blocks.f_50705_ : block;
        } else if (Q.equals(key) && this.f_19853_.m_5776_() && !this.m_6109_()) {
            if (this.f_19803_) {
                this.lerpStepsQ = 0;
                this.setQ_Client(this.getQ());
                this.setQ_prev(this.getQ());
            } else {
                this.lerpStepsQ = 10;
            }
        }
    }

    public double m_6048_() {
        return 0.375;
    }

    public boolean m_6673_(DamageSource source) {
        if (source.m_19372_()) {
            return false;
        }
        if (source.m_19384_() && BlockTags.m_13115_().m_13404_(FIREPROOF_MATERIALS).m_8110_((Object)this.planksMaterial)) {
            return true;
        }
        if (source.m_7640_() != null && source.m_7640_().m_20365_((Entity)this)) {
            return true;
        }
        return super.m_6673_(source);
    }

    public boolean m_5825_() {
        return BlockTags.f_13044_.m_8110_((Object)this.planksMaterial);
    }

    protected void m_7840_(double y, boolean onGroundIn, BlockState state, BlockPos pos) {
        if ((onGroundIn || this.isOnWater()) && ((Boolean)SimplePlanesConfig.PLANE_CRASH.get()).booleanValue()) {
            double y1 = this.transformPos(new Vector3f(0.0f, 1.0f, 0.0f)).m_122260_();
            if (y1 < Math.cos(Math.toRadians(this.getLandingAngle()))) {
                state.m_60734_().m_142072_(this.f_19853_, state, pos, (Entity)this, (float)(this.m_20184_().m_82553_() * 5.0));
            }
            this.f_19789_ = 0.0f;
        }
    }

    protected int getLandingAngle() {
        return 30;
    }

    public boolean m_142535_(float fallDistance, float damageMultiplier, DamageSource p_146830_) {
        if (this.m_20160_()) {
            this.crash(fallDistance * damageMultiplier);
        }
        return false;
    }

    public void crash(float damage) {
        if (!this.f_19853_.f_46443_ && this.m_6084_()) {
            for (Entity entity : this.m_20197_()) {
                float damageMod = Math.min(1.0f, 1.0f - (float)this.getHealth() / (float)this.getMaxHealth());
                entity.m_6469_(SimplePlanesMod.DAMAGE_SOURCE_PLANE_CRASH, damage * damageMod);
            }
            this.m_6469_(SimplePlanesMod.DAMAGE_SOURCE_PLANE_CRASH, damage + 2.0f);
        }
    }

    public boolean isCreative() {
        return this.m_6688_() instanceof Player && ((Player)this.m_6688_()).m_7500_();
    }

    public boolean getOnGround() {
        return this.f_19861_ || this.onGroundTicks > 1;
    }

    public boolean isOnWater() {
        return this.f_19853_.m_8055_(new BlockPos(this.m_20182_().m_82520_(0.0, 0.4, 0.0))).m_60734_() == Blocks.f_49990_;
    }

    public boolean canAddUpgrade(UpgradeType upgradeType) {
        if (upgradeType.isEngine && this.engineUpgrade != null) {
            return false;
        }
        return !this.upgrades.containsKey(upgradeType.getRegistryName());
    }

    public void m_6083_() {
        super.m_6083_();
    }

    public void m_7332_(Entity passenger) {
        boolean b;
        super.m_7332_(passenger);
        boolean bl = b = passenger instanceof Player && ((Player)passenger).m_7578_();
        if (this.m_20363_(passenger) && !b) {
            this.applyYawToEntity(passenger);
        }
    }

    public void applyYawToEntity(Entity entityToUpdate) {
        entityToUpdate.m_5616_(entityToUpdate.m_6080_() + this.deltaRotation);
        entityToUpdate.f_19859_ += this.deltaRotation;
        entityToUpdate.m_5618_(this.m_146908_());
        float f = Mth.m_14177_((float)(entityToUpdate.f_19859_ - this.m_146908_()));
        float f1 = Mth.m_14036_((float)f, (float)-105.0f, (float)105.0f);
        float perc = this.deltaRotationTicks > 0 ? 1.0f / (float)this.deltaRotationTicks : 1.0f;
        float diff = (f1 - f) * perc;
        entityToUpdate.m_146922_(entityToUpdate.m_146908_() + diff);
        entityToUpdate.f_19859_ += diff;
        entityToUpdate.m_5616_(entityToUpdate.m_146908_());
    }

    public Vec3 m_7688_(LivingEntity livingEntity) {
        return super.m_7688_(livingEntity);
    }

    public ItemStack getItemStack() {
        ItemStack itemStack = this.getItem().m_7968_();
        CompoundTag compound = new CompoundTag();
        this.m_7380_(compound);
        compound.m_128405_("health", ((Integer)this.f_19804_.m_135370_(MAX_HEALTH)).intValue());
        compound.m_128379_("Used", true);
        itemStack.m_41700_("EntityTag", (Tag)compound);
        return itemStack;
    }

    protected Item getItem() {
        return (Item)SimplePlanesItems.PLANE_ITEM.get();
    }

    private void tickLerp() {
        if (this.m_6109_()) {
            this.lerpSteps = 0;
            this.lerpStepsQ = 0;
            this.m_20167_(this.m_20185_(), this.m_20186_(), this.m_20189_());
            return;
        }
        if (this.lerpSteps > 0) {
            double d0 = this.m_20185_() + (this.lerpX - this.m_20185_()) / (double)this.lerpSteps;
            double d1 = this.m_20186_() + (this.lerpY - this.m_20186_()) / (double)this.lerpSteps;
            double d2 = this.m_20189_() + (this.lerpZ - this.m_20189_()) / (double)this.lerpSteps;
            --this.lerpSteps;
            this.m_6034_(d0, d1, d2);
        }
        if (this.lerpStepsQ > 0) {
            this.setQ_prev(this.getQ_Client());
            this.setQ_Client(MathUtil.lerpQ(1.0f / (float)this.lerpStepsQ, this.getQ_Client(), this.getQ()));
            --this.lerpStepsQ;
        } else if (this.lerpStepsQ == 0) {
            this.setQ_prev(this.getQ_Client());
            this.setQ_Client(this.getQ());
            --this.lerpStepsQ;
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public void m_6453_(double x, double y, double z, float yaw, float pitch, int posRotationIncrements, boolean teleport) {
        if (x == this.m_20185_() && y == this.m_20186_() && z == this.m_20189_()) {
            return;
        }
        this.lerpX = x;
        this.lerpY = y;
        this.lerpZ = z;
        this.lerpSteps = 10;
    }

    public void m_19890_(double x, double y, double z, float yaw, float pitch) {
        double d0 = Mth.m_14008_((double)x, (double)-3.0E7, (double)3.0E7);
        double d1 = Mth.m_14008_((double)z, (double)-3.0E7, (double)3.0E7);
        this.f_19790_ = d0;
        this.f_19791_ = y;
        this.f_19792_ = d1;
        this.m_6034_(d0, y, d1);
        this.m_146922_(yaw % 360.0f);
        this.m_146926_(pitch % 360.0f);
        this.f_19859_ = this.m_146908_();
        this.f_19860_ = this.m_146909_();
    }

    protected void m_20348_(Entity passenger) {
        super.m_20348_(passenger);
        if (this.m_6109_()) {
            this.mountMessage = true;
            if (this.lerpSteps > 0) {
                this.lerpSteps = 0;
                this.m_19890_(this.lerpX, this.lerpY, this.lerpZ, this.m_146908_(), this.m_146909_());
            }
        }
    }

    public Player getPlayer() {
        if (this.m_6688_() instanceof Player) {
            return (Player)this.m_6688_();
        }
        return null;
    }

    private void setRockingTicks(int rockingTicks) {
        this.f_19804_.m_135381_(ROCKING_TICKS, (Object)rockingTicks);
    }

    private int getRockingTicks() {
        return (Integer)this.f_19804_.m_135370_(ROCKING_TICKS);
    }

    private void updateRocking() {
        if (this.f_19853_.f_46443_) {
            int i = this.getRockingTicks();
            this.rockingIntensity = i > 0 ? (this.rockingIntensity += 0.05f) : (this.rockingIntensity -= 0.1f);
            this.rockingIntensity = Mth.m_14036_((float)this.rockingIntensity, (float)0.0f, (float)1.0f);
            this.prevRockingAngle = this.rockingAngle;
            this.rockingAngle = 10.0f * (float)Math.sin(0.5f * (float)this.f_19853_.m_46467_()) * this.rockingIntensity;
        } else {
            int k;
            if (!this.rocking) {
                this.setRockingTicks(0);
            }
            if ((k = this.getRockingTicks()) > 0) {
                this.setRockingTicks(--k);
                int j = 60 - k - 1;
                if (j > 0 && k == 0) {
                    this.setRockingTicks(0);
                    Vec3 vector3d = this.m_20184_();
                    this.m_20334_(vector3d.f_82479_, this.m_146862_(entity -> entity instanceof Player) ? 2.7 : 0.6, vector3d.f_82481_);
                }
                this.rocking = false;
            }
        }
    }

    public float getRockingAngle(float partialTicks) {
        return Mth.m_14179_((float)partialTicks, (float)this.prevRockingAngle, (float)this.rockingAngle);
    }

    public void setTimeSinceHit(int timeSinceHit) {
        this.f_19804_.m_135381_(TIME_SINCE_HIT, (Object)timeSinceHit);
    }

    public int getTimeSinceHit() {
        return (Integer)this.f_19804_.m_135370_(TIME_SINCE_HIT);
    }

    public void setDamageTaken(float damageTaken) {
        this.f_19804_.m_135381_(DAMAGE_TAKEN, (Object)Float.valueOf(damageTaken));
    }

    public float getDamageTaken() {
        return ((Float)this.f_19804_.m_135370_(DAMAGE_TAKEN)).floatValue();
    }

    public double getCameraDistanceMultiplayer() {
        return 1.0;
    }

    public void writeUpdateUpgradePacket(ResourceLocation upgradeID, FriendlyByteBuf buffer) {
        buffer.m_130130_(this.m_142049_());
        buffer.m_130085_(upgradeID);
        this.upgrades.get(upgradeID).writePacket(buffer);
    }

    public void readUpdateUpgradePacket(ResourceLocation upgradeID, FriendlyByteBuf buffer, boolean newUpgrade) {
        if (newUpgrade) {
            UpgradeType upgradeType = (UpgradeType)SimplePlanesRegistries.UPGRADE_TYPES.getValue(upgradeID);
            Upgrade upgrade = upgradeType.instanceSupplier.apply(this);
            this.upgrades.put(upgradeID, upgrade);
            if (upgradeType.isEngine) {
                this.engineUpgrade = (EngineUpgrade)upgrade;
            }
        }
        this.upgrades.get(upgradeID).readPacket(buffer);
    }

    @Nonnull
    public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> cap, @Nullable Direction side) {
        if (this.upgrades != null) {
            for (Upgrade upgrade : this.upgrades.values()) {
                LazyOptional lazyOptional = upgrade.getCapability(cap, side);
                if (!lazyOptional.isPresent()) continue;
                return lazyOptional;
            }
        }
        return super.getCapability(cap, side);
    }

    public void writeSpawnData(FriendlyByteBuf buffer) {
        Collection<Upgrade> upgrades = this.upgrades.values();
        buffer.m_130130_(upgrades.size());
        for (Upgrade upgrade : upgrades) {
            ResourceLocation upgradeID = upgrade.getType().getRegistryName();
            buffer.m_130085_(upgradeID);
            upgrade.writePacket(buffer);
        }
    }

    public void readSpawnData(FriendlyByteBuf additionalData) {
        int upgradesSize = additionalData.m_130242_();
        for (int i = 0; i < upgradesSize; ++i) {
            ResourceLocation upgradeID = additionalData.m_130281_();
            UpgradeType upgradeType = (UpgradeType)SimplePlanesRegistries.UPGRADE_TYPES.getValue(upgradeID);
            Upgrade upgrade = upgradeType.instanceSupplier.apply(this);
            this.upgrades.put(upgradeID, upgrade);
            if (upgradeType.isEngine) {
                this.engineUpgrade = (EngineUpgrade)upgrade;
            }
            upgrade.readPacket(additionalData);
        }
    }

    public void removeUpgrade(ResourceLocation upgradeID) {
        Upgrade upgrade = this.upgrades.remove(upgradeID);
        if (upgrade != null) {
            upgrade.dropItems();
            upgrade.remove();
            if (!this.f_19853_.f_46443_) {
                PlaneNetworking.INSTANCE.send(PacketDistributor.TRACKING_ENTITY.with(() -> this), (Object)new SUpgradeRemovedPacket(upgradeID, this.m_142049_()));
            }
        }
    }

    protected static class TempMotionVars {
        public float moveForward;
        public double turnThreshold;
        public float moveStrafing;
        public boolean passengerSprinting;
        double maxSpeed;
        double maxPushSpeed;
        double takeOffSpeed;
        float maxLift;
        double liftFactor;
        double gravity;
        double drag;
        double dragMul;
        double dragQuad;
        float push;
        float groundPush;
        float passiveEnginePush;
        float motionToRotation;
        float pitchToMotion;
        float yawMultiplayer;

        public TempMotionVars() {
            this.reset();
        }

        public void reset() {
            this.moveForward = 0.0f;
            this.turnThreshold = 0.0;
            this.moveStrafing = 0.0f;
            this.passengerSprinting = false;
            this.maxSpeed = 3.0;
            this.takeOffSpeed = 0.3;
            this.maxLift = 2.0f;
            this.liftFactor = 10.0;
            this.gravity = -0.03;
            this.drag = 0.001;
            this.dragMul = 5.0E-4;
            this.dragQuad = 0.001;
            this.push = 0.06f;
            this.groundPush = 0.01f;
            this.passiveEnginePush = 0.025f;
            this.motionToRotation = 0.05f;
            this.pitchToMotion = 0.2f;
            this.yawMultiplayer = 0.5f;
        }
    }
}

