/*
 * Decompiled with CFR 0.152.
 */
package xyz.przemyk.simpleplanes.upgrades.booster;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Vector3f;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import xyz.przemyk.simpleplanes.MathUtil;
import xyz.przemyk.simpleplanes.client.render.UpgradesModels;
import xyz.przemyk.simpleplanes.entities.HelicopterEntity;
import xyz.przemyk.simpleplanes.entities.PlaneEntity;
import xyz.przemyk.simpleplanes.setup.SimplePlanesItems;
import xyz.przemyk.simpleplanes.setup.SimplePlanesUpgrades;
import xyz.przemyk.simpleplanes.upgrades.Upgrade;
import xyz.przemyk.simpleplanes.upgrades.UpgradeType;

public class BoosterUpgrade
extends Upgrade {
    public static final ResourceLocation TEXTURE = new ResourceLocation("simpleplanes", "textures/plane_upgrades/rocket.png");
    public static int FUEL_PER_GUNPOWDER = 20;
    public int fuel = 0;

    @Override
    public CompoundTag serializeNBT() {
        CompoundTag compoundNBT = new CompoundTag();
        compoundNBT.m_128405_("fuel", this.fuel);
        return compoundNBT;
    }

    @Override
    public void deserializeNBT(CompoundTag compoundNBT) {
        this.fuel = compoundNBT.m_128451_("fuel");
    }

    @Override
    public void writePacket(FriendlyByteBuf buffer) {
        buffer.m_130130_(this.fuel);
    }

    @Override
    public void readPacket(FriendlyByteBuf buffer) {
        this.fuel = buffer.m_130242_();
    }

    public BoosterUpgrade(PlaneEntity planeEntity) {
        super((UpgradeType)SimplePlanesUpgrades.BOOSTER.get(), planeEntity);
    }

    @Override
    public void tick() {
        this.push();
    }

    @Override
    public void onItemRightClick(PlayerInteractEvent.RightClickItem event) {
        ItemStack itemStack = event.getPlayer().m_21120_(event.getHand());
        if (this.fuel <= 0 && itemStack.m_41720_().equals(Items.f_42403_)) {
            if (!event.getPlayer().m_7500_()) {
                itemStack.m_41774_(1);
            }
            this.fuel = FUEL_PER_GUNPOWDER;
        }
        this.push();
    }

    private void push() {
        if (this.fuel < 0) {
            return;
        }
        --this.fuel;
        this.updateClient();
        Vec3 m = this.planeEntity.m_20184_();
        float pitch = 0.0f;
        Player player = this.planeEntity.getPlayer();
        if (player != null) {
            if (player.f_20902_ > 0.0f) {
                if (this.planeEntity.m_20142_()) {
                    pitch += 2.0f;
                }
            } else if (player.f_20902_ < 0.0f) {
                pitch -= 2.0f;
            }
        }
        if (this.planeEntity.f_19853_.f_46441_.nextInt(50) == 0) {
            this.planeEntity.m_6469_(DamageSource.f_19307_, 1.0f);
        }
        if (this.planeEntity instanceof HelicopterEntity) {
            pitch = 0.0f;
        }
        this.planeEntity.m_146926_(this.planeEntity.m_146909_() + pitch);
        Vec3 motion = MathUtil.rotationToVector(this.planeEntity.m_146908_(), this.planeEntity.m_146909_(), 0.05);
        this.planeEntity.m_20256_(m.m_82549_(motion));
        if (this.planeEntity.f_19853_.f_46443_) {
            this.spawnParticle((ParticleOptions)ParticleTypes.f_123744_, new Vector3f(-0.6f, 0.0f, -1.3f));
            this.spawnParticle((ParticleOptions)ParticleTypes.f_123744_, new Vector3f(0.6f, 0.0f, -1.3f));
        }
    }

    public void spawnParticle(ParticleOptions particleData, Vector3f relPos) {
        relPos = new Vector3f(relPos.m_122239_(), relPos.m_122260_() - 0.3f, relPos.m_122269_());
        relPos = this.planeEntity.transformPos(relPos);
        relPos = new Vector3f(relPos.m_122239_(), relPos.m_122260_() + 0.9f, relPos.m_122269_());
        Vec3 motion = this.planeEntity.m_20184_();
        double speed = motion.m_82553_() / 4.0;
        this.planeEntity.f_19853_.m_7106_(particleData, this.planeEntity.m_20185_() + (double)relPos.m_122239_(), this.planeEntity.m_20186_() + (double)relPos.m_122260_(), this.planeEntity.m_20189_() + (double)relPos.m_122269_(), motion.f_82479_ * speed, (motion.f_82480_ + 1.0) * speed, motion.f_82481_ * speed);
    }

    @Override
    public void render(PoseStack matrixStack, MultiBufferSource buffer, int packedLight, float partialTicks) {
        VertexConsumer ivertexbuilder = buffer.m_6299_(UpgradesModels.BOOSTER.m_103119_(TEXTURE));
        UpgradesModels.BOOSTER.m_7695_(matrixStack, ivertexbuilder, packedLight, OverlayTexture.f_118083_, 1.0f, 1.0f, 1.0f, 1.0f);
    }

    @Override
    public void dropItems() {
        this.planeEntity.m_19998_((ItemLike)SimplePlanesItems.BOOSTER.get());
    }
}

