/*
 * Decompiled with CFR 0.152.
 */
package xyz.przemyk.simpleplanes.upgrades.engines.electric;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Vector3f;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.HumanoidArm;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.energy.CapabilityEnergy;
import net.minecraftforge.energy.EnergyStorage;
import net.minecraftforge.fmllegacy.network.NetworkHooks;
import xyz.przemyk.simpleplanes.EnergyStorageWithSet;
import xyz.przemyk.simpleplanes.client.ClientEventHandler;
import xyz.przemyk.simpleplanes.client.ClientUtil;
import xyz.przemyk.simpleplanes.container.ElectricEngineContainer;
import xyz.przemyk.simpleplanes.entities.PlaneEntity;
import xyz.przemyk.simpleplanes.setup.SimplePlanesEntities;
import xyz.przemyk.simpleplanes.setup.SimplePlanesItems;
import xyz.przemyk.simpleplanes.setup.SimplePlanesUpgrades;
import xyz.przemyk.simpleplanes.upgrades.UpgradeType;
import xyz.przemyk.simpleplanes.upgrades.engines.EngineUpgrade;

public class ElectricEngineUpgrade
extends EngineUpgrade
implements MenuProvider {
    public static final int CAPACITY = 480000;
    public final EnergyStorageWithSet energyStorage = new EnergyStorageWithSet(480000);
    public final LazyOptional<EnergyStorage> energyStorageLazyOptional = LazyOptional.of(() -> this.energyStorage);

    public ElectricEngineUpgrade(PlaneEntity planeEntity) {
        super((UpgradeType)SimplePlanesUpgrades.ELECTRIC_ENGINE.get(), planeEntity);
    }

    @Override
    public void tick() {
        if (!this.planeEntity.getParked() && this.energyStorage.extractEnergy(40 * this.planeEntity.getFuelCost(), false) > 0) {
            this.updateClient();
        }
    }

    @Override
    public boolean isPowered() {
        return this.energyStorage.getEnergyStored() > 0;
    }

    @Override
    public void renderPowerHUD(PoseStack matrixStack, HumanoidArm side, int scaledWidth, int scaledHeight, float partialTicks) {
        int i = scaledWidth / 2;
        if (side == HumanoidArm.LEFT) {
            ClientEventHandler.blit(matrixStack, -90, i - 91 - 29, scaledHeight - 22, 38, 44, 22, 21);
        } else {
            ClientEventHandler.blit(matrixStack, -90, i + 91, scaledHeight - 22, 38, 44, 22, 21);
        }
        int energy = this.energyStorage.getEnergyStored();
        if (energy > 0) {
            int energyScaled = energy * 15 / 480000;
            if (side == HumanoidArm.LEFT) {
                ClientEventHandler.blit(matrixStack, -90, i - 91 - 29 + 3, scaledHeight - 22 + 16 - energyScaled, 60, 57 - energyScaled, 16, energyScaled + 2);
            } else {
                ClientEventHandler.blit(matrixStack, -90, i + 91 + 3, scaledHeight - 22 + 16 - energyScaled, 60, 57 - energyScaled, 16, energyScaled + 2);
            }
        }
    }

    @Override
    public void render(PoseStack matrixStack, MultiBufferSource buffer, int packedLight, float partialTicks) {
        matrixStack.m_85836_();
        EntityType entityType = this.planeEntity.m_6095_();
        if (entityType == SimplePlanesEntities.HELICOPTER.get()) {
            matrixStack.m_85837_(0.0, -0.8, 0.65);
        } else if (entityType == SimplePlanesEntities.LARGE_PLANE.get()) {
            matrixStack.m_85837_(0.0, 0.0, 1.1);
        }
        matrixStack.m_85845_(Vector3f.f_122227_.m_122240_(180.0f));
        matrixStack.m_85837_(-0.4, -1.0, 0.3);
        matrixStack.m_85841_(0.82f, 0.82f, 0.82f);
        ClientUtil.renderItemModelAsBlock(matrixStack, Minecraft.m_91087_(), buffer, packedLight, (Item)SimplePlanesItems.ELECTRIC_ENGINE.get());
        matrixStack.m_85849_();
    }

    public void invalidateCaps() {
        super.invalidateCaps();
        this.energyStorageLazyOptional.invalidate();
    }

    @Override
    public CompoundTag serializeNBT() {
        CompoundTag compoundNBT = new CompoundTag();
        compoundNBT.m_128405_("energy", this.energyStorage.getEnergyStored());
        return compoundNBT;
    }

    @Override
    public void deserializeNBT(CompoundTag nbt) {
        int energy = nbt.m_128451_("energy");
        this.energyStorage.setEnergy(Math.min(energy, 480000));
    }

    @Override
    public void writePacket(FriendlyByteBuf buffer) {
        buffer.m_130130_(this.energyStorage.getEnergyStored());
    }

    @Override
    public void readPacket(FriendlyByteBuf buffer) {
        this.energyStorage.setEnergy(buffer.m_130242_());
    }

    @Override
    public boolean canOpenGui() {
        return true;
    }

    @Override
    public void openGui(ServerPlayer playerEntity) {
        NetworkHooks.openGui((ServerPlayer)playerEntity, (MenuProvider)this, buffer -> buffer.m_130130_(this.planeEntity.m_142049_()));
    }

    public Component m_5446_() {
        return new TranslatableComponent("simpleplanes.electric_engine_container");
    }

    @Nullable
    public AbstractContainerMenu m_7208_(int id, Inventory playerInventory, Player playerEntity) {
        return new ElectricEngineContainer(id, playerInventory, this.planeEntity.m_142049_());
    }

    @Nonnull
    public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> cap, @Nullable Direction side) {
        if (cap == CapabilityEnergy.ENERGY) {
            return this.energyStorageLazyOptional.cast();
        }
        return super.getCapability(cap, side);
    }

    @Override
    public void dropItems() {
        this.planeEntity.m_19998_((ItemLike)SimplePlanesItems.ELECTRIC_ENGINE.get());
    }
}

