/*
 * Decompiled with CFR 0.152.
 */
package xyz.przemyk.simpleplanes.upgrades.engines.furnace;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Vector3f;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.HumanoidArm;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.fmllegacy.network.NetworkHooks;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemStackHandler;
import xyz.przemyk.simpleplanes.client.ClientEventHandler;
import xyz.przemyk.simpleplanes.client.ClientUtil;
import xyz.przemyk.simpleplanes.container.FurnaceEngineContainer;
import xyz.przemyk.simpleplanes.entities.PlaneEntity;
import xyz.przemyk.simpleplanes.setup.SimplePlanesEntities;
import xyz.przemyk.simpleplanes.setup.SimplePlanesItems;
import xyz.przemyk.simpleplanes.setup.SimplePlanesUpgrades;
import xyz.przemyk.simpleplanes.upgrades.UpgradeType;
import xyz.przemyk.simpleplanes.upgrades.engines.EngineUpgrade;

public class FurnaceEngineUpgrade
extends EngineUpgrade
implements MenuProvider {
    public final ItemStackHandler itemStackHandler = new ItemStackHandler();
    public final LazyOptional<ItemStackHandler> itemHandlerLazyOptional = LazyOptional.of(() -> this.itemStackHandler);
    public int burnTime;
    public int burnTimeTotal;

    public FurnaceEngineUpgrade(PlaneEntity planeEntity) {
        super((UpgradeType)SimplePlanesUpgrades.FURNACE_ENGINE.get(), planeEntity);
    }

    @Override
    public void tick() {
        if (this.burnTime > 0) {
            this.burnTime -= this.planeEntity.getFuelCost();
            this.updateClient();
        } else {
            ItemStack itemStack = this.itemStackHandler.getStackInSlot(0);
            int itemBurnTime = ForgeHooks.getBurnTime((ItemStack)itemStack, null);
            if (itemBurnTime > 0) {
                this.burnTimeTotal = itemBurnTime;
                this.burnTime = itemBurnTime;
                if (itemStack.hasContainerItem()) {
                    this.itemStackHandler.setStackInSlot(0, itemStack.getContainerItem());
                } else {
                    this.itemStackHandler.extractItem(0, 1, false);
                }
                this.updateClient();
            }
        }
    }

    @Override
    public boolean isPowered() {
        return this.burnTime > 0;
    }

    @Override
    public void render(PoseStack matrixStack, MultiBufferSource buffer, int packedLight, float partialTicks) {
        matrixStack.m_85836_();
        EntityType entityType = this.planeEntity.m_6095_();
        if (entityType == SimplePlanesEntities.HELICOPTER.get()) {
            matrixStack.m_85837_(0.0, -0.8, 0.65);
        } else if (entityType == SimplePlanesEntities.LARGE_PLANE.get()) {
            matrixStack.m_85837_(0.0, 0.0, 1.1);
        }
        matrixStack.m_85845_(Vector3f.f_122227_.m_122240_(180.0f));
        matrixStack.m_85837_(-0.4, -1.0, 0.3);
        matrixStack.m_85841_(0.82f, 0.82f, 0.82f);
        ClientUtil.renderItemModelAsBlock(matrixStack, Minecraft.m_91087_(), buffer, packedLight, (Item)SimplePlanesItems.FURNACE_ENGINE.get());
        matrixStack.m_85849_();
    }

    public void invalidateCaps() {
        super.invalidateCaps();
        this.itemHandlerLazyOptional.invalidate();
    }

    @Override
    public CompoundTag serializeNBT() {
        CompoundTag compound = new CompoundTag();
        compound.m_128365_("item", (Tag)this.itemStackHandler.serializeNBT());
        compound.m_128405_("burnTime", this.burnTime);
        compound.m_128405_("burnTimeTotal", this.burnTimeTotal);
        return compound;
    }

    @Override
    public void deserializeNBT(CompoundTag compound) {
        this.itemStackHandler.deserializeNBT(compound.m_128469_("item"));
        this.burnTime = compound.m_128451_("burnTime");
        this.burnTimeTotal = compound.m_128451_("burnTimeTotal");
    }

    @Override
    public void writePacket(FriendlyByteBuf buffer) {
        buffer.m_130055_(this.itemStackHandler.getStackInSlot(0));
        buffer.m_130130_(this.burnTime);
        buffer.m_130130_(this.burnTimeTotal);
    }

    @Override
    public void readPacket(FriendlyByteBuf buffer) {
        this.itemStackHandler.setStackInSlot(0, buffer.m_130267_());
        this.burnTime = buffer.m_130242_();
        this.burnTimeTotal = buffer.m_130242_();
    }

    @Override
    public boolean canOpenGui() {
        return true;
    }

    @Override
    public void openGui(ServerPlayer playerEntity) {
        NetworkHooks.openGui((ServerPlayer)playerEntity, (MenuProvider)this);
    }

    public Component m_5446_() {
        return new TranslatableComponent("simpleplanes.furnace_engine_container");
    }

    public AbstractContainerMenu m_7208_(int id, Inventory playerInventory, Player playerEntity) {
        return new FurnaceEngineContainer(id, playerInventory, (IItemHandler)this.itemStackHandler, new ContainerData(){

            public int m_6413_(int index) {
                if (index == 0) {
                    return FurnaceEngineUpgrade.this.burnTime;
                }
                return FurnaceEngineUpgrade.this.burnTimeTotal;
            }

            public void m_8050_(int index, int value) {
            }

            public int m_6499_() {
                return 2;
            }
        });
    }

    @Nonnull
    public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> cap, @Nullable Direction side) {
        if (cap == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            return this.itemHandlerLazyOptional.cast();
        }
        return super.getCapability(cap, side);
    }

    @Override
    public void dropItems() {
        this.planeEntity.m_19998_((ItemLike)SimplePlanesItems.FURNACE_ENGINE.get());
        this.planeEntity.m_19983_(this.itemStackHandler.getStackInSlot(0));
    }

    @Override
    public void renderPowerHUD(PoseStack matrixStack, HumanoidArm side, int scaledWidth, int scaledHeight, float partialTicks) {
        ItemStack fuelStack;
        int i = scaledWidth / 2;
        Minecraft mc = Minecraft.m_91087_();
        if (side == HumanoidArm.LEFT) {
            ClientEventHandler.blit(matrixStack, -90, i - 91 - 29, scaledHeight - 40, 0, 44, 22, 40);
        } else {
            ClientEventHandler.blit(matrixStack, -90, i + 91, scaledHeight - 40, 0, 44, 22, 40);
        }
        if (this.burnTime > 0) {
            int burnTimeTotal2 = this.burnTimeTotal == 0 ? 200 : this.burnTimeTotal;
            int burnLeftScaled = this.burnTime * 13 / burnTimeTotal2;
            if (side == HumanoidArm.LEFT) {
                ClientEventHandler.blit(matrixStack, -90, i - 91 - 29 + 4, scaledHeight - 40 + 16 - burnLeftScaled, 22, 56 - burnLeftScaled, 14, burnLeftScaled + 1);
            } else {
                ClientEventHandler.blit(matrixStack, -90, i + 91 + 4, scaledHeight - 40 + 16 - burnLeftScaled, 22, 56 - burnLeftScaled, 14, burnLeftScaled + 1);
            }
        }
        if (!(fuelStack = this.itemStackHandler.getStackInSlot(0)).m_41619_()) {
            int i2 = scaledHeight - 16 - 3;
            if (side == HumanoidArm.LEFT) {
                ClientEventHandler.renderHotbarItem(matrixStack, i - 91 - 26, i2, partialTicks, fuelStack, mc);
            } else {
                ClientEventHandler.renderHotbarItem(matrixStack, i + 91 + 3, i2, partialTicks, fuelStack, mc);
            }
        }
    }
}

