/*
 * Decompiled with CFR 0.152.
 */
package xyz.przemyk.simpleplanes.compat.jei;

import java.util.Arrays;
import java.util.stream.Stream;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.gui.IRecipeLayout;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.ingredient.IGuiItemStackGroup;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.ingredients.IIngredients;
import mezz.jei.api.recipe.category.IRecipeCategory;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.BlockTags;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import xyz.przemyk.simpleplanes.blocks.PlaneWorkbenchBlock;
import xyz.przemyk.simpleplanes.container.PlaneWorkbenchContainer;
import xyz.przemyk.simpleplanes.recipes.PlaneWorkbenchRecipe;
import xyz.przemyk.simpleplanes.setup.SimplePlanesBlocks;
import xyz.przemyk.simpleplanes.setup.SimplePlanesItems;

public class PlaneWorkbenchRecipeCategory
implements IRecipeCategory<PlaneWorkbenchRecipe> {
    public static final ResourceLocation ID = new ResourceLocation("simpleplanes", "plane_workbench");
    private final IDrawable background;
    private final IDrawable icon;

    public PlaneWorkbenchRecipeCategory(IGuiHelper guiHelper) {
        this.background = guiHelper.createDrawable(new ResourceLocation("jei", "textures/gui/gui_vanilla.png"), 0, 168, 125, 18);
        this.icon = guiHelper.createDrawableIngredient((Object)new ItemStack((ItemLike)SimplePlanesItems.PLANE_WORKBENCH.get()));
    }

    public ResourceLocation getUid() {
        return ID;
    }

    public Class<? extends PlaneWorkbenchRecipe> getRecipeClass() {
        return PlaneWorkbenchRecipe.class;
    }

    public Component getTitle() {
        return ((PlaneWorkbenchBlock)SimplePlanesBlocks.PLANE_WORKBENCH_BLOCK.get()).m_49954_();
    }

    public IDrawable getBackground() {
        return this.background;
    }

    public IDrawable getIcon() {
        return this.icon;
    }

    public void setIngredients(PlaneWorkbenchRecipe recipe, IIngredients ingredients) {
        Stream<ItemStack> materialStackStream = BlockTags.m_13115_().m_7689_(PlaneWorkbenchContainer.PLANE_MATERIALS).m_6497_().stream().map(block -> new ItemStack((ItemLike)block.m_5456_(), recipe.materialAmount()));
        ingredients.setInputIngredients(Arrays.asList(Ingredient.m_43921_(Arrays.stream(recipe.ingredient().m_43908_()).map(itemStack -> new ItemStack((ItemLike)itemStack.m_41720_(), recipe.ingredientAmount()))), Ingredient.m_43921_(materialStackStream)));
        ingredients.setOutput(VanillaTypes.ITEM, (Object)recipe.result());
    }

    public void setRecipe(IRecipeLayout recipeLayout, PlaneWorkbenchRecipe recipe, IIngredients ingredients) {
        IGuiItemStackGroup guiItemStacks = recipeLayout.getItemStacks();
        guiItemStacks.init(0, true, 0, 0);
        guiItemStacks.init(1, true, 49, 0);
        guiItemStacks.init(2, false, 107, 0);
        guiItemStacks.set(ingredients);
    }
}

