/*
 * Decompiled with CFR 0.152.
 */
package xyz.przemyk.simpleplanes.entities;

import com.mojang.math.Vector3f;
import java.util.List;
import java.util.Optional;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntitySelector;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.npc.Villager;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import xyz.przemyk.simpleplanes.entities.PlaneEntity;
import xyz.przemyk.simpleplanes.setup.SimplePlanesConfig;
import xyz.przemyk.simpleplanes.setup.SimplePlanesItems;
import xyz.przemyk.simpleplanes.setup.SimplePlanesUpgrades;
import xyz.przemyk.simpleplanes.upgrades.LargeUpgrade;
import xyz.przemyk.simpleplanes.upgrades.Upgrade;
import xyz.przemyk.simpleplanes.upgrades.UpgradeType;
import xyz.przemyk.simpleplanes.upgrades.tnt.TNTUpgrade;

public class LargePlaneEntity
extends PlaneEntity {
    public boolean hasLargeUpgrade = false;

    public LargePlaneEntity(EntityType<? extends LargePlaneEntity> entityTypeIn, Level worldIn) {
        super(entityTypeIn, worldIn);
    }

    @Override
    public void m_8119_() {
        super.m_8119_();
        List list = this.f_19853_.m_6249_((Entity)this, this.m_142469_().m_82377_((double)0.2f, (double)-0.01f, (double)0.2f), EntitySelector.m_20421_((Entity)this));
        for (Entity entity : list) {
            if (this.f_19853_.f_46443_ || this.m_6688_() instanceof Player || entity.m_20363_((Entity)this) || entity.m_20159_() || !(entity instanceof LivingEntity) || entity instanceof Player) continue;
            entity.m_20329_((Entity)this);
        }
    }

    @Override
    public boolean tryToAddUpgrade(Player playerEntity, ItemStack itemStack) {
        if (super.tryToAddUpgrade(playerEntity, itemStack)) {
            return true;
        }
        if (!this.hasLargeUpgrade && this.m_20197_().size() < 2) {
            Optional<UpgradeType> upgradeTypeOptional = SimplePlanesUpgrades.getLargeUpgradeFromItem(itemStack.m_41720_());
            return upgradeTypeOptional.map(upgradeType -> {
                if (this.canAddUpgrade((UpgradeType)((Object)upgradeType))) {
                    Upgrade upgrade = upgradeType.instanceSupplier.apply(this);
                    this.addUpgrade(playerEntity, itemStack, upgrade);
                    return true;
                }
                return false;
            }).orElse(false);
        }
        return false;
    }

    public boolean tryToAddTNT(Player playerEntity, ItemStack itemStack) {
        if (!this.hasLargeUpgrade && this.canAddUpgrade((UpgradeType)SimplePlanesUpgrades.TNT.get()) && this.m_20197_().size() < 2) {
            this.addUpgrade(playerEntity, itemStack, new TNTUpgrade(this));
            return true;
        }
        return false;
    }

    @Override
    protected float getGroundPitch() {
        return 10.0f;
    }

    @Override
    public int getFuelCost() {
        return (Integer)SimplePlanesConfig.LARGE_PLANE_FUEL_COST.get();
    }

    @Override
    protected boolean m_7310_(Entity passenger) {
        List passengers = this.m_20197_();
        if (passenger.m_20202_() == this || passenger instanceof PlaneEntity) {
            return false;
        }
        if (!this.upgrades.containsKey(SimplePlanesUpgrades.SEATS.getId())) {
            return passengers.size() <= 1 && (passengers.size() == 0 || !this.hasLargeUpgrade);
        }
        return this.hasLargeUpgrade ? passengers.size() < 3 : passengers.size() < 4;
    }

    @Override
    public void m_7332_(Entity passenger) {
        this.positionRiderGeneric(passenger);
        int index = this.m_20197_().indexOf(passenger);
        if (index == 0) {
            passenger.m_6034_(passenger.m_20185_(), this.m_20186_() + this.m_6048_() + this.getEntityYOffset(passenger), passenger.m_20189_());
        } else {
            if (this.hasLargeUpgrade) {
                ++index;
            }
            switch (index) {
                case 1: {
                    Vector3f pos = this.transformPos(this.getSecondPassengerPos(passenger));
                    passenger.m_6034_(this.m_20185_() + (double)pos.m_122239_(), this.m_20186_() + (double)pos.m_122260_(), this.m_20189_() + (double)pos.m_122269_());
                    break;
                }
                case 2: {
                    Vector3f pos = this.transformPos(new Vector3f(-1.0f, (float)(this.m_6048_() + passenger.m_6049_()), -0.5f));
                    passenger.m_6034_(this.m_20185_() + (double)pos.m_122239_(), this.m_20186_() + (double)pos.m_122260_(), this.m_20189_() + (double)pos.m_122269_());
                    break;
                }
                case 3: {
                    Vector3f pos = this.transformPos(new Vector3f(1.0f, (float)(this.m_6048_() + passenger.m_6049_()), -0.5f));
                    passenger.m_6034_(this.m_20185_() + (double)pos.m_122239_(), this.m_20186_() + (double)pos.m_122260_(), this.m_20189_() + (double)pos.m_122269_());
                }
            }
        }
    }

    protected Vector3f getSecondPassengerPos(Entity passenger) {
        return new Vector3f(0.0f, (float)(this.m_6048_() + this.getEntityYOffset(passenger)), -1.0f);
    }

    public double getEntityYOffset(Entity passenger) {
        if (passenger instanceof Villager) {
            return ((Villager)passenger).m_6162_() ? -0.1 : -0.3;
        }
        return passenger.m_6049_();
    }

    @Override
    public double getCameraDistanceMultiplayer() {
        return 1.2;
    }

    @Override
    protected Item getItem() {
        return (Item)SimplePlanesItems.LARGE_PLANE_ITEM.get();
    }

    public boolean hasStorageUpgrade() {
        if (this.hasLargeUpgrade) {
            for (Upgrade upgrade : this.upgrades.values()) {
                if (!(upgrade instanceof LargeUpgrade)) continue;
                LargeUpgrade largeUpgrade = (LargeUpgrade)upgrade;
                return largeUpgrade.hasStorage();
            }
        }
        return false;
    }
}

