/*
 * Decompiled with CFR 0.152.
 */
package xyz.przemyk.simpleplanes.setup;

import com.mojang.math.Quaternion;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.registries.DataSerializerEntry;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.RegistryObject;

public class SimplePlanesDataSerializers {
    public static final DeferredRegister<DataSerializerEntry> DATA_SERIALIZERS = DeferredRegister.create((IForgeRegistry)ForgeRegistries.DATA_SERIALIZERS, (String)"simpleplanes");
    public static final EntityDataSerializer<Quaternion> QUATERNION_SERIALIZER = new EntityDataSerializer<Quaternion>(){

        public void write(FriendlyByteBuf buf, Quaternion q) {
            buf.writeFloat(q.m_80140_());
            buf.writeFloat(q.m_80150_());
            buf.writeFloat(q.m_80153_());
            buf.writeFloat(q.m_80156_());
        }

        public Quaternion read(FriendlyByteBuf buf) {
            try {
                return new Quaternion(buf.readFloat(), buf.readFloat(), buf.readFloat(), buf.readFloat());
            }
            catch (IndexOutOfBoundsException e) {
                throw new RuntimeException("packet buffer does not contain enough data to construct plane's Quaternion", e);
            }
        }

        public Quaternion copy(Quaternion q) {
            return new Quaternion(q);
        }
    };
    public static final RegistryObject<DataSerializerEntry> QUATERNION_SERIALIZER_ENTRY = DATA_SERIALIZERS.register("quaternion", () -> new DataSerializerEntry(QUATERNION_SERIALIZER));

    public static void init() {
        DATA_SERIALIZERS.register(FMLJavaModLoadingContext.get().getModEventBus());
    }
}

