/*
 * Decompiled with CFR 0.152.
 */
package xyz.przemyk.simpleplanes.upgrades.armor;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.ItemRenderer;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.core.Registry;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.enchantment.Enchantments;
import xyz.przemyk.simpleplanes.client.render.UpgradesModels;
import xyz.przemyk.simpleplanes.entities.PlaneEntity;
import xyz.przemyk.simpleplanes.setup.SimplePlanesEntities;
import xyz.przemyk.simpleplanes.setup.SimplePlanesItems;
import xyz.przemyk.simpleplanes.setup.SimplePlanesUpgrades;
import xyz.przemyk.simpleplanes.upgrades.Upgrade;
import xyz.przemyk.simpleplanes.upgrades.UpgradeType;

public class ArmorUpgrade
extends Upgrade {
    public static final ResourceLocation TEXTURE = new ResourceLocation("simpleplanes", "textures/plane_upgrades/armor.png");
    public static final ResourceLocation TEXTURE_LARGE = new ResourceLocation("simpleplanes", "textures/plane_upgrades/large_armor.png");
    private int protectionLevel = 0;

    public ArmorUpgrade(PlaneEntity planeEntity) {
        super((UpgradeType)SimplePlanesUpgrades.ARMOR.get(), planeEntity);
    }

    @Override
    public void onApply(ItemStack itemStack, Player playerEntity) {
        ListTag listtag = itemStack.m_41785_();
        for (int i = 0; i < listtag.size(); ++i) {
            CompoundTag compoundtag = listtag.m_128728_(i);
            Registry.f_122825_.m_6612_(EnchantmentHelper.m_182446_((CompoundTag)compoundtag)).ifPresent(enchantment -> {
                if (enchantment == Enchantments.f_44965_) {
                    this.protectionLevel = EnchantmentHelper.m_182438_((CompoundTag)compoundtag);
                }
            });
        }
    }

    @Override
    public void render(PoseStack matrixStack, MultiBufferSource buffer, int packedLight, float partialTicks) {
        EntityType entityType = this.planeEntity.m_6095_();
        if (entityType == SimplePlanesEntities.LARGE_PLANE.get()) {
            VertexConsumer vertexconsumer = ItemRenderer.m_115184_((MultiBufferSource)buffer, (RenderType)RenderType.m_110431_((ResourceLocation)TEXTURE_LARGE), (boolean)false, (this.protectionLevel > 0 ? 1 : 0) != 0);
            UpgradesModels.LARGE_ARMOR.m_7695_(matrixStack, vertexconsumer, packedLight, OverlayTexture.f_118083_, 1.0f, 1.0f, 1.0f, 1.0f);
        } else {
            VertexConsumer vertexconsumer = ItemRenderer.m_115184_((MultiBufferSource)buffer, (RenderType)RenderType.m_110431_((ResourceLocation)TEXTURE), (boolean)false, (this.protectionLevel > 0 ? 1 : 0) != 0);
            UpgradesModels.ARMOR.m_7695_(matrixStack, vertexconsumer, packedLight, OverlayTexture.f_118083_, 1.0f, 1.0f, 1.0f, 1.0f);
        }
    }

    @Override
    public void writePacket(FriendlyByteBuf buffer) {
        buffer.writeByte(this.protectionLevel);
    }

    @Override
    public void readPacket(FriendlyByteBuf buffer) {
        this.protectionLevel = buffer.readByte();
    }

    @Override
    public void onRemoved() {
        ItemStack itemStack = ((Item)SimplePlanesItems.ARMOR.get()).m_7968_();
        if (this.protectionLevel > 0) {
            itemStack.m_41663_(Enchantments.f_44965_, this.protectionLevel);
        }
        this.planeEntity.m_19983_(itemStack);
    }

    public float getReducedDamage(float amount) {
        return amount * (1.0f - 0.04f * (float)this.getArmorValue());
    }

    public int getArmorValue() {
        return 15 + this.protectionLevel * 2;
    }

    @Override
    public CompoundTag serializeNBT() {
        CompoundTag compoundTag = new CompoundTag();
        compoundTag.m_128344_("protection", (byte)this.protectionLevel);
        return compoundTag;
    }

    @Override
    public void deserializeNBT(CompoundTag nbt) {
        this.protectionLevel = nbt.m_128445_("protection");
    }
}

