/*
 * Decompiled with CFR 0.152.
 */
package xyz.przemyk.simpleplanes.upgrades.banner;

import com.mojang.blaze3d.vertex.PoseStack;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BannerItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import xyz.przemyk.simpleplanes.MathUtil;
import xyz.przemyk.simpleplanes.entities.PlaneEntity;
import xyz.przemyk.simpleplanes.setup.SimplePlanesUpgrades;
import xyz.przemyk.simpleplanes.upgrades.Upgrade;
import xyz.przemyk.simpleplanes.upgrades.UpgradeType;
import xyz.przemyk.simpleplanes.upgrades.banner.BannerModel;

public class BannerUpgrade
extends Upgrade {
    public ItemStack banner = Items.f_42660_.m_7968_();
    public float rotation;
    public float prevRotation;

    public BannerUpgrade(PlaneEntity planeEntity) {
        super((UpgradeType)SimplePlanesUpgrades.BANNER.get(), planeEntity);
        this.prevRotation = planeEntity.f_19859_;
        this.rotation = planeEntity.f_19859_;
    }

    @Override
    public void tick() {
        this.prevRotation = this.rotation;
        this.rotation = MathUtil.lerpAngle(0.05f, this.rotation, this.planeEntity.f_19859_);
    }

    @Override
    public CompoundTag serializeNBT() {
        CompoundTag compoundNBT = new CompoundTag();
        compoundNBT.m_128365_("banner", (Tag)this.banner.serializeNBT());
        return compoundNBT;
    }

    @Override
    public void deserializeNBT(CompoundTag nbt) {
        Tag banner = nbt.m_128423_("banner");
        if (banner instanceof CompoundTag) {
            this.banner = ItemStack.m_41712_((CompoundTag)((CompoundTag)banner));
        }
    }

    @Override
    public void render(PoseStack matrixStack, MultiBufferSource buffer, int packedLight, float partialTicks) {
        BannerModel.renderBanner(this, partialTicks, matrixStack, buffer, this.banner, packedLight);
    }

    @Override
    public void onApply(ItemStack itemStack, Player playerEntity) {
        if (itemStack.m_41720_() instanceof BannerItem) {
            this.banner = itemStack.m_41777_();
            this.banner.m_41764_(1);
            this.updateClient();
        }
    }

    @Override
    public void writePacket(FriendlyByteBuf buffer) {
        buffer.m_130055_(this.banner);
    }

    @Override
    public void readPacket(FriendlyByteBuf buffer) {
        this.banner = buffer.m_130267_();
    }

    @Override
    public void onRemoved() {
        this.planeEntity.m_19983_(this.banner);
    }
}

