/*
 * Decompiled with CFR 0.152.
 */
package xyz.przemyk.simpleplanes.entities;

import com.mojang.math.Quaternion;
import com.mojang.math.Vector3f;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Registry;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.TagKey;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.SimpleMenuProvider;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Explosion;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.dimension.DimensionType;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.entity.IEntityAdditionalSpawnData;
import net.minecraftforge.network.NetworkHooks;
import net.minecraftforge.network.PacketDistributor;
import net.minecraftforge.registries.DataSerializerEntry;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistryEntry;
import xyz.przemyk.simpleplanes.SimplePlanesMod;
import xyz.przemyk.simpleplanes.client.PlaneSound;
import xyz.przemyk.simpleplanes.container.RemoveUpgradesContainer;
import xyz.przemyk.simpleplanes.misc.MathUtil;
import xyz.przemyk.simpleplanes.network.ChangeThrottlePacket;
import xyz.przemyk.simpleplanes.network.RotationPacket;
import xyz.przemyk.simpleplanes.network.SUpgradeRemovedPacket;
import xyz.przemyk.simpleplanes.network.SimplePlanesNetworking;
import xyz.przemyk.simpleplanes.network.UpdateUpgradePacket;
import xyz.przemyk.simpleplanes.setup.SimplePlanesConfig;
import xyz.przemyk.simpleplanes.setup.SimplePlanesDataSerializers;
import xyz.przemyk.simpleplanes.setup.SimplePlanesItems;
import xyz.przemyk.simpleplanes.setup.SimplePlanesRegistries;
import xyz.przemyk.simpleplanes.setup.SimplePlanesUpgrades;
import xyz.przemyk.simpleplanes.upgrades.Upgrade;
import xyz.przemyk.simpleplanes.upgrades.UpgradeType;
import xyz.przemyk.simpleplanes.upgrades.armor.ArmorUpgrade;
import xyz.przemyk.simpleplanes.upgrades.engines.EngineUpgrade;
import xyz.przemyk.simpleplanes.upgrades.shooter.ShooterUpgrade;

public class PlaneEntity
extends Entity
implements IEntityAdditionalSpawnData {
    public static final EntityDataAccessor<Integer> MAX_HEALTH = SynchedEntityData.m_135353_(PlaneEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    public static final EntityDataAccessor<Integer> HEALTH = SynchedEntityData.m_135353_(PlaneEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    public static final EntityDataAccessor<Float> MAX_SPEED = SynchedEntityData.m_135353_(PlaneEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135029_);
    public static final EntityDataAccessor<String> MATERIAL = SynchedEntityData.m_135353_(PlaneEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135030_);
    public static final EntityDataAccessor<Integer> TIME_SINCE_HIT = SynchedEntityData.m_135353_(PlaneEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    public static final EntityDataAccessor<Float> DAMAGE_TAKEN = SynchedEntityData.m_135353_(PlaneEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135029_);
    public static final EntityDataAccessor<Quaternion> Q = SynchedEntityData.m_135353_(PlaneEntity.class, (EntityDataSerializer)((DataSerializerEntry)SimplePlanesDataSerializers.QUATERNION_SERIALIZER_ENTRY.get()).getSerializer());
    public static final EntityDataAccessor<Integer> THROTTLE = SynchedEntityData.m_135353_(PlaneEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    public static final EntityDataAccessor<Byte> PITCH_UP = SynchedEntityData.m_135353_(PlaneEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135027_);
    public static final EntityDataAccessor<Byte> YAW_RIGHT = SynchedEntityData.m_135353_(PlaneEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135027_);
    public static final int MAX_THROTTLE = 5;
    public Quaternion Q_Client = new Quaternion(Quaternion.f_80118_);
    public Quaternion Q_Prev = new Quaternion(Quaternion.f_80118_);
    private int onGroundTicks;
    public final HashMap<ResourceLocation, Upgrade> upgrades = new HashMap();
    public EngineUpgrade engineUpgrade = null;
    public float rotationRoll;
    public float prevRotationRoll;
    private float deltaRotation;
    private float deltaRotationLeft;
    private int deltaRotationTicks;
    private Block planksMaterial;
    private int damageTimeout;
    public int notMovingTime;
    public int goldenHeartsTimeout = 0;
    private final int networkUpdateInterval;
    public float propellerRotationOld;
    public float propellerRotationNew;
    public static final TagKey<DimensionType> BLACKLISTED_DIMENSIONS_TAG = TagKey.m_203882_((ResourceKey)Registry.f_122818_, (ResourceLocation)new ResourceLocation("simpleplanes", "blacklisted_dimensions"));
    protected float pitchSpeed = 0.0f;
    protected float yawSpeed = 0.0f;
    protected float rollSpeed = 0.0f;
    public static final TagKey<Block> FIREPROOF_MATERIALS_TAG = BlockTags.create((ResourceLocation)new ResourceLocation("simpleplanes", "fireproof_materials"));
    private int lerpSteps;
    private int lerpStepsQ;
    private double lerpX;
    private double lerpY;
    private double lerpZ;
    private static final TempMotionVars TEMP_MOTION_VARS = new TempMotionVars();

    public PlaneEntity(EntityType<? extends PlaneEntity> entityTypeIn, Level worldIn) {
        this(entityTypeIn, worldIn, Blocks.f_50705_);
    }

    public PlaneEntity(EntityType<? extends PlaneEntity> entityTypeIn, Level worldIn, Block material) {
        super(entityTypeIn, worldIn);
        this.networkUpdateInterval = entityTypeIn.m_20682_();
        this.f_19793_ = 0.9999f;
        this.setMaterial(material);
        this.setMaxSpeed(1.0f);
    }

    public PlaneEntity(EntityType<? extends PlaneEntity> entityTypeIn, Level worldIn, Block material, double x, double y, double z) {
        this(entityTypeIn, worldIn, material);
        this.m_6034_(x, y, z);
    }

    protected void m_8097_() {
        this.f_19804_.m_135372_(MAX_HEALTH, (Object)10);
        this.f_19804_.m_135372_(HEALTH, (Object)10);
        this.f_19804_.m_135372_(Q, (Object)Quaternion.f_80118_);
        this.f_19804_.m_135372_(MAX_SPEED, (Object)Float.valueOf(0.25f));
        this.f_19804_.m_135372_(MATERIAL, (Object)ForgeRegistries.BLOCKS.getKey((IForgeRegistryEntry)Blocks.f_50705_).toString());
        this.f_19804_.m_135372_(TIME_SINCE_HIT, (Object)0);
        this.f_19804_.m_135372_(DAMAGE_TAKEN, (Object)Float.valueOf(0.0f));
        this.f_19804_.m_135372_(THROTTLE, (Object)0);
        this.f_19804_.m_135372_(PITCH_UP, (Object)0);
        this.f_19804_.m_135372_(YAW_RIGHT, (Object)0);
    }

    public float getMaxSpeed() {
        return ((Float)this.f_19804_.m_135370_(MAX_SPEED)).floatValue();
    }

    public void setMaxSpeed(float maxSpeed) {
        this.f_19804_.m_135381_(MAX_SPEED, (Object)Float.valueOf(maxSpeed));
    }

    public Quaternion getQ() {
        return new Quaternion((Quaternion)this.f_19804_.m_135370_(Q));
    }

    public void setQ(Quaternion q) {
        this.f_19804_.m_135381_(Q, (Object)q);
    }

    public Quaternion getQ_Client() {
        return new Quaternion(this.Q_Client);
    }

    public void setQ_Client(Quaternion q) {
        this.Q_Client = q;
    }

    public Quaternion getQ_Prev() {
        return this.Q_Prev.m_80161_();
    }

    public void setQ_prev(Quaternion q) {
        this.Q_Prev = q;
    }

    public Block getMaterial() {
        return this.planksMaterial;
    }

    public void setHealth(int health) {
        this.f_19804_.m_135381_(HEALTH, (Object)Math.max(health, 0));
    }

    public int getHealth() {
        return (Integer)this.f_19804_.m_135370_(HEALTH);
    }

    public int getMaxHealth() {
        return (Integer)this.f_19804_.m_135370_(MAX_HEALTH);
    }

    public ItemStack getPickedResult(HitResult target) {
        return this.getItemStack();
    }

    public void setMaterial(String material) {
        this.f_19804_.m_135381_(MATERIAL, (Object)material);
        Block block = (Block)ForgeRegistries.BLOCKS.getValue(new ResourceLocation(material));
        this.planksMaterial = block == null ? Blocks.f_50705_ : block;
    }

    public void setMaterial(Block material) {
        this.f_19804_.m_135381_(MATERIAL, (Object)ForgeRegistries.BLOCKS.getKey((IForgeRegistryEntry)material).toString());
        this.planksMaterial = material;
    }

    public boolean isPowered() {
        return this.m_6084_() && !this.f_19853_.m_204156_().m_203656_(BLACKLISTED_DIMENSIONS_TAG) && (this.isCreative() || this.engineUpgrade != null && this.engineUpgrade.isPowered());
    }

    protected boolean m_7310_(Entity passenger) {
        List passengers = this.m_20197_();
        if (!this.upgrades.containsKey(SimplePlanesUpgrades.SEATS.getId())) {
            return passengers.isEmpty();
        }
        return passengers.size() < 3;
    }

    public InteractionResult m_6096_(Player player, InteractionHand hand) {
        ItemStack itemStack = player.m_21120_(hand);
        if (player.m_6144_() && itemStack.m_41619_()) {
            boolean hasPlayer = false;
            for (Entity passenger : this.m_20197_()) {
                if (!(passenger instanceof Player)) continue;
                hasPlayer = true;
                break;
            }
            if (!hasPlayer || ((Boolean)SimplePlanesConfig.THIEF.get()).booleanValue()) {
                this.m_20153_();
            }
            return InteractionResult.SUCCESS;
        }
        if (itemStack.m_41720_() == SimplePlanesItems.WRENCH.get()) {
            if (!this.f_19853_.f_46443_) {
                NetworkHooks.openGui((ServerPlayer)((ServerPlayer)player), (MenuProvider)new SimpleMenuProvider((id, inv, p) -> new RemoveUpgradesContainer(id, this.m_142049_()), TextComponent.f_131282_), buf -> buf.m_130130_(this.m_142049_()));
                return InteractionResult.CONSUME;
            }
            return InteractionResult.SUCCESS;
        }
        if (this.tryToAddUpgrade(player, itemStack)) {
            return InteractionResult.SUCCESS;
        }
        if (!this.f_19853_.f_46443_) {
            return player.m_20329_((Entity)this) ? InteractionResult.CONSUME : InteractionResult.FAIL;
        }
        return player.m_20201_() == this.m_20201_() ? InteractionResult.FAIL : InteractionResult.SUCCESS;
    }

    protected boolean tryToAddUpgrade(Player playerEntity, ItemStack itemStack) {
        Optional<UpgradeType> upgradeTypeOptional = SimplePlanesUpgrades.getUpgradeFromItem(itemStack.m_41720_());
        return upgradeTypeOptional.map(upgradeType -> {
            if (this.canAddUpgrade((UpgradeType)((Object)upgradeType))) {
                Upgrade upgrade = upgradeType.instanceSupplier.apply(this);
                this.addUpgrade(playerEntity, itemStack, upgrade);
                return true;
            }
            return false;
        }).orElse(false);
    }

    protected void addUpgrade(Player playerEntity, ItemStack itemStack, Upgrade upgrade) {
        upgrade.onApply(itemStack, playerEntity);
        if (!playerEntity.m_7500_()) {
            itemStack.m_41774_(1);
        }
        UpgradeType upgradeType = upgrade.getType();
        this.upgrades.put(SimplePlanesRegistries.UPGRADE_TYPES.get().getKey((IForgeRegistryEntry)upgradeType), upgrade);
        if (upgradeType.isEngine) {
            this.engineUpgrade = (EngineUpgrade)upgrade;
        }
        if (!this.f_19853_.f_46443_) {
            SimplePlanesNetworking.INSTANCE.send(PacketDistributor.TRACKING_ENTITY.with(() -> this), (Object)new UpdateUpgradePacket(SimplePlanesRegistries.UPGRADE_TYPES.get().getKey((IForgeRegistryEntry)upgradeType), this.m_142049_(), (ServerLevel)this.f_19853_, true));
        }
    }

    public boolean m_6469_(DamageSource source, float amount) {
        boolean creativePlayer;
        Entity entity = source.m_7640_();
        if (entity == this.m_6688_() && entity instanceof Player) {
            Player player = (Player)entity;
            Upgrade upgrade = this.upgrades.get(SimplePlanesUpgrades.SHOOTER.getId());
            if (upgrade instanceof ShooterUpgrade) {
                ShooterUpgrade shooterUpgrade = (ShooterUpgrade)upgrade;
                shooterUpgrade.use(player);
            }
            return false;
        }
        if (this.getOnGround() && entity instanceof Player) {
            amount *= 3.0f;
        } else {
            Upgrade upgrade = this.upgrades.get(SimplePlanesUpgrades.ARMOR.getId());
            if (upgrade instanceof ArmorUpgrade) {
                ArmorUpgrade armorUpgrade = (ArmorUpgrade)upgrade;
                amount = armorUpgrade.getReducedDamage(amount);
            }
        }
        this.setTimeSinceHit(20);
        this.setDamageTaken(this.getDamageTaken() + 10.0f * amount);
        if (this.m_6673_(source) || this.damageTimeout > 0) {
            return false;
        }
        if (this.f_19853_.f_46443_ || this.m_146910_()) {
            return false;
        }
        int health = this.getHealth();
        if (health < 0) {
            return false;
        }
        this.setHealth((int)((float)health - amount));
        this.damageTimeout = 10;
        boolean isPlayer = source.m_7640_() instanceof Player;
        boolean bl = creativePlayer = isPlayer && ((Player)source.m_7639_()).m_150110_().f_35937_;
        if (creativePlayer) {
            this.m_6074_();
        } else if (source == SimplePlanesMod.DAMAGE_SOURCE_PLANE_CRASH) {
            this.explode();
            this.m_6074_();
            if (this.f_19853_.m_46469_().m_46207_(GameRules.f_46137_)) {
                this.dropItem();
            }
        } else if (this.getOnGround() && this.getHealth() <= 0) {
            this.m_6074_();
            if (this.f_19853_.m_46469_().m_46207_(GameRules.f_46137_)) {
                this.dropItem();
            }
        }
        return true;
    }

    private void explode() {
        ((ServerLevel)this.f_19853_).m_8767_((ParticleOptions)ParticleTypes.f_123762_, this.m_20185_(), this.m_20186_(), this.m_20189_(), 5, 1.0, 1.0, 1.0, 2.0);
        ((ServerLevel)this.f_19853_).m_8767_((ParticleOptions)ParticleTypes.f_123759_, this.m_20185_(), this.m_20186_(), this.m_20189_(), 10, 1.0, 1.0, 1.0, 1.0);
        this.f_19853_.m_46511_((Entity)this, this.m_20185_(), this.m_20186_(), this.m_20189_(), 4.0f, Explosion.BlockInteraction.BREAK);
    }

    protected void dropItem() {
        ItemStack itemStack = this.getItemStack();
        this.m_19983_(itemStack).m_20331_(true);
    }

    public boolean m_6087_() {
        return true;
    }

    public void m_8119_() {
        Entity controllingPassenger;
        super.m_8119_();
        if (Double.isNaN(this.m_20184_().m_82553_())) {
            this.m_20256_(Vec3.f_82478_);
        }
        this.f_19859_ = this.m_146908_();
        this.f_19860_ = this.m_146909_();
        this.prevRotationRoll = this.rotationRoll;
        if (this.f_19853_.f_46443_) {
            this.propellerRotationOld = this.propellerRotationNew;
            if (this.isPowered()) {
                int throttle = this.getThrottle();
                this.propellerRotationNew = (float)((double)this.propellerRotationNew + (double)throttle * 0.1);
            }
        }
        if (this.f_19853_.f_46443_ && this.getHealth() <= 0) {
            this.f_19853_.m_6485_((ParticleOptions)ParticleTypes.f_123755_, true, this.m_20185_(), this.m_20186_(), this.m_20189_(), 0.0, 0.005, 0.0);
        }
        if (this.f_19853_.f_46443_ && this.getTimeSinceHit() > 0) {
            this.setTimeSinceHit(this.getTimeSinceHit() - 1);
        }
        if (this.f_19853_.f_46443_ && !this.m_6109_()) {
            this.tickLerp();
            this.m_20256_(Vec3.f_82478_);
            this.tickDeltaRotation(this.getQ_Client());
            this.tickUpgrades();
            return;
        }
        this.m_5834_();
        TempMotionVars tempMotionVars = this.getMotionVars();
        if (this.m_20068_()) {
            tempMotionVars.gravity = 0.0;
            tempMotionVars.maxLift = 0.0f;
            tempMotionVars.push = 0.0f;
            tempMotionVars.passiveEnginePush = 0.0f;
        }
        if ((controllingPassenger = this.m_6688_()) instanceof Player) {
            Player playerEntity = (Player)controllingPassenger;
            tempMotionVars.moveForward = this.getMoveForward(playerEntity);
            tempMotionVars.moveStrafing = playerEntity.f_20900_;
        } else {
            tempMotionVars.moveForward = 0.0f;
            tempMotionVars.moveStrafing = 0.0f;
            this.m_6858_(false);
        }
        tempMotionVars.turnThreshold = (double)((Integer)SimplePlanesConfig.TURN_THRESHOLD.get()).intValue() / 100.0;
        if ((double)Math.abs(tempMotionVars.moveStrafing) < tempMotionVars.turnThreshold) {
            tempMotionVars.moveStrafing = 0.0f;
        }
        Quaternion q = this.f_19853_.f_46443_ ? this.getQ_Client() : this.getQ();
        MathUtil.EulerAngles anglesOld = MathUtil.toEulerAngles(q).copy();
        Vec3 oldMotion = this.m_20184_();
        if (this.f_19853_.f_46443_ && this.isPowered() && this.getThrottle() > 0) {
            PlaneSound.tryToPlay(this);
        }
        tempMotionVars.push = 0.00625f * (float)this.getThrottle();
        if (this.m_20184_().m_82553_() > 0.05) {
            q = this.tickRotateMotion(tempMotionVars, q, this.m_20184_());
        }
        boolean doPitch = true;
        if (this.getOnGround() || this.isOnWater()) {
            doPitch = this.tickOnGround(tempMotionVars);
        } else {
            --this.onGroundTicks;
        }
        if (doPitch) {
            this.tickPitch(tempMotionVars);
        }
        this.tickYaw();
        this.tickMotion(tempMotionVars);
        this.tickRoll(tempMotionVars);
        this.tickUpgrades();
        if (this.onGroundTicks > -50 && oldMotion.m_82553_() < 0.002 && this.m_20184_().m_82553_() < 0.002) {
            this.m_20256_(Vec3.f_82478_);
        }
        this.m_20090_();
        if (!this.f_19861_ || MathUtil.getHorizontalDistanceSqr(this.m_20184_()) > (double)1.0E-5f || (this.f_19797_ + this.m_142049_()) % 4 == 0) {
            double speedBefore = Math.sqrt(MathUtil.getHorizontalDistanceSqr(this.m_20184_()));
            boolean onGroundOld = this.f_19861_;
            Vec3 motion = this.m_20184_();
            if (motion.m_82556_() > 0.25 || this.getPitchUp() != 0) {
                this.f_19861_ = true;
            }
            this.m_6478_(MoverType.SELF, motion);
            boolean bl = this.f_19861_ = motion.m_7098_() == 0.0 ? onGroundOld : this.f_19861_;
            if (this.f_19862_ && !this.f_19853_.f_46443_ && this.onGroundTicks <= 0) {
                if (this.getHealth() <= 0) {
                    this.crash(16.0f);
                } else {
                    double speedAfter = Math.sqrt(MathUtil.getHorizontalDistanceSqr(this.m_20184_()));
                    double speedDiff = speedBefore - speedAfter;
                    float f2 = (float)(speedDiff * 10.0 - 5.0);
                    if (f2 > 5.0f) {
                        this.crash(f2);
                    }
                }
            }
        }
        if (this.getHealth() <= 0 && this.f_19861_ && !this.m_146910_()) {
            this.crash(16.0f);
        }
        q.m_80148_(new Quaternion(Vector3f.f_122227_, (float)((double)this.rotationRoll - anglesOld.roll), true));
        q.m_80148_(new Quaternion(Vector3f.f_122222_, (float)((double)this.m_146909_() - anglesOld.pitch), true));
        q.m_80148_(new Quaternion(Vector3f.f_122225_, (float)((double)this.m_146908_() - anglesOld.yaw), true));
        q = MathUtil.normalizeQuaternion(q);
        this.setQ_prev(this.getQ_Client());
        this.setQ(q);
        this.tickDeltaRotation(q);
        if (this.f_19853_.f_46443_ && this.m_6109_()) {
            this.setQ_Client(q);
            SimplePlanesNetworking.INSTANCE.sendToServer((Object)new RotationPacket(this.getQ()));
        } else {
            ServerPlayer player = (ServerPlayer)this.getPlayer();
            if (player != null) {
                player.f_8906_.f_9739_ = 0;
            }
        }
        if (this.damageTimeout > 0) {
            --this.damageTimeout;
        }
        if (this.getDamageTaken() > 0.0f) {
            this.setDamageTaken(this.getDamageTaken() - 1.0f);
        }
        if (!this.f_19853_.f_46443_ && this.getHealth() > this.getMaxHealth() & this.goldenHeartsTimeout > (this.getOnGround() ? 300 : 100)) {
            this.setHealth(this.getHealth() - 1);
            this.goldenHeartsTimeout = 0;
        }
        if (this.goldenHeartsTimeout < 1000 && this.isPowered()) {
            ++this.goldenHeartsTimeout;
        }
        this.tickLerp();
    }

    protected float getMoveForward(Player player) {
        return player.f_20902_;
    }

    public void tickUpgrades() {
        ArrayList upgradesToRemove = new ArrayList();
        this.upgrades.forEach((rl, upgrade) -> {
            upgrade.tick();
            if (upgrade.removed) {
                upgradesToRemove.add(rl);
            }
        });
        for (ResourceLocation name : upgradesToRemove) {
            this.upgrades.remove(name);
        }
        if (!this.f_19853_.f_46443_ && this.f_19797_ % this.networkUpdateInterval == 0) {
            this.upgrades.forEach((rl, upgrade) -> {
                if (upgrade.updateClient) {
                    SimplePlanesNetworking.INSTANCE.send(PacketDistributor.TRACKING_ENTITY.with(() -> this), (Object)new UpdateUpgradePacket((ResourceLocation)rl, this.m_142049_(), (ServerLevel)this.f_19853_));
                    upgrade.updateClient = false;
                }
            });
        }
    }

    public int getFuelCost() {
        return (Integer)SimplePlanesConfig.PLANE_FUEL_COST.get();
    }

    protected TempMotionVars getMotionVars() {
        TEMP_MOTION_VARS.reset();
        PlaneEntity.TEMP_MOTION_VARS.maxPushSpeed = this.getMaxSpeed() * 10.0f;
        return TEMP_MOTION_VARS;
    }

    protected void tickDeltaRotation(Quaternion q) {
        MathUtil.EulerAngles angles = MathUtil.toEulerAngles(q);
        this.m_146926_((float)angles.pitch);
        this.m_146922_((float)angles.yaw);
        this.rotationRoll = (float)angles.roll;
        float d = (float)MathUtil.wrapSubtractDegrees(this.f_19859_, this.m_146908_());
        if (this.rotationRoll >= 90.0f && this.prevRotationRoll <= 90.0f) {
            d = 0.0f;
        }
        int diff = 3;
        this.deltaRotationTicks = Math.min(10, Math.max((int)Math.abs(this.deltaRotationLeft) * 5, this.deltaRotationTicks));
        this.deltaRotationLeft = (float)((double)this.deltaRotationLeft * 0.7);
        this.deltaRotationLeft += d;
        this.deltaRotationLeft = Mth.m_14177_((float)this.deltaRotationLeft);
        this.deltaRotation = Math.min(Math.abs(this.deltaRotationLeft), (float)diff) * Math.signum(this.deltaRotationLeft);
        this.deltaRotationLeft -= this.deltaRotation;
        if (!(this.deltaRotation > 0.0f)) {
            --this.deltaRotationTicks;
        }
    }

    protected float getRotationSpeedMultiplier() {
        return 1.0f;
    }

    protected void tickPitch(TempMotionVars tempMotionVars) {
        float pitch;
        if (this.getHealth() <= 0) {
            pitch = 10.0f;
        } else {
            if (this.getPitchUp() > 0) {
                this.pitchSpeed += 0.5f * this.getRotationSpeedMultiplier();
            } else if (this.getPitchUp() < 0) {
                this.pitchSpeed -= 0.5f * this.getRotationSpeedMultiplier();
            } else if (this.pitchSpeed < 0.0f) {
                this.pitchSpeed += 0.5f * this.getRotationSpeedMultiplier();
            } else if (this.pitchSpeed > 0.0f) {
                this.pitchSpeed -= 0.5f * this.getRotationSpeedMultiplier();
            }
            pitch = this.pitchSpeed = Mth.m_14036_((float)this.pitchSpeed, (float)(-5.0f * this.getRotationSpeedMultiplier()), (float)(5.0f * this.getRotationSpeedMultiplier()));
        }
        this.m_146926_(this.m_146909_() + pitch);
    }

    protected void tickYaw() {
        float yaw;
        if (this.getHealth() <= 0) {
            yaw = 10.0f;
        } else {
            if (this.getYawRight() > 0) {
                this.yawSpeed += 0.5f * this.getRotationSpeedMultiplier();
            } else if (this.getYawRight() < 0) {
                this.yawSpeed -= 0.5f * this.getRotationSpeedMultiplier();
            } else if (this.yawSpeed < 0.0f) {
                this.yawSpeed += 0.5f * this.getRotationSpeedMultiplier();
            } else if (this.yawSpeed > 0.0f) {
                this.yawSpeed -= 0.5f * this.getRotationSpeedMultiplier();
            }
            yaw = this.yawSpeed = Mth.m_14036_((float)this.yawSpeed, (float)(-2.5f * this.getRotationSpeedMultiplier()), (float)(2.5f * this.getRotationSpeedMultiplier()));
        }
        this.m_146922_(this.m_146908_() + yaw);
    }

    protected void tickRoll(TempMotionVars tempMotionVars) {
        if (this.getHealth() <= 0) {
            this.rotationRoll += this.m_142049_() % 2 == 0 ? 10.0f : -10.0f;
            return;
        }
        double turn = 0.0;
        if (this.getOnGround() || this.isOnWater()) {
            turn = tempMotionVars.moveStrafing > 0.0f ? 3.0 : (tempMotionVars.moveStrafing == 0.0f ? 0.0 : -3.0);
            this.rotationRoll = MathUtil.lerpAngle(0.1f, this.rotationRoll, 0.0f);
        } else {
            if (tempMotionVars.moveStrafing > 0.0f) {
                this.rollSpeed += 0.5f;
            } else if (tempMotionVars.moveStrafing < 0.0f) {
                this.rollSpeed -= 0.5f;
            } else if (this.rollSpeed < 0.0f) {
                this.rollSpeed += 0.5f;
            } else if (this.rollSpeed > 0.0f) {
                this.rollSpeed -= 0.5f;
            }
            this.rollSpeed = Mth.m_14036_((float)this.rollSpeed, (float)-5.0f, (float)5.0f);
            this.rotationRoll += this.rollSpeed;
        }
        this.m_146922_((float)((double)this.m_146908_() - turn));
    }

    protected void tickMotion(TempMotionVars tempMotionVars) {
        Vec3 pushVec;
        if (!this.isPowered()) {
            tempMotionVars.push = 0.0f;
        }
        Vec3 motion = this.m_20184_();
        double speed = motion.m_82553_();
        double brakesMul = this.getThrottle() == 0 ? 5.0 : 1.0;
        speed -= (speed * speed * tempMotionVars.dragQuad + speed * tempMotionVars.dragMul + tempMotionVars.drag) * brakesMul;
        if ((speed = Math.max(speed, 0.0)) > tempMotionVars.maxSpeed) {
            speed = Mth.m_14139_((double)0.2, (double)speed, (double)tempMotionVars.maxSpeed);
        }
        if (speed == 0.0) {
            motion = Vec3.f_82478_;
        }
        if (motion.m_82553_() > 0.0) {
            motion = motion.m_82490_(speed / motion.m_82553_());
        }
        if ((pushVec = new Vec3(this.getTickPush(tempMotionVars))).m_82553_() != 0.0 && motion.m_82553_() > 0.1) {
            double dot = MathUtil.normalizedDotProduct(pushVec, motion);
            pushVec = pushVec.m_82490_(Mth.m_14008_((double)(1.0 - dot * speed / (tempMotionVars.maxPushSpeed * ((double)tempMotionVars.push + 0.05))), (double)0.0, (double)2.0));
        }
        motion = motion.m_82549_(pushVec);
        motion = motion.m_82520_(0.0, tempMotionVars.gravity, 0.0);
        this.m_20256_(motion);
    }

    protected Vector3f getTickPush(TempMotionVars tempMotionVars) {
        return this.transformPos(new Vector3f(0.0f, 0.0f, tempMotionVars.push));
    }

    protected boolean tickOnGround(TempMotionVars tempMotionVars) {
        this.notMovingTime = this.m_20184_().m_82556_() < 0.01 && this.getOnGround() ? ++this.notMovingTime : 0;
        if (this.notMovingTime > 200 && this.getHealth() < this.getMaxHealth() && this.getPlayer() != null) {
            this.setHealth(this.getHealth() + 1);
            this.notMovingTime = 100;
        }
        boolean speedingUp = true;
        this.onGroundTicks = this.onGroundTicks < 0 ? 5 : --this.onGroundTicks;
        float pitch = this.getGroundPitch();
        if (this.isPowered() && this.getPitchUp() > 0 || this.isOnWater()) {
            pitch = 0.0f;
        } else if (this.m_20184_().m_82553_() > tempMotionVars.takeOffSpeed) {
            pitch /= 2.0f;
        }
        this.m_146926_(MathUtil.lerpAngle(0.1f, this.m_146909_(), pitch));
        if (MathUtil.degreesDifferenceAbs(this.m_146909_(), 0.0) > 1.0 && this.m_20184_().m_82553_() < 0.1) {
            tempMotionVars.push /= 5.0f;
        }
        if (this.m_20184_().m_82553_() < tempMotionVars.takeOffSpeed) {
            speedingUp = false;
        }
        if (this.getPitchUp() < 0) {
            tempMotionVars.push = -tempMotionVars.groundPush;
        } else if (this.getPitchUp() > 0 && tempMotionVars.push < tempMotionVars.groundPush) {
            tempMotionVars.push = tempMotionVars.groundPush;
        }
        if (!this.isPowered()) {
            tempMotionVars.push = 0.0f;
        }
        BlockPos pos = new BlockPos(this.m_20185_(), this.m_20186_() - 1.0, this.m_20189_());
        float f = this.f_19853_.m_8055_(pos).getFriction((LevelReader)this.f_19853_, pos, (Entity)this);
        tempMotionVars.dragMul *= (double)(20.0f * (3.0f - f));
        return speedingUp;
    }

    protected float getGroundPitch() {
        return 5.0f;
    }

    protected Quaternion tickRotateMotion(TempMotionVars tempMotionVars, Quaternion q, Vec3 motion) {
        float d;
        float yaw = MathUtil.getYaw(motion);
        float pitch = MathUtil.getPitch(motion);
        if (MathUtil.degreesDifferenceAbs(yaw, this.m_146908_()) > 5.0 && (this.getOnGround() || this.isOnWater())) {
            this.m_20256_(motion.m_82490_(0.98));
        }
        if ((d = (float)MathUtil.degreesDifferenceAbs(pitch, this.m_146909_())) > 180.0f) {
            d -= 180.0f;
        }
        d /= 60.0f;
        d = Math.min(1.0f, d);
        d *= d;
        d = 1.0f - d;
        double speed = this.m_20184_().m_82553_();
        double lift = Math.min(speed * tempMotionVars.liftFactor, (double)tempMotionVars.maxLift) * (double)d;
        if (this.getHealth() <= 0) {
            lift = 0.0;
        }
        this.m_20256_(MathUtil.rotationToVector(MathUtil.lerpAngle180(0.1f, yaw, this.m_146908_()), (double)MathUtil.lerpAngle180(tempMotionVars.pitchToMotion * d, pitch, this.m_146909_()) + lift, speed));
        if (!this.getOnGround() && !this.isOnWater() && motion.m_82553_() > 0.1) {
            if (MathUtil.degreesDifferenceAbs(pitch, this.m_146909_()) > 90.0) {
                pitch = Mth.m_14177_((float)(pitch + 180.0f));
            }
            if (Math.abs(this.m_146909_()) < 85.0f) {
                yaw = MathUtil.getYaw(this.m_20184_());
                if (MathUtil.degreesDifferenceAbs(yaw, this.m_146908_()) > 90.0) {
                    yaw -= 180.0f;
                }
                Quaternion q1 = MathUtil.toQuaternion(yaw, pitch, this.rotationRoll);
                q = MathUtil.lerpQ(tempMotionVars.motionToRotation, q, q1);
            }
        }
        return q;
    }

    public Vector3f transformPos(Vector3f relPos) {
        MathUtil.EulerAngles angles = MathUtil.toEulerAngles(this.getQ_Client());
        angles.yaw = -angles.yaw;
        angles.roll = -angles.roll;
        relPos.m_122251_(MathUtil.toQuaternion(angles.yaw, angles.pitch, angles.roll));
        return relPos;
    }

    @Nullable
    public Entity m_6688_() {
        List list = this.m_20197_();
        return list.isEmpty() ? null : (Entity)list.get(0);
    }

    public void m_7378_(CompoundTag compound) {
        if (compound.m_128441_("max_speed")) {
            this.f_19804_.m_135381_(MAX_SPEED, (Object)Float.valueOf(compound.m_128457_("max_speed")));
        }
        if (compound.m_128441_("max_health")) {
            int maxHealth = compound.m_128451_("max_health");
            if (maxHealth <= 0) {
                maxHealth = 20;
            }
            this.f_19804_.m_135381_(MAX_HEALTH, (Object)maxHealth);
        }
        if (compound.m_128441_("health")) {
            int health = compound.m_128451_("health");
            this.f_19804_.m_135381_(HEALTH, (Object)health);
        }
        if (compound.m_128441_("material")) {
            this.setMaterial(compound.m_128461_("material"));
        }
        if (compound.m_128441_("upgrades")) {
            CompoundTag upgradesNBT = compound.m_128469_("upgrades");
            this.deserializeUpgrades(upgradesNBT);
        }
        this.setQ(new Quaternion(this.m_146909_(), this.m_146908_(), 0.0f, true));
    }

    private void deserializeUpgrades(CompoundTag upgradesNBT) {
        for (String key : upgradesNBT.m_128431_()) {
            ResourceLocation resourceLocation = new ResourceLocation(key);
            UpgradeType upgradeType = (UpgradeType)SimplePlanesRegistries.UPGRADE_TYPES.get().getValue(resourceLocation);
            if (upgradeType == null) continue;
            Upgrade upgrade = upgradeType.instanceSupplier.apply(this);
            upgrade.deserializeNBT(upgradesNBT.m_128469_(key));
            this.upgrades.put(resourceLocation, upgrade);
            if (!upgradeType.isEngine) continue;
            this.engineUpgrade = (EngineUpgrade)upgrade;
        }
    }

    public void m_7380_(CompoundTag compound) {
        compound.m_128405_("health", ((Integer)this.f_19804_.m_135370_(HEALTH)).intValue());
        compound.m_128405_("max_health", ((Integer)this.f_19804_.m_135370_(MAX_HEALTH)).intValue());
        compound.m_128350_("max_speed", ((Float)this.f_19804_.m_135370_(MAX_SPEED)).floatValue());
        compound.m_128359_("material", (String)this.f_19804_.m_135370_(MATERIAL));
        compound.m_128365_("upgrades", (Tag)this.getUpgradesNBT());
    }

    private CompoundTag getUpgradesNBT() {
        CompoundTag upgradesNBT = new CompoundTag();
        for (Upgrade upgrade : this.upgrades.values()) {
            upgradesNBT.m_128365_(SimplePlanesRegistries.UPGRADE_TYPES.get().getKey((IForgeRegistryEntry)upgrade.getType()).toString(), (Tag)upgrade.serializeNBT());
        }
        return upgradesNBT;
    }

    protected boolean m_7341_(Entity entityIn) {
        return true;
    }

    public boolean canBeRiddenInWater(Entity rider) {
        return this.upgrades.containsKey(SimplePlanesUpgrades.FLOATY_BEDDING.getId());
    }

    public boolean m_5829_() {
        return true;
    }

    public Packet<?> m_5654_() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }

    public void m_7350_(EntityDataAccessor<?> key) {
        super.m_7350_(key);
        if (MATERIAL.equals(key) && this.f_19853_.m_5776_()) {
            Block block = (Block)ForgeRegistries.BLOCKS.getValue(new ResourceLocation((String)this.f_19804_.m_135370_(MATERIAL)));
            this.planksMaterial = block == null ? Blocks.f_50705_ : block;
        } else if (Q.equals(key) && this.f_19853_.m_5776_() && !this.m_6109_()) {
            if (this.f_19803_) {
                this.lerpStepsQ = 0;
                this.setQ_Client(this.getQ());
                this.setQ_prev(this.getQ());
            } else {
                this.lerpStepsQ = 10;
            }
        }
    }

    public double m_6048_() {
        return 0.5;
    }

    public boolean m_6673_(DamageSource source) {
        if (source.m_19372_()) {
            return false;
        }
        if (source.m_19384_() && this.planksMaterial.m_204297_().m_203656_(FIREPROOF_MATERIALS_TAG)) {
            return true;
        }
        if (source.m_7640_() != null && source.m_7640_().m_20365_((Entity)this)) {
            return true;
        }
        return super.m_6673_(source);
    }

    public boolean m_5825_() {
        return this.planksMaterial.m_204297_().m_203656_(FIREPROOF_MATERIALS_TAG);
    }

    protected void m_7840_(double y, boolean onGroundIn, BlockState state, BlockPos pos) {
        if (onGroundIn || this.isOnWater()) {
            double y1 = this.transformPos(new Vector3f(0.0f, 1.0f, 0.0f)).m_122260_();
            if (y1 < Math.cos(Math.toRadians(this.getLandingAngle()))) {
                state.m_60734_().m_142072_(this.f_19853_, state, pos, (Entity)this, (float)(this.m_20184_().m_82553_() * 5.0));
            }
            this.f_19789_ = 0.0f;
        }
    }

    protected int getLandingAngle() {
        return 30;
    }

    public boolean m_142535_(float fallDistance, float damageMultiplier, DamageSource p_146830_) {
        if (MathUtil.degreesDifferenceAbs(this.rotationRoll, 0.0) > 45.0) {
            this.crash(fallDistance * damageMultiplier);
        }
        return false;
    }

    public void crash(float damage) {
        if (!this.f_19853_.f_46443_ && this.m_6084_()) {
            for (Entity entity : this.m_20197_()) {
                float damageMod = Math.min(1.0f, 1.0f - (float)this.getHealth() / (float)this.getMaxHealth());
                entity.m_6469_(SimplePlanesMod.DAMAGE_SOURCE_PLANE_CRASH, damage * damageMod);
            }
            this.m_6469_(SimplePlanesMod.DAMAGE_SOURCE_PLANE_CRASH, damage + 2.0f);
        }
    }

    public boolean isCreative() {
        return this.m_6688_() instanceof Player && ((Player)this.m_6688_()).m_7500_();
    }

    public boolean getOnGround() {
        return this.f_19861_ || this.onGroundTicks > 1;
    }

    public boolean isOnWater() {
        return this.f_19853_.m_8055_(new BlockPos(this.m_20182_().m_82520_(0.0, 0.4, 0.0))).m_60734_() == Blocks.f_49990_;
    }

    public boolean canAddUpgrade(UpgradeType upgradeType) {
        if (upgradeType.isEngine && this.engineUpgrade != null) {
            return false;
        }
        return !this.upgrades.containsKey(SimplePlanesRegistries.UPGRADE_TYPES.get().getKey((IForgeRegistryEntry)upgradeType));
    }

    public void m_7332_(Entity passenger) {
        this.positionRiderGeneric(passenger);
        int index = this.m_20197_().indexOf(passenger);
        if (index == 0) {
            Vector3f pos = this.transformPos(new Vector3f(0.0f, (float)(this.m_6048_() + passenger.m_6049_()), 0.0f));
            passenger.m_6034_(this.m_20185_() + (double)pos.m_122239_(), this.m_20186_() + (double)pos.m_122260_(), this.m_20189_() + (double)pos.m_122269_());
        } else if (index == 1) {
            Vector3f pos = this.transformPos(new Vector3f(-1.0f, (float)(this.m_6048_() + passenger.m_6049_()), -1.3f));
            passenger.m_6034_(this.m_20185_() + (double)pos.m_122239_(), this.m_20186_() + (double)pos.m_122260_(), this.m_20189_() + (double)pos.m_122269_());
        } else if (index == 2) {
            Vector3f pos = this.transformPos(new Vector3f(1.0f, (float)(this.m_6048_() + passenger.m_6049_()), -1.3f));
            passenger.m_6034_(this.m_20185_() + (double)pos.m_122239_(), this.m_20186_() + (double)pos.m_122260_(), this.m_20189_() + (double)pos.m_122269_());
        }
    }

    protected void positionRiderGeneric(Entity passenger) {
        boolean local;
        super.m_7332_(passenger);
        boolean bl = local = passenger instanceof Player && ((Player)passenger).m_7578_();
        if (this.m_20363_(passenger) && !local) {
            this.applyYawToEntity(passenger);
        }
    }

    public void applyYawToEntity(Entity entityToUpdate) {
        entityToUpdate.m_5616_(entityToUpdate.m_6080_() + this.deltaRotation);
        entityToUpdate.f_19859_ += this.deltaRotation;
        entityToUpdate.m_5618_(this.m_146908_());
        entityToUpdate.m_5616_(entityToUpdate.m_146908_());
    }

    public Vec3 m_7688_(LivingEntity livingEntity) {
        Player player;
        if (this.upgrades.containsKey(SimplePlanesUpgrades.FOLDING.getId()) && livingEntity instanceof Player && !(player = (Player)livingEntity).m_7500_() && this.m_20197_().size() == 0 && this.m_6084_()) {
            ItemStack itemStack = this.getItemStack();
            if (!player.m_36356_(itemStack)) {
                player.m_36176_(itemStack, false);
            }
            this.m_6074_();
            return player.m_20182_();
        }
        if (this.m_20197_().size() == 0) {
            this.setThrottle(0);
            this.setPitchUp((byte)0);
            this.setYawRight((byte)0);
        }
        return super.m_7688_(livingEntity);
    }

    public ItemStack getItemStack() {
        ItemStack itemStack = this.getItem().m_7968_();
        CompoundTag compound = new CompoundTag();
        this.m_7380_(compound);
        compound.m_128405_("health", ((Integer)this.f_19804_.m_135370_(MAX_HEALTH)).intValue());
        compound.m_128379_("Used", true);
        itemStack.m_41700_("EntityTag", (Tag)compound);
        return itemStack;
    }

    protected Item getItem() {
        return (Item)SimplePlanesItems.PLANE_ITEM.get();
    }

    private void tickLerp() {
        if (this.m_6109_()) {
            this.lerpSteps = 0;
            this.lerpStepsQ = 0;
            this.m_20167_(this.m_20185_(), this.m_20186_(), this.m_20189_());
            return;
        }
        if (this.lerpSteps > 0) {
            double d0 = this.m_20185_() + (this.lerpX - this.m_20185_()) / (double)this.lerpSteps;
            double d1 = this.m_20186_() + (this.lerpY - this.m_20186_()) / (double)this.lerpSteps;
            double d2 = this.m_20189_() + (this.lerpZ - this.m_20189_()) / (double)this.lerpSteps;
            --this.lerpSteps;
            this.m_6034_(d0, d1, d2);
        }
        if (this.lerpStepsQ > 0) {
            this.setQ_prev(this.getQ_Client());
            this.setQ_Client(MathUtil.lerpQ(1.0f / (float)this.lerpStepsQ, this.getQ_Client(), this.getQ()));
            --this.lerpStepsQ;
        } else if (this.lerpStepsQ == 0) {
            this.setQ_prev(this.getQ_Client());
            this.setQ_Client(this.getQ());
            --this.lerpStepsQ;
        }
    }

    public void m_6453_(double x, double y, double z, float yaw, float pitch, int posRotationIncrements, boolean teleport) {
        if (x == this.m_20185_() && y == this.m_20186_() && z == this.m_20189_()) {
            return;
        }
        this.lerpX = x;
        this.lerpY = y;
        this.lerpZ = z;
        this.lerpSteps = 10;
    }

    public void m_19890_(double x, double y, double z, float yaw, float pitch) {
        double d0 = Mth.m_14008_((double)x, (double)-3.0E7, (double)3.0E7);
        double d1 = Mth.m_14008_((double)z, (double)-3.0E7, (double)3.0E7);
        this.f_19790_ = d0;
        this.f_19791_ = y;
        this.f_19792_ = d1;
        this.m_6034_(d0, y, d1);
        this.m_146922_(yaw % 360.0f);
        this.m_146926_(pitch % 360.0f);
        this.f_19859_ = this.m_146908_();
        this.f_19860_ = this.m_146909_();
    }

    protected void m_20348_(Entity passenger) {
        super.m_20348_(passenger);
        if (this.m_6109_() && this.lerpSteps > 0) {
            this.lerpSteps = 0;
            this.m_19890_(this.lerpX, this.lerpY, this.lerpZ, this.m_146908_(), this.m_146909_());
        }
    }

    public Player getPlayer() {
        if (this.m_6688_() instanceof Player) {
            return (Player)this.m_6688_();
        }
        return null;
    }

    public void setTimeSinceHit(int timeSinceHit) {
        this.f_19804_.m_135381_(TIME_SINCE_HIT, (Object)timeSinceHit);
    }

    public int getTimeSinceHit() {
        return (Integer)this.f_19804_.m_135370_(TIME_SINCE_HIT);
    }

    public void setDamageTaken(float damageTaken) {
        this.f_19804_.m_135381_(DAMAGE_TAKEN, (Object)Float.valueOf(damageTaken));
    }

    public float getDamageTaken() {
        return ((Float)this.f_19804_.m_135370_(DAMAGE_TAKEN)).floatValue();
    }

    public double getCameraDistanceMultiplayer() {
        return (Double)SimplePlanesConfig.PLANE_CAMERA_DISTANCE_MULTIPLIER.get();
    }

    public void writeUpdateUpgradePacket(ResourceLocation upgradeID, FriendlyByteBuf buffer) {
        buffer.m_130130_(this.m_142049_());
        buffer.m_130085_(upgradeID);
        this.upgrades.get(upgradeID).writePacket(buffer);
    }

    public void readUpdateUpgradePacket(ResourceLocation upgradeID, FriendlyByteBuf buffer, boolean newUpgrade) {
        if (newUpgrade) {
            UpgradeType upgradeType = (UpgradeType)SimplePlanesRegistries.UPGRADE_TYPES.get().getValue(upgradeID);
            Upgrade upgrade = upgradeType.instanceSupplier.apply(this);
            this.upgrades.put(upgradeID, upgrade);
            if (upgradeType.isEngine) {
                this.engineUpgrade = (EngineUpgrade)upgrade;
            }
        }
        this.upgrades.get(upgradeID).readPacket(buffer);
    }

    @Nonnull
    public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> cap, @Nullable Direction side) {
        if (this.upgrades != null) {
            for (Upgrade upgrade : this.upgrades.values()) {
                LazyOptional lazyOptional = upgrade.getCapability(cap, side);
                if (!lazyOptional.isPresent()) continue;
                return lazyOptional;
            }
        }
        return super.getCapability(cap, side);
    }

    public void writeSpawnData(FriendlyByteBuf buffer) {
        Collection<Upgrade> upgrades = this.upgrades.values();
        buffer.m_130130_(upgrades.size());
        for (Upgrade upgrade : upgrades) {
            ResourceLocation upgradeID = SimplePlanesRegistries.UPGRADE_TYPES.get().getKey((IForgeRegistryEntry)upgrade.getType());
            buffer.m_130085_(upgradeID);
            upgrade.writePacket(buffer);
        }
    }

    public void readSpawnData(FriendlyByteBuf additionalData) {
        int upgradesSize = additionalData.m_130242_();
        for (int i = 0; i < upgradesSize; ++i) {
            ResourceLocation upgradeID = additionalData.m_130281_();
            UpgradeType upgradeType = (UpgradeType)SimplePlanesRegistries.UPGRADE_TYPES.get().getValue(upgradeID);
            Upgrade upgrade = upgradeType.instanceSupplier.apply(this);
            this.upgrades.put(upgradeID, upgrade);
            if (upgradeType.isEngine) {
                this.engineUpgrade = (EngineUpgrade)upgrade;
            }
            upgrade.readPacket(additionalData);
        }
    }

    public void removeUpgrade(ResourceLocation upgradeID) {
        Upgrade upgrade = this.upgrades.remove(upgradeID);
        if (upgrade != null) {
            upgrade.onRemoved();
            upgrade.remove();
            if (!this.f_19853_.f_46443_) {
                SimplePlanesNetworking.INSTANCE.send(PacketDistributor.TRACKING_ENTITY.with(() -> this), (Object)new SUpgradeRemovedPacket(upgradeID, this.m_142049_()));
            }
        }
    }

    public void changeThrottle(ChangeThrottlePacket.Type type) {
        int throttle = this.getThrottle();
        if (type == ChangeThrottlePacket.Type.UP) {
            if (throttle < 5 || this.upgrades.containsKey(SimplePlanesUpgrades.BOOSTER.getId()) && throttle < 10) {
                this.setThrottle(throttle + 1);
            }
        } else if (throttle > 0) {
            this.setThrottle(throttle - 1);
        }
    }

    public int getThrottle() {
        return (Integer)this.f_19804_.m_135370_(THROTTLE);
    }

    public void setThrottle(int value) {
        this.f_19804_.m_135381_(THROTTLE, (Object)value);
    }

    public byte getPitchUp() {
        return (Byte)this.f_19804_.m_135370_(PITCH_UP);
    }

    public void setPitchUp(byte pitchUp) {
        this.f_19804_.m_135381_(PITCH_UP, (Object)pitchUp);
    }

    public byte getYawRight() {
        return (Byte)this.f_19804_.m_135370_(YAW_RIGHT);
    }

    public void setYawRight(byte yawRight) {
        this.f_19804_.m_135381_(YAW_RIGHT, (Object)yawRight);
    }

    protected static class TempMotionVars {
        public float moveForward;
        public double turnThreshold;
        public float moveStrafing;
        double maxSpeed;
        double maxPushSpeed;
        double takeOffSpeed;
        float maxLift;
        double liftFactor;
        double gravity;
        double drag;
        double dragMul;
        double dragQuad;
        float push;
        float groundPush;
        float passiveEnginePush;
        float motionToRotation;
        float pitchToMotion;
        float yawMultiplayer;

        public TempMotionVars() {
            this.reset();
        }

        public void reset() {
            this.moveForward = 0.0f;
            this.turnThreshold = 0.0;
            this.moveStrafing = 0.0f;
            this.maxSpeed = 3.0;
            this.takeOffSpeed = 0.3;
            this.maxLift = 2.0f;
            this.liftFactor = 10.0;
            this.gravity = -0.03;
            this.drag = 0.001;
            this.dragMul = 5.0E-4;
            this.dragQuad = 0.001;
            this.push = 0.0f;
            this.groundPush = 0.01f;
            this.passiveEnginePush = 0.025f;
            this.motionToRotation = 0.05f;
            this.pitchToMotion = 0.2f;
            this.yawMultiplayer = 0.5f;
        }
    }
}

