/*
 * Decompiled with CFR 0.152.
 */
package xyz.przemyk.simpleplanes.network;

import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraftforge.network.NetworkEvent;
import xyz.przemyk.simpleplanes.entities.PlaneEntity;

public class UpdateUpgradePacket {
    private final boolean newUpgrade;
    private final ResourceLocation upgradeID;
    private final int planeEntityID;
    private ServerLevel serverWorld;
    private FriendlyByteBuf packetBuffer;

    public UpdateUpgradePacket(ResourceLocation upgradeID, int planeEntityID, ServerLevel serverWorld) {
        this(upgradeID, planeEntityID, serverWorld, false);
    }

    public UpdateUpgradePacket(ResourceLocation upgradeID, int planeEntityID, ServerLevel serverWorld, boolean newUpgrade) {
        this.upgradeID = upgradeID;
        this.planeEntityID = planeEntityID;
        this.serverWorld = serverWorld;
        this.newUpgrade = newUpgrade;
    }

    public UpdateUpgradePacket(FriendlyByteBuf buffer) {
        this.newUpgrade = buffer.readBoolean();
        this.planeEntityID = buffer.m_130242_();
        this.upgradeID = buffer.m_130281_();
        this.packetBuffer = buffer;
    }

    public void toBytes(FriendlyByteBuf buffer) {
        buffer.writeBoolean(this.newUpgrade);
        PlaneEntity planeEntity = (PlaneEntity)this.serverWorld.m_6815_(this.planeEntityID);
        if (planeEntity != null) {
            planeEntity.writeUpdateUpgradePacket(this.upgradeID, buffer);
        }
    }

    public void handle(Supplier<NetworkEvent.Context> ctxSup) {
        NetworkEvent.Context ctx = ctxSup.get();
        ctx.enqueueWork(() -> {
            ClientLevel clientWorld = Minecraft.m_91087_().f_91073_;
            ((PlaneEntity)clientWorld.m_6815_(this.planeEntityID)).readUpdateUpgradePacket(this.upgradeID, this.packetBuffer, this.newUpgrade);
        });
        ctx.setPacketHandled(true);
    }
}

