/*
 * Decompiled with CFR 0.152.
 */
package xyz.przemyk.simpleplanes.client;

import com.mojang.blaze3d.systems.RenderSystem;
import net.fabricmc.api.ClientModInitializer;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.client.event.lifecycle.v1.ClientTickEvents;
import net.fabricmc.fabric.api.client.keybinding.v1.KeyBindingHelper;
import net.fabricmc.fabric.api.client.rendering.v1.ColorProviderRegistry;
import net.fabricmc.fabric.api.client.rendering.v1.HudRenderCallback;
import net.minecraft.class_1158;
import net.minecraft.class_1160;
import net.minecraft.class_1297;
import net.minecraft.class_1306;
import net.minecraft.class_1309;
import net.minecraft.class_1799;
import net.minecraft.class_1935;
import net.minecraft.class_243;
import net.minecraft.class_2960;
import net.minecraft.class_304;
import net.minecraft.class_310;
import net.minecraft.class_3532;
import net.minecraft.class_3675;
import net.minecraft.class_3929;
import net.minecraft.class_4184;
import net.minecraft.class_4587;
import net.minecraft.class_5498;
import net.minecraft.class_746;
import net.minecraft.class_757;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import xyz.przemyk.simpleplanes.client.ClientUtil;
import xyz.przemyk.simpleplanes.client.PlanesModelLayers;
import xyz.przemyk.simpleplanes.client.gui.PlaneInventoryScreen;
import xyz.przemyk.simpleplanes.client.gui.PlaneWorkbenchScreen;
import xyz.przemyk.simpleplanes.client.gui.RemoveUpgradesScreen;
import xyz.przemyk.simpleplanes.client.gui.StorageScreen;
import xyz.przemyk.simpleplanes.client.render.PlaneItemColors;
import xyz.przemyk.simpleplanes.entities.LargePlaneEntity;
import xyz.przemyk.simpleplanes.entities.PlaneEntity;
import xyz.przemyk.simpleplanes.misc.MathUtil;
import xyz.przemyk.simpleplanes.network.ChangeThrottlePacket;
import xyz.przemyk.simpleplanes.network.DropPayloadPacket;
import xyz.przemyk.simpleplanes.network.MoveHeliUpPacket;
import xyz.przemyk.simpleplanes.network.OpenInventoryPacket;
import xyz.przemyk.simpleplanes.network.OpenPlaneInventoryPacket;
import xyz.przemyk.simpleplanes.network.PitchPacket;
import xyz.przemyk.simpleplanes.network.SimplePlanesNetworking;
import xyz.przemyk.simpleplanes.network.YawPacket;
import xyz.przemyk.simpleplanes.setup.SimplePlanesContainers;
import xyz.przemyk.simpleplanes.setup.SimplePlanesItems;
import xyz.przemyk.simpleplanes.upgrades.Upgrade;

@Environment(value=EnvType.CLIENT)
public class ClientEventHandler
implements ClientModInitializer {
    public static final class_2960 HUD_TEXTURE = new class_2960("simpleplanes", "textures/gui/plane_hud.png");
    public static class_304 moveHeliUpKey;
    public static class_304 openPlaneInventoryKey;
    public static class_304 dropPayloadKey;
    public static class_304 throttleUp;
    public static class_304 throttleDown;
    public static class_304 pitchUp;
    public static class_304 pitchDown;
    public static class_304 yawRight;
    public static class_304 yawLeft;
    private static boolean oldMoveHeliUpState;
    private static boolean oldPitchUpState;
    private static boolean oldPitchDownState;
    private static boolean oldYawRightState;
    private static boolean oldYawLeftState;

    public void onInitializeClient() {
        SimplePlanesNetworking.registerS2CPackets();
        class_3929.method_17542(SimplePlanesContainers.PLANE_WORKBENCH, PlaneWorkbenchScreen::new);
        class_3929.method_17542(SimplePlanesContainers.UPGRADES_REMOVAL, RemoveUpgradesScreen::new);
        class_3929.method_17542(SimplePlanesContainers.STORAGE, StorageScreen::new);
        class_3929.method_17542(SimplePlanesContainers.PLANE_INVENTORY, PlaneInventoryScreen::new);
        PlanesModelLayers.registerRenderers();
        PlanesModelLayers.registerLayers();
        ClientEventHandler.registerKeyBindings();
        ClientTickEvents.END_CLIENT_TICK.register(ClientEventHandler::onClientPlayerTick);
        HudRenderCallback.EVENT.register(ClientEventHandler::renderHUDOverlay);
        SimplePlanesItems.getPlaneItems().forEach(item -> ColorProviderRegistry.ITEM.register(PlaneItemColors::getColor, (Object[])new class_1935[]{item}));
    }

    public static void registerKeyBindings() {
        moveHeliUpKey = new class_304("key.move_heli_up.desc", 32, "key.simpleplanes.category");
        openPlaneInventoryKey = new class_304("key.plane_inventory_open.desc", 88, "key.simpleplanes.category");
        dropPayloadKey = new class_304("key.plane_drop_payload.desc", 67, "key.simpleplanes.category");
        throttleUp = new class_304("key.plane_throttle_up.desc", 265, "key.simpleplanes.category");
        throttleDown = new class_304("key.plane_throttle_down.desc", 264, "key.simpleplanes.category");
        pitchUp = new class_304("key.plane_pitch_up.desc", 87, "key.simpleplanes.category");
        pitchDown = new class_304("key.plane_pitch_down.desc", 83, "key.simpleplanes.category");
        yawRight = new class_304("key.plane_yaw_right.desc", 262, "key.simpleplanes.category");
        yawLeft = new class_304("key.plane_yaw_left.desc", 263, "key.simpleplanes.category");
        KeyBindingHelper.registerKeyBinding((class_304)moveHeliUpKey);
        KeyBindingHelper.registerKeyBinding((class_304)openPlaneInventoryKey);
        KeyBindingHelper.registerKeyBinding((class_304)dropPayloadKey);
        KeyBindingHelper.registerKeyBinding((class_304)throttleUp);
        KeyBindingHelper.registerKeyBinding((class_304)throttleDown);
        KeyBindingHelper.registerKeyBinding((class_304)pitchUp);
        KeyBindingHelper.registerKeyBinding((class_304)pitchDown);
        KeyBindingHelper.registerKeyBinding((class_304)yawRight);
        KeyBindingHelper.registerKeyBinding((class_304)yawLeft);
    }

    public static void renderHUDOverlay(class_4587 matrixStack, float partialTicks) {
        class_310 mc = class_310.method_1551();
        int scaledWidth = mc.method_22683().method_4486();
        int scaledHeight = mc.method_22683().method_4502();
        class_1297 class_12972 = mc.field_1724.method_5854();
        if (class_12972 instanceof PlaneEntity) {
            PlaneEntity planeEntity = (PlaneEntity)class_12972;
            RenderSystem.setShader(class_757::method_34542);
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            RenderSystem.setShaderTexture((int)0, (class_2960)HUD_TEXTURE);
            int left_align = scaledWidth / 2 + 91;
            int health = (int)Math.ceil(planeEntity.getHealth());
            float healthMax = planeEntity.getMaxHealth();
            int hearts = (int)healthMax;
            if (hearts > 10) {
                hearts = 10;
            }
            boolean FULL = false;
            int EMPTY = 16;
            int GOLD = 32;
            int max_row_size = 5;
            int heart = 0;
            while (hearts > 0) {
                int top = scaledHeight - 49;
                int rowCount = Math.min(hearts, max_row_size);
                hearts -= rowCount;
                for (int i = 0; i < rowCount; ++i) {
                    int x = left_align - i * 16 - 16;
                    int vOffset = 35;
                    if (i + heart + 10 < health) {
                        ClientUtil.blit(matrixStack, 0, x, top, 32, vOffset, 16, 9);
                        continue;
                    }
                    if (i + heart < health) {
                        ClientUtil.blit(matrixStack, 0, x, top, 0, vOffset, 16, 9);
                        continue;
                    }
                    ClientUtil.blit(matrixStack, 0, x, top, 16, vOffset, 16, 9);
                }
                heart += max_row_size;
            }
            ClientUtil.blit(matrixStack, -90, scaledWidth - 24, scaledHeight - 42, 0, 84, 22, 40);
            int throttle = planeEntity.getThrottle();
            if (throttle > 0) {
                int throttleScaled = throttle * 28 / 10;
                ClientUtil.blit(matrixStack, -90, scaledWidth - 24 + 10, scaledHeight - 42 + 6 + 28 - throttleScaled, 22, 118 - throttleScaled, 2, throttleScaled);
            }
            if (planeEntity.engineUpgrade != null) {
                class_1799 offhandStack = mc.field_1724.method_6079();
                class_1306 primaryHand = mc.field_1724.method_6068();
                planeEntity.engineUpgrade.renderPowerHUD(matrixStack, primaryHand == class_1306.field_6182 || offhandStack.method_7960() ? class_1306.field_6182 : class_1306.field_6183, scaledWidth, scaledHeight, partialTicks);
            }
        }
    }

    public static void onRenderPre(class_1309 livingEntity, float partialTicks, class_4587 matrixStack) {
        class_1297 entity = livingEntity.method_5668();
        if (entity instanceof PlaneEntity) {
            PlaneEntity planeEntity = (PlaneEntity)entity;
            matrixStack.method_22903();
            matrixStack.method_22904(0.0, 0.375, 0.0);
            class_1158 quaternion = MathUtil.lerpQ(partialTicks, planeEntity.getQ_Prev(), planeEntity.getQ_Client());
            quaternion.method_23758(quaternion.method_4921(), -quaternion.method_4922(), -quaternion.method_4923(), quaternion.method_4924());
            matrixStack.method_22907(quaternion);
            float rotationYaw = MathUtil.lerpAngle(partialTicks, entity.field_5982, entity.method_36454());
            matrixStack.method_22907(class_1160.field_20705.method_23214(rotationYaw));
            matrixStack.method_22904(0.0, -0.375, 0.0);
            if (MathUtil.degreesDifferenceAbs(planeEntity.rotationRoll, 0.0) > 90.0) {
                livingEntity.field_6241 = planeEntity.method_36454() * 2.0f - livingEntity.field_6241;
            }
            if (MathUtil.degreesDifferenceAbs(planeEntity.prevRotationRoll, 0.0) > 90.0) {
                livingEntity.field_6259 = planeEntity.field_5982 * 2.0f - livingEntity.field_6259;
            }
        }
    }

    public static void onRenderPost(class_1309 livingEntity, class_4587 matrixStack) {
        class_1297 entity = livingEntity.method_5668();
        if (entity instanceof PlaneEntity) {
            PlaneEntity planeEntity = (PlaneEntity)entity;
            matrixStack.method_22909();
            if (MathUtil.degreesDifferenceAbs(planeEntity.rotationRoll, 0.0) > 90.0) {
                livingEntity.field_6241 = planeEntity.method_36454() * 2.0f - livingEntity.field_6241;
            }
            if (MathUtil.degreesDifferenceAbs(planeEntity.prevRotationRoll, 0.0) > 90.0) {
                livingEntity.field_6259 = planeEntity.field_5982 * 2.0f - livingEntity.field_6259;
            }
        }
    }

    public static void onClientPlayerTick(class_310 minecraft) {
        class_1297 class_12972;
        class_746 player = minecraft.field_1724;
        if (player != null && (class_12972 = player.method_5854()) instanceof PlaneEntity) {
            PlaneEntity planeEntity = (PlaneEntity)class_12972;
            class_310 mc = class_310.method_1551();
            if (mc.field_1690.method_31044() != class_5498.field_26664) {
                planeEntity.applyYawToEntity((class_1297)player);
            }
            if (mc.field_1755 == null && mc.method_18506() == null && openPlaneInventoryKey.method_1436()) {
                OpenPlaneInventoryPacket.send();
            } else if (dropPayloadKey.method_1436()) {
                for (Upgrade upgrade : planeEntity.upgrades.values()) {
                    if (!upgrade.canBeDroppedAsPayload()) continue;
                    upgrade.dropAsPayload();
                    DropPayloadPacket.send();
                    break;
                }
            }
            if (throttleUp.method_1436()) {
                ChangeThrottlePacket.send(ChangeThrottlePacket.Type.UP);
            } else if (throttleDown.method_1436()) {
                ChangeThrottlePacket.send(ChangeThrottlePacket.Type.DOWN);
            }
            boolean isMoveHeliUp = class_3675.method_15987((long)class_310.method_1551().method_22683().method_4490(), (int)ClientEventHandler.moveHeliUpKey.field_1655.method_1444());
            boolean isPitchUp = class_3675.method_15987((long)class_310.method_1551().method_22683().method_4490(), (int)ClientEventHandler.pitchUp.field_1655.method_1444());
            boolean isPitchDown = class_3675.method_15987((long)class_310.method_1551().method_22683().method_4490(), (int)ClientEventHandler.pitchDown.field_1655.method_1444());
            boolean isYawRight = yawRight.method_1434();
            boolean isYawLeft = yawLeft.method_1434();
            if (isMoveHeliUp != oldMoveHeliUpState) {
                MoveHeliUpPacket.send(isMoveHeliUp);
            }
            if (isPitchUp != oldPitchUpState || isPitchDown != oldPitchDownState) {
                PitchPacket.send((byte)Boolean.compare(isPitchUp, isPitchDown));
            }
            if (isYawRight != oldYawRightState || isYawLeft != oldYawLeftState) {
                YawPacket.send((byte)Boolean.compare(isYawRight, isYawLeft));
            }
            oldMoveHeliUpState = isMoveHeliUp;
            oldPitchUpState = isPitchUp;
            oldPitchDownState = isPitchDown;
            oldYawRightState = isYawRight;
            oldYawLeftState = isYawLeft;
        } else {
            oldMoveHeliUpState = false;
            oldPitchUpState = false;
            oldPitchDownState = false;
            oldYawRightState = false;
            oldYawLeftState = false;
        }
    }

    public static void onCameraSetup(class_4184 camera, float partialTicks, class_4587 poseStack) {
        class_1297 player = camera.method_19331();
        class_1297 class_12972 = player.method_5854();
        if (class_12972 instanceof PlaneEntity) {
            PlaneEntity planeEntity = (PlaneEntity)class_12972;
            if (camera.method_19333()) {
                camera.method_19324(-camera.method_19318(4.0 * (planeEntity.getCameraDistanceMultiplayer() - 1.0)), 0.0, 0.0);
            } else {
                float heightDiff = 0.0f;
                if (planeEntity instanceof LargePlaneEntity) {
                    heightDiff = -0.1f;
                }
                class_1158 qPrev = planeEntity.getQ_Prev();
                class_1158 qNow = planeEntity.getQ_Client();
                class_1160 eyePrev = new class_1160(0.0f, 1.62f + heightDiff, 0.0f);
                class_1160 eyeNow = eyePrev.method_23850();
                eyePrev.method_19262(qPrev);
                eyeNow.method_19262(qNow);
                camera.method_19322(new class_243(class_3532.method_16436((double)partialTicks, (double)(player.field_6014 - (double)eyePrev.method_4943()), (double)(player.method_23317() - (double)eyeNow.method_4943())), class_3532.method_16436((double)partialTicks, (double)(player.field_6036 + (double)eyePrev.method_4945()), (double)(player.method_23318() + (double)eyeNow.method_4945())) + 0.375, class_3532.method_16436((double)partialTicks, (double)(player.field_5969 + (double)eyePrev.method_4947()), (double)(player.method_23321() + (double)eyeNow.method_4947()))));
                qPrev.method_4925(class_1160.field_20705.method_23214(player.field_5982));
                qPrev.method_4925(class_1160.field_20703.method_23214(camera.method_19329()));
                MathUtil.EulerAngles eulerAnglesPrev = MathUtil.toEulerAngles(qPrev);
                qNow.method_4925(class_1160.field_20705.method_23214(player.method_36454()));
                qNow.method_4925(class_1160.field_20703.method_23214(camera.method_19329()));
                MathUtil.EulerAngles eulerAnglesNow = MathUtil.toEulerAngles(qNow);
                camera.field_18718 = (float)MathUtil.lerpAngle((double)partialTicks, eulerAnglesPrev.yaw, eulerAnglesNow.yaw);
                camera.field_18717 = -((float)MathUtil.lerpAngle((double)partialTicks, eulerAnglesPrev.pitch, eulerAnglesNow.pitch));
                poseStack.method_22907(class_1160.field_20707.method_23214(-((float)MathUtil.lerpAngle((double)partialTicks, eulerAnglesPrev.roll, eulerAnglesNow.roll))));
            }
        }
    }

    public static void planeInventory(CallbackInfo ci) {
        LargePlaneEntity largePlaneEntity;
        class_746 player = class_310.method_1551().field_1724;
        class_1297 class_12972 = player.method_5854();
        if (class_12972 instanceof LargePlaneEntity && (largePlaneEntity = (LargePlaneEntity)class_12972).hasStorageUpgrade()) {
            ci.cancel();
            OpenInventoryPacket.send();
        }
    }

    static {
        oldMoveHeliUpState = false;
        oldPitchUpState = false;
        oldPitchDownState = false;
        oldYawRightState = false;
        oldYawLeftState = false;
    }
}

