/*
 * Decompiled with CFR 0.152.
 */
package xyz.przemyk.simpleplanes.client.render;

import java.util.HashMap;
import java.util.Map;
import net.minecraft.class_1091;
import net.minecraft.class_1158;
import net.minecraft.class_1160;
import net.minecraft.class_1299;
import net.minecraft.class_1921;
import net.minecraft.class_2248;
import net.minecraft.class_2350;
import net.minecraft.class_2378;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3532;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_4597;
import net.minecraft.class_4608;
import net.minecraft.class_5617;
import net.minecraft.class_5819;
import net.minecraft.class_583;
import net.minecraft.class_777;
import net.minecraft.class_897;
import net.minecraft.class_918;
import xyz.przemyk.simpleplanes.entities.PlaneEntity;
import xyz.przemyk.simpleplanes.misc.MathUtil;
import xyz.przemyk.simpleplanes.setup.SimplePlanesEntities;
import xyz.przemyk.simpleplanes.upgrades.Upgrade;

public class PlaneRenderer<T extends PlaneEntity>
extends class_897<T> {
    protected final class_583<PlaneEntity> propellerModel;
    protected final class_583<T> planeEntityModel;
    protected final class_583<PlaneEntity> planeMetalModel;
    protected final class_2960 metalTexture;
    protected final class_2960 propellerTexture;
    public static final Map<class_2248, class_2960> cachedTextures = new HashMap<class_2248, class_2960>();
    public static final class_2960 FALLBACK_TEXTURE = new class_2960("minecraft", "textures/block/oak_planks.png");

    public PlaneRenderer(class_5617.class_5618 context, class_583<T> planeModel, class_583<PlaneEntity> planeMetalModel, class_583<PlaneEntity> propellerModel, float shadowSize, class_2960 metalTexture, class_2960 propellerTexture) {
        super(context);
        this.propellerModel = propellerModel;
        this.planeEntityModel = planeModel;
        this.planeMetalModel = planeMetalModel;
        this.metalTexture = metalTexture;
        this.propellerTexture = propellerTexture;
        this.field_4673 = shadowSize;
    }

    public static float getPropellerRotation(PlaneEntity entity, float partialTicks) {
        return class_3532.method_16439((float)partialTicks, (float)entity.propellerRotationOld, (float)entity.propellerRotationNew);
    }

    public void render(T planeEntity, float entityYaw, float partialTicks, class_4587 poseStack, class_4597 buffer, int packedLight) {
        poseStack.method_22903();
        poseStack.method_22904(0.0, 0.375, 0.0);
        poseStack.method_22905(-1.0f, -1.0f, 1.0f);
        poseStack.method_22907(class_1160.field_20705.method_23214(180.0f));
        class_1158 q = MathUtil.lerpQ(partialTicks, ((PlaneEntity)((Object)planeEntity)).getQ_Prev(), ((PlaneEntity)((Object)planeEntity)).getQ_Client());
        poseStack.method_22907(q);
        class_1299 entityType = planeEntity.method_5864();
        if (entityType == SimplePlanesEntities.PLANE) {
            poseStack.method_22904(0.0, -0.5, -0.5);
        } else if (entityType == SimplePlanesEntities.LARGE_PLANE) {
            poseStack.method_22904(0.0, -0.3, -1.0);
        } else {
            poseStack.method_22904(0.0, 0.0, 0.9);
        }
        float timeSinceHitWithPartial = (float)((PlaneEntity)((Object)planeEntity)).getTimeSinceHit() - partialTicks;
        if (timeSinceHitWithPartial > 0.0f) {
            float angle = class_3532.method_15363((float)(timeSinceHitWithPartial / 10.0f), (float)-30.0f, (float)30.0f);
            timeSinceHitWithPartial = (float)((PlaneEntity)((Object)planeEntity)).field_6012 + partialTicks;
            poseStack.method_22907(class_1160.field_20707.method_23214(class_3532.method_15374((float)timeSinceHitWithPartial) * angle));
        }
        poseStack.method_22904(0.0, -1.1, 0.0);
        class_4588 vertexConsumer = buffer.getBuffer(this.planeEntityModel.method_23500(PlaneRenderer.getMaterialTexture(planeEntity)));
        this.planeEntityModel.method_2819(planeEntity, partialTicks, 0.0f, 0.0f, 0.0f, 0.0f);
        this.planeEntityModel.method_2828(poseStack, vertexConsumer, packedLight, class_4608.field_21444, 1.0f, 1.0f, 1.0f, 1.0f);
        vertexConsumer = class_918.method_27952((class_4597)buffer, (class_1921)this.planeEntityModel.method_23500(this.propellerTexture), (boolean)false, (boolean)planeEntity.method_5740());
        this.propellerModel.method_2819(planeEntity, partialTicks, 0.0f, 0.0f, 0.0f, 0.0f);
        this.propellerModel.method_2828(poseStack, vertexConsumer, packedLight, class_4608.field_21444, 1.0f, 1.0f, 1.0f, 1.0f);
        vertexConsumer = buffer.getBuffer(this.planeMetalModel.method_23500(this.metalTexture));
        this.planeMetalModel.method_2819(planeEntity, partialTicks, 0.0f, 0.0f, 0.0f, 0.0f);
        this.planeMetalModel.method_2828(poseStack, vertexConsumer, packedLight, class_4608.field_21444, 1.0f, 1.0f, 1.0f, 1.0f);
        for (Upgrade upgrade : ((PlaneEntity)((Object)planeEntity)).upgrades.values()) {
            upgrade.render(poseStack, buffer, packedLight, partialTicks);
        }
        poseStack.method_22909();
        super.method_3936(planeEntity, 0.0f, partialTicks, poseStack, buffer, packedLight);
    }

    public class_2960 getTextureLocation(PlaneEntity entity) {
        return PlaneRenderer.getMaterialTexture(entity);
    }

    public static class_2960 getMaterialTexture(PlaneEntity entity) {
        class_2960 texture;
        class_2248 block = entity.getMaterial();
        if (cachedTextures.containsKey(block)) {
            return cachedTextures.get(block);
        }
        try {
            class_2960 sprite = ((class_777)class_310.method_1551().method_1554().method_4742(new class_1091(class_2378.field_11146.method_10221((Object)block), "inventory")).method_4707(null, class_2350.field_11035, class_5819.method_43047()).get(0)).method_35788().method_4598();
            texture = new class_2960(sprite.method_12836(), "textures/" + sprite.method_12832() + ".png");
        }
        catch (IndexOutOfBoundsException | NullPointerException exception) {
            texture = FALLBACK_TEXTURE;
        }
        cachedTextures.put(block, texture);
        return texture;
    }
}

