/*
 * Decompiled with CFR 0.152.
 */
package xyz.przemyk.simpleplanes.container;

import java.util.List;
import net.minecraft.class_1263;
import net.minecraft.class_1277;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1703;
import net.minecraft.class_1713;
import net.minecraft.class_1735;
import net.minecraft.class_1747;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2378;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_2596;
import net.minecraft.class_2653;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import net.minecraft.class_3914;
import net.minecraft.class_3915;
import net.minecraft.class_5321;
import net.minecraft.class_6862;
import xyz.przemyk.simpleplanes.container.PlaneCraftingResultSlot;
import xyz.przemyk.simpleplanes.network.CycleItemsPacket;
import xyz.przemyk.simpleplanes.recipes.PlaneWorkbenchRecipe;
import xyz.przemyk.simpleplanes.setup.SimplePlanesBlocks;
import xyz.przemyk.simpleplanes.setup.SimplePlanesContainers;
import xyz.przemyk.simpleplanes.setup.SimplePlanesRecipes;

public class PlaneWorkbenchContainer
extends class_1703 {
    public static final class_2960 PLANE_MATERIALS = new class_2960("simpleplanes", "plane_materials");
    public static final class_6862<class_2248> PLANE_MATERIALS_TAG = class_6862.method_40092((class_5321)class_2378.field_25105, (class_2960)PLANE_MATERIALS);
    private final class_1263 itemHandler;
    private final class_1277 resultItemHandler = new class_1277(1);
    private final class_3914 usabilityTest;
    private final class_1657 player;
    private final class_3915 selectedRecipe;
    private final class_2487 resultItemTag = new class_2487();
    private final List<PlaneWorkbenchRecipe> recipeList;

    public PlaneWorkbenchContainer(int id, class_1661 playerInventory) {
        this(id, playerInventory, class_2338.field_10980, (class_1263)new class_1277(2), class_3915.method_17403());
    }

    public PlaneWorkbenchContainer(int id, class_1661 playerInventory, class_2338 blockPos, class_1263 itemHandler, class_3915 selectedRecipe) {
        super(SimplePlanesContainers.PLANE_WORKBENCH, id);
        this.player = playerInventory.field_7546;
        this.itemHandler = itemHandler;
        this.usabilityTest = class_3914.method_17392((class_1937)this.player.field_6002, (class_2338)blockPos);
        this.recipeList = this.player.field_6002.method_8433().method_30027(SimplePlanesRecipes.PLANE_WORKBENCH_RECIPE_TYPE);
        this.selectedRecipe = selectedRecipe;
        this.method_7621(new class_1735(itemHandler, 0, 28, 47));
        this.method_7621(new class_1735(itemHandler, 1, 75, 47));
        this.method_7621(new PlaneCraftingResultSlot(this.player, this, this.resultItemHandler, 0, 134, 47));
        for (int i = 0; i < 3; ++i) {
            for (int j = 0; j < 9; ++j) {
                this.method_7621(new class_1735((class_1263)playerInventory, j + i * 9 + 9, 8 + j * 18, 84 + i * 18));
            }
        }
        for (int k = 0; k < 9; ++k) {
            this.method_7621(new class_1735((class_1263)playerInventory, k, 8 + k * 18, 142));
        }
        this.method_17362(selectedRecipe);
        this.updateCraftingResult();
    }

    public void cycleItems(CycleItemsPacket.Type type) {
        int prevSelectedRecipe = this.selectedRecipe.method_17407();
        class_1799 ingredient = this.itemHandler.method_5438(0);
        class_1799 material = this.itemHandler.method_5438(1);
        switch (type) {
            case CRAFTING_LEFT: {
                do {
                    if (this.selectedRecipe.method_17407() == 0) {
                        this.selectedRecipe.method_17404(this.recipeList.size() - 1);
                        continue;
                    }
                    this.selectedRecipe.method_17404(this.selectedRecipe.method_17407() - 1);
                } while (this.selectedRecipe.method_17407() != prevSelectedRecipe && !this.recipeList.get(this.selectedRecipe.method_17407()).canCraft(ingredient, material));
                break;
            }
            case CRAFTING_RIGHT: {
                do {
                    if (this.selectedRecipe.method_17407() == this.recipeList.size() - 1) {
                        this.selectedRecipe.method_17404(0);
                        continue;
                    }
                    this.selectedRecipe.method_17404(this.selectedRecipe.method_17407() + 1);
                } while (this.selectedRecipe.method_17407() != prevSelectedRecipe && !this.recipeList.get(this.selectedRecipe.method_17407()).canCraft(ingredient, material));
            }
        }
        this.updateCraftingResult();
    }

    public void onCrafting() {
        if (!this.player.field_6002.field_9236) {
            PlaneWorkbenchRecipe recipe = this.recipeList.get(this.selectedRecipe.method_17407());
            this.itemHandler.method_5434(0, recipe.ingredientAmount());
            this.itemHandler.method_5434(1, recipe.materialAmount());
            this.updateCraftingResult();
        }
    }

    protected void updateCraftingResult() {
        if (!this.player.field_6002.field_9236) {
            class_1747 blockItem;
            class_3222 serverPlayerEntity = (class_3222)this.player;
            class_1799 result = class_1799.field_8037;
            class_1799 ingredientStack = this.itemHandler.method_5438(0);
            class_1799 materialStack = this.itemHandler.method_5438(1);
            class_1792 materialItem = materialStack.method_7909();
            PlaneWorkbenchRecipe recipe = this.recipeList.get(this.selectedRecipe.method_17407());
            if (recipe.canCraft(ingredientStack, materialStack) && materialItem instanceof class_1747 && (blockItem = (class_1747)materialItem).method_7711().method_40142().method_40220(PLANE_MATERIALS_TAG)) {
                result = recipe.result().method_7972();
                class_2248 block = blockItem.method_7711();
                this.resultItemTag.method_10582("material", class_2378.field_11146.method_10221((Object)block).toString());
                result.method_7959("EntityTag", (class_2520)this.resultItemTag);
            }
            this.resultItemHandler.method_5447(0, result);
            serverPlayerEntity.field_13987.method_14364((class_2596)new class_2653(this.field_7763, 0, 2, result));
        }
    }

    public boolean method_7597(class_1657 playerIn) {
        return PlaneWorkbenchContainer.method_17695((class_3914)this.usabilityTest, (class_1657)playerIn, (class_2248)SimplePlanesBlocks.PLANE_WORKBENCH_BLOCK);
    }

    public void method_7593(int slotId, int dragType, class_1713 clickTypeIn, class_1657 player) {
        super.method_7593(slotId, dragType, clickTypeIn, player);
        this.updateCraftingResult();
    }

    public class_1799 method_7601(class_1657 playerIn, int index) {
        class_1735 slot = (class_1735)this.field_7761.get(index);
        if (slot != null && slot.method_7681()) {
            class_1799 inputItemStack = slot.method_7677();
            class_1799 originalItemStack = inputItemStack.method_7972();
            if (index == 2) {
                inputItemStack.method_7909().method_7843(inputItemStack, playerIn.field_6002, playerIn);
                if (!this.method_7616(inputItemStack, 3, 39, true)) {
                    return class_1799.field_8037;
                }
                slot.method_7670(inputItemStack, originalItemStack);
            } else if (index >= 3 && index < 39 ? !this.method_7616(inputItemStack, 0, 2, false) && (index < 30 ? !this.method_7616(inputItemStack, 30, 39, false) : !this.method_7616(inputItemStack, 3, 30, false)) : !this.method_7616(inputItemStack, 3, 39, false)) {
                return class_1799.field_8037;
            }
            if (inputItemStack.method_7960()) {
                slot.method_7673(class_1799.field_8037);
            } else {
                slot.method_7668();
            }
            if (inputItemStack.method_7947() == originalItemStack.method_7947()) {
                return class_1799.field_8037;
            }
            slot.method_7667(playerIn, inputItemStack);
            if (index == 2) {
                playerIn.method_7328(inputItemStack, false);
            }
        }
        return class_1799.field_8037;
    }
}

