/*
 * Decompiled with CFR 0.152.
 */
package xyz.przemyk.simpleplanes.datapack;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import net.fabricmc.fabric.api.resource.IdentifiableResourceReloadListener;
import net.minecraft.class_1299;
import net.minecraft.class_1792;
import net.minecraft.class_2248;
import net.minecraft.class_2378;
import net.minecraft.class_2487;
import net.minecraft.class_2522;
import net.minecraft.class_2960;
import net.minecraft.class_3300;
import net.minecraft.class_3518;
import net.minecraft.class_3695;
import net.minecraft.class_4309;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import xyz.przemyk.simpleplanes.datapack.PayloadEntry;

public class PlanePayloadReloadListener
extends class_4309
implements IdentifiableResourceReloadListener {
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().disableHtmlEscaping().create();
    private static final Logger LOGGER = LogManager.getLogger();
    public static final class_2960 ID = new class_2960("simpleplanes", "payload_listener");
    public static final Map<class_1792, PayloadEntry> payloadEntries = new HashMap<class_1792, PayloadEntry>();

    public PlanePayloadReloadListener() {
        super(GSON, "plane_payload");
    }

    protected void apply(Map<class_2960, JsonElement> map, class_3300 resourceManager, class_3695 profilerFiller) {
        payloadEntries.clear();
        for (Map.Entry<class_2960, JsonElement> entry : map.entrySet()) {
            try {
                class_2487 compoundTag;
                JsonObject jsonObject = class_3518.method_15295((JsonElement)entry.getValue(), (String)"top element");
                class_1792 item = Objects.requireNonNull((class_1792)class_2378.field_11142.method_10223(new class_2960(jsonObject.get("item").getAsString())), "missing item");
                class_2248 renderBlock = Objects.requireNonNull((class_2248)class_2378.field_11146.method_10223(new class_2960(jsonObject.get("block").getAsString())), "missing block");
                class_1299 dropSpawnEntity = Objects.requireNonNull((class_1299)class_2378.field_11145.method_10223(new class_2960(jsonObject.get("entity").getAsString())), "missing entity");
                if (jsonObject.has("entity_nbt")) {
                    String tag = class_3518.method_15287((JsonElement)jsonObject.get("entity_nbt"), (String)"entity_nbt");
                    compoundTag = class_2522.method_10718((String)tag);
                } else {
                    compoundTag = new class_2487();
                }
                payloadEntries.put(item, new PayloadEntry(item, renderBlock, dropSpawnEntity, compoundTag));
            }
            catch (Exception e) {
                LOGGER.error("Parsing error loading plane payload {}", (Object)entry.getKey(), (Object)e);
            }
        }
    }

    public class_2960 getFabricId() {
        return ID;
    }
}

