/*
 * Decompiled with CFR 0.152.
 */
package xyz.przemyk.simpleplanes.entities;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import net.fabricmc.fabric.api.networking.v1.ServerPlayNetworking;
import net.fabricmc.fabric.api.screenhandler.v1.ExtendedScreenHandlerFactory;
import net.minecraft.class_1158;
import net.minecraft.class_1160;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1282;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1309;
import net.minecraft.class_1313;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1703;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1927;
import net.minecraft.class_1928;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2378;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_2540;
import net.minecraft.class_2561;
import net.minecraft.class_2596;
import net.minecraft.class_2604;
import net.minecraft.class_2680;
import net.minecraft.class_2874;
import net.minecraft.class_2940;
import net.minecraft.class_2941;
import net.minecraft.class_2943;
import net.minecraft.class_2945;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3532;
import net.minecraft.class_3908;
import net.minecraft.class_5321;
import net.minecraft.class_6862;
import org.jetbrains.annotations.Nullable;
import xyz.przemyk.simpleplanes.SimplePlanesMod;
import xyz.przemyk.simpleplanes.client.PlaneSound;
import xyz.przemyk.simpleplanes.container.RemoveUpgradesContainer;
import xyz.przemyk.simpleplanes.misc.MathUtil;
import xyz.przemyk.simpleplanes.network.ChangeThrottlePacket;
import xyz.przemyk.simpleplanes.network.RotationPacket;
import xyz.przemyk.simpleplanes.network.SUpgradeRemovedPacket;
import xyz.przemyk.simpleplanes.network.SpawnPlanePacket;
import xyz.przemyk.simpleplanes.network.UpdateUpgradePacket;
import xyz.przemyk.simpleplanes.setup.SimplePlanesDataSerializers;
import xyz.przemyk.simpleplanes.setup.SimplePlanesItems;
import xyz.przemyk.simpleplanes.setup.SimplePlanesRegistries;
import xyz.przemyk.simpleplanes.setup.SimplePlanesUpgrades;
import xyz.przemyk.simpleplanes.upgrades.Upgrade;
import xyz.przemyk.simpleplanes.upgrades.UpgradeType;
import xyz.przemyk.simpleplanes.upgrades.armor.ArmorUpgrade;
import xyz.przemyk.simpleplanes.upgrades.engines.EngineUpgrade;
import xyz.przemyk.simpleplanes.upgrades.shooter.ShooterUpgrade;

public class PlaneEntity
extends class_1297 {
    public static final class_2940<Integer> MAX_HEALTH = class_2945.method_12791(PlaneEntity.class, (class_2941)class_2943.field_13327);
    public static final class_2940<Integer> HEALTH = class_2945.method_12791(PlaneEntity.class, (class_2941)class_2943.field_13327);
    public static final class_2940<Float> MAX_SPEED = class_2945.method_12791(PlaneEntity.class, (class_2941)class_2943.field_13320);
    public static final class_2940<String> MATERIAL = class_2945.method_12791(PlaneEntity.class, (class_2941)class_2943.field_13326);
    public static final class_2940<Integer> TIME_SINCE_HIT = class_2945.method_12791(PlaneEntity.class, (class_2941)class_2943.field_13327);
    public static final class_2940<Float> DAMAGE_TAKEN = class_2945.method_12791(PlaneEntity.class, (class_2941)class_2943.field_13320);
    public static final class_2940<class_1158> Q = class_2945.method_12791(PlaneEntity.class, SimplePlanesDataSerializers.QUATERNION_SERIALIZER_ENTRY);
    public static final class_2940<Integer> THROTTLE = class_2945.method_12791(PlaneEntity.class, (class_2941)class_2943.field_13327);
    public static final class_2940<Byte> PITCH_UP = class_2945.method_12791(PlaneEntity.class, (class_2941)class_2943.field_13319);
    public static final class_2940<Byte> YAW_RIGHT = class_2945.method_12791(PlaneEntity.class, (class_2941)class_2943.field_13319);
    public static final int MAX_THROTTLE = 5;
    public class_1158 Q_Client = new class_1158(class_1158.field_21493);
    public class_1158 Q_Prev = new class_1158(class_1158.field_21493);
    private int onGroundTicks;
    public final HashMap<class_2960, Upgrade> upgrades = new HashMap();
    public EngineUpgrade engineUpgrade = null;
    public float rotationRoll;
    public float prevRotationRoll;
    private float deltaRotation;
    private float deltaRotationLeft;
    private int deltaRotationTicks;
    private class_2248 planksMaterial;
    private int damageTimeout;
    public int notMovingTime;
    public int goldenHeartsTimeout = 0;
    private final int networkUpdateInterval;
    public float propellerRotationOld;
    public float propellerRotationNew;
    public static final class_6862<class_2874> BLACKLISTED_DIMENSIONS_TAG = class_6862.method_40092((class_5321)class_2378.field_25095, (class_2960)new class_2960("simpleplanes", "blacklisted_dimensions"));
    protected float pitchSpeed = 0.0f;
    protected float yawSpeed = 0.0f;
    protected float rollSpeed = 0.0f;
    public static final class_6862<class_2248> FIREPROOF_MATERIALS_TAG = class_6862.method_40092((class_5321)class_2378.field_25105, (class_2960)new class_2960("simpleplanes", "fireproof_materials"));
    private int lerpSteps;
    private int lerpStepsQ;
    private double lerpX;
    private double lerpY;
    private double lerpZ;
    private static final TempMotionVars TEMP_MOTION_VARS = new TempMotionVars();

    public PlaneEntity(class_1299<?> entityTypeIn, class_1937 worldIn) {
        this(entityTypeIn, worldIn, class_2246.field_10161);
    }

    public PlaneEntity(class_1299<?> entityTypeIn, class_1937 worldIn, class_2248 material) {
        super(entityTypeIn, worldIn);
        this.networkUpdateInterval = entityTypeIn.method_18388();
        this.field_6013 = 0.9999f;
        this.setMaterial(material);
        this.setMaxSpeed(1.0f);
    }

    public PlaneEntity(class_1299<? extends PlaneEntity> entityTypeIn, class_1937 worldIn, class_2248 material, double x, double y, double z) {
        this(entityTypeIn, worldIn, material);
        this.method_5814(x, y, z);
    }

    protected void method_5693() {
        this.field_6011.method_12784(MAX_HEALTH, (Object)10);
        this.field_6011.method_12784(HEALTH, (Object)10);
        this.field_6011.method_12784(Q, (Object)class_1158.field_21493);
        this.field_6011.method_12784(MAX_SPEED, (Object)Float.valueOf(0.25f));
        this.field_6011.method_12784(MATERIAL, (Object)class_2378.field_11146.method_10221((Object)class_2246.field_10161).toString());
        this.field_6011.method_12784(TIME_SINCE_HIT, (Object)0);
        this.field_6011.method_12784(DAMAGE_TAKEN, (Object)Float.valueOf(0.0f));
        this.field_6011.method_12784(THROTTLE, (Object)0);
        this.field_6011.method_12784(PITCH_UP, (Object)0);
        this.field_6011.method_12784(YAW_RIGHT, (Object)0);
    }

    public float getMaxSpeed() {
        return ((Float)this.field_6011.method_12789(MAX_SPEED)).floatValue();
    }

    public void setMaxSpeed(float maxSpeed) {
        this.field_6011.method_12778(MAX_SPEED, (Object)Float.valueOf(maxSpeed));
    }

    public class_1158 getQ() {
        return new class_1158((class_1158)this.field_6011.method_12789(Q));
    }

    public void setQ(class_1158 q) {
        this.field_6011.method_12778(Q, (Object)q);
    }

    public class_1158 getQ_Client() {
        return new class_1158(this.Q_Client);
    }

    public void setQ_Client(class_1158 q) {
        this.Q_Client = q;
    }

    public class_1158 getQ_Prev() {
        return this.Q_Prev.method_23695();
    }

    public void setQ_prev(class_1158 q) {
        this.Q_Prev = q;
    }

    public class_2248 getMaterial() {
        return this.planksMaterial;
    }

    public void setHealth(int health) {
        this.field_6011.method_12778(HEALTH, (Object)Math.max(health, 0));
    }

    public int getHealth() {
        return (Integer)this.field_6011.method_12789(HEALTH);
    }

    public int getMaxHealth() {
        return (Integer)this.field_6011.method_12789(MAX_HEALTH);
    }

    public class_1799 method_31480() {
        return this.getItemStack();
    }

    public void setMaterial(String material) {
        this.field_6011.method_12778(MATERIAL, (Object)material);
        class_2248 block = (class_2248)class_2378.field_11146.method_10223(new class_2960(material));
        this.planksMaterial = block == null ? class_2246.field_10161 : block;
    }

    public void setMaterial(class_2248 material) {
        this.field_6011.method_12778(MATERIAL, (Object)class_2378.field_11146.method_10221((Object)material).toString());
        this.planksMaterial = material;
    }

    public boolean isPowered() {
        return this.method_5805() && !this.field_6002.method_40134().method_40220(BLACKLISTED_DIMENSIONS_TAG) && (this.isCreative() || this.engineUpgrade != null && this.engineUpgrade.isPowered());
    }

    protected boolean method_5818(class_1297 passenger) {
        List passengers = this.method_5685();
        if (!this.upgrades.containsKey(SimplePlanesRegistries.UPGRADE_TYPES.method_10221((Object)SimplePlanesUpgrades.SEATS))) {
            return passengers.isEmpty();
        }
        return passengers.size() < 3;
    }

    public class_1269 method_5688(class_1657 player, class_1268 hand) {
        class_1799 itemStack = player.method_5998(hand);
        if (player.method_5715() && itemStack.method_7960()) {
            boolean hasPlayer = false;
            for (class_1297 passenger : this.method_5685()) {
                if (!(passenger instanceof class_1657)) continue;
                hasPlayer = true;
                break;
            }
            if (!hasPlayer) {
                this.method_5772();
            }
            return class_1269.field_5812;
        }
        if (itemStack.method_7909() == SimplePlanesItems.WRENCH) {
            if (!this.field_6002.field_9236) {
                player.method_17355((class_3908)new ExtendedScreenHandlerFactory(){

                    public void writeScreenOpeningData(class_3222 player, class_2540 buf) {
                        buf.method_10804(PlaneEntity.this.method_5628());
                    }

                    public class_2561 method_5476() {
                        return class_2561.method_43473();
                    }

                    @Nullable
                    public class_1703 createMenu(int id, class_1661 inventory, class_1657 player) {
                        return new RemoveUpgradesContainer(id, PlaneEntity.this.method_5628());
                    }
                });
                return class_1269.field_21466;
            }
            return class_1269.field_5812;
        }
        if (this.tryToAddUpgrade(player, itemStack)) {
            return class_1269.field_5812;
        }
        if (!itemStack.method_7960() && player.method_5854() == this) {
            for (Upgrade upgrade : this.upgrades.values()) {
                upgrade.onItemRightClick(player, itemStack, hand);
            }
        }
        if (!this.field_6002.field_9236) {
            return player.method_5804((class_1297)this) ? class_1269.field_21466 : class_1269.field_5814;
        }
        return player.method_5668() == this.method_5668() ? class_1269.field_5814 : class_1269.field_5812;
    }

    protected boolean tryToAddUpgrade(class_1657 playerEntity, class_1799 itemStack) {
        Optional<UpgradeType> upgradeTypeOptional = SimplePlanesUpgrades.getUpgradeFromItem(itemStack.method_7909());
        return upgradeTypeOptional.map(upgradeType -> {
            if (this.canAddUpgrade((UpgradeType)upgradeType)) {
                Upgrade upgrade = upgradeType.instanceSupplier.apply(this);
                this.addUpgrade(playerEntity, itemStack, upgrade);
                return true;
            }
            return false;
        }).orElse(false);
    }

    protected void addUpgrade(class_1657 playerEntity, class_1799 itemStack, Upgrade upgrade) {
        upgrade.onApply(itemStack, playerEntity);
        if (!playerEntity.method_7337()) {
            itemStack.method_7934(1);
        }
        UpgradeType upgradeType = upgrade.getType();
        this.upgrades.put(SimplePlanesRegistries.UPGRADE_TYPES.method_10221((Object)upgradeType), upgrade);
        if (upgradeType.isEngine) {
            this.engineUpgrade = (EngineUpgrade)upgrade;
        }
        if (!this.field_6002.field_9236) {
            UpdateUpgradePacket.send(SimplePlanesRegistries.UPGRADE_TYPES.method_10221((Object)upgradeType), true, this);
        }
    }

    public boolean method_5643(class_1282 source, float amount) {
        boolean creativePlayer;
        class_1297 entity = source.method_5526();
        if (entity == this.method_5642() && entity instanceof class_1657) {
            class_1657 player = (class_1657)entity;
            Upgrade upgrade = this.upgrades.get(SimplePlanesRegistries.UPGRADE_TYPES.method_10221((Object)SimplePlanesUpgrades.SHOOTER));
            if (upgrade instanceof ShooterUpgrade) {
                ShooterUpgrade shooterUpgrade = (ShooterUpgrade)upgrade;
                shooterUpgrade.use(player);
            }
            return false;
        }
        if (this.getOnGround() && entity instanceof class_1657) {
            amount *= 3.0f;
        } else {
            Upgrade upgrade = this.upgrades.get(SimplePlanesRegistries.UPGRADE_TYPES.method_10221((Object)SimplePlanesUpgrades.ARMOR));
            if (upgrade instanceof ArmorUpgrade) {
                ArmorUpgrade armorUpgrade = (ArmorUpgrade)upgrade;
                amount = armorUpgrade.getReducedDamage(amount);
            }
        }
        this.setTimeSinceHit(20);
        this.setDamageTaken(this.getDamageTaken() + 10.0f * amount);
        if (this.method_5679(source) || this.damageTimeout > 0) {
            return false;
        }
        if (this.field_6002.field_9236 || this.method_31481()) {
            return false;
        }
        int health = this.getHealth();
        if (health < 0) {
            return false;
        }
        this.setHealth((int)((float)health - amount));
        this.damageTimeout = 10;
        boolean isPlayer = source.method_5526() instanceof class_1657;
        boolean bl = creativePlayer = isPlayer && ((class_1657)source.method_5529()).method_31549().field_7477;
        if (creativePlayer) {
            this.method_5768();
        } else if (source == SimplePlanesMod.DAMAGE_SOURCE_PLANE_CRASH) {
            this.explode();
            this.method_5768();
            if (this.field_6002.method_8450().method_8355(class_1928.field_19393)) {
                this.dropItem();
            }
        } else if (this.getOnGround() && this.getHealth() <= 0) {
            this.method_5768();
            if (this.field_6002.method_8450().method_8355(class_1928.field_19393)) {
                this.dropItem();
            }
        }
        return true;
    }

    private void explode() {
        ((class_3218)this.field_6002).method_14199((class_2394)class_2398.field_11251, this.method_23317(), this.method_23318(), this.method_23321(), 5, 1.0, 1.0, 1.0, 2.0);
        ((class_3218)this.field_6002).method_14199((class_2394)class_2398.field_11203, this.method_23317(), this.method_23318(), this.method_23321(), 10, 1.0, 1.0, 1.0, 1.0);
        this.field_6002.method_8437((class_1297)this, this.method_23317(), this.method_23318(), this.method_23321(), 4.0f, class_1927.class_4179.field_18686);
    }

    protected void dropItem() {
        class_1799 itemStack = this.getItemStack();
        this.method_5775(itemStack).method_5684(true);
    }

    public boolean method_5863() {
        return true;
    }

    public void method_5773() {
        class_1297 controllingPassenger;
        super.method_5773();
        if (Double.isNaN(this.method_18798().method_1033())) {
            this.method_18799(class_243.field_1353);
        }
        this.field_5982 = this.method_36454();
        this.field_6004 = this.method_36455();
        this.prevRotationRoll = this.rotationRoll;
        if (this.field_6002.field_9236) {
            this.propellerRotationOld = this.propellerRotationNew;
            if (this.isPowered()) {
                int throttle = this.getThrottle();
                this.propellerRotationNew = (float)((double)this.propellerRotationNew + (double)throttle * 0.1);
            }
        }
        if (this.field_6002.field_9236 && this.getHealth() <= 0) {
            this.field_6002.method_17452((class_2394)class_2398.field_11237, true, this.method_23317(), this.method_23318(), this.method_23321(), 0.0, 0.005, 0.0);
        }
        if (this.field_6002.field_9236 && this.getTimeSinceHit() > 0) {
            this.setTimeSinceHit(this.getTimeSinceHit() - 1);
        }
        if (this.field_6002.field_9236 && !this.method_5787()) {
            this.tickLerp();
            this.method_18799(class_243.field_1353);
            this.tickDeltaRotation(this.getQ_Client());
            this.tickUpgrades();
            return;
        }
        this.method_5785();
        TempMotionVars tempMotionVars = this.getMotionVars();
        if (this.method_5740()) {
            tempMotionVars.gravity = 0.0;
            tempMotionVars.maxLift = 0.0f;
            tempMotionVars.push = 0.0f;
            tempMotionVars.passiveEnginePush = 0.0f;
        }
        if ((controllingPassenger = this.method_5642()) instanceof class_1657) {
            class_1657 playerEntity = (class_1657)controllingPassenger;
            tempMotionVars.moveForward = this.getMoveForward(playerEntity);
            tempMotionVars.moveStrafing = playerEntity.field_6212;
        } else {
            tempMotionVars.moveForward = 0.0f;
            tempMotionVars.moveStrafing = 0.0f;
            this.method_5728(false);
        }
        tempMotionVars.turnThreshold = 0.2;
        if ((double)Math.abs(tempMotionVars.moveStrafing) < tempMotionVars.turnThreshold) {
            tempMotionVars.moveStrafing = 0.0f;
        }
        class_1158 q = this.field_6002.field_9236 ? this.getQ_Client() : this.getQ();
        MathUtil.EulerAngles anglesOld = MathUtil.toEulerAngles(q).copy();
        class_243 oldMotion = this.method_18798();
        if (this.field_6002.field_9236 && this.isPowered() && this.getThrottle() > 0) {
            PlaneSound.tryToPlay(this);
        }
        tempMotionVars.push = 0.00625f * (float)this.getThrottle();
        if (this.method_18798().method_1033() > 0.05) {
            q = this.tickRotateMotion(tempMotionVars, q, this.method_18798());
        }
        boolean doPitch = true;
        if (this.getOnGround() || this.isOnWater()) {
            doPitch = this.tickOnGround(tempMotionVars);
        } else {
            --this.onGroundTicks;
        }
        if (doPitch) {
            this.tickPitch(tempMotionVars);
        }
        this.tickYaw();
        this.tickMotion(tempMotionVars);
        this.tickRoll(tempMotionVars);
        this.tickUpgrades();
        if (this.onGroundTicks > -50 && oldMotion.method_1033() < 0.002 && this.method_18798().method_1033() < 0.002) {
            this.method_18799(class_243.field_1353);
        }
        this.method_23311();
        if (!this.field_5952 || MathUtil.getHorizontalDistanceSqr(this.method_18798()) > (double)1.0E-5f || (this.field_6012 + this.method_5628()) % 4 == 0) {
            double speedBefore = Math.sqrt(MathUtil.getHorizontalDistanceSqr(this.method_18798()));
            boolean onGroundOld = this.field_5952;
            class_243 motion = this.method_18798();
            if (motion.method_1027() > 0.25 || this.getPitchUp() != 0) {
                this.field_5952 = true;
            }
            this.method_5784(class_1313.field_6308, motion);
            boolean bl = this.field_5952 = motion.method_10214() == 0.0 ? onGroundOld : this.field_5952;
            if (this.field_5976 && !this.field_6002.field_9236 && this.onGroundTicks <= 0) {
                if (this.getHealth() <= 0) {
                    this.crash(16.0f);
                } else {
                    double speedAfter = Math.sqrt(MathUtil.getHorizontalDistanceSqr(this.method_18798()));
                    double speedDiff = speedBefore - speedAfter;
                    float f2 = (float)(speedDiff * 10.0 - 5.0);
                    if (f2 > 5.0f) {
                        this.crash(f2);
                    }
                }
            }
        }
        if (this.getHealth() <= 0 && this.field_5952 && !this.method_31481()) {
            this.crash(16.0f);
        }
        q.method_4925(new class_1158(class_1160.field_20707, (float)((double)this.rotationRoll - anglesOld.roll), true));
        q.method_4925(new class_1158(class_1160.field_20702, (float)((double)this.method_36455() - anglesOld.pitch), true));
        q.method_4925(new class_1158(class_1160.field_20705, (float)((double)this.method_36454() - anglesOld.yaw), true));
        q = MathUtil.normalizeQuaternion(q);
        this.setQ_prev(this.getQ_Client());
        this.setQ(q);
        this.tickDeltaRotation(q);
        if (this.field_6002.field_9236 && this.method_5787()) {
            this.setQ_Client(q);
            RotationPacket.send(this.getQ());
        } else {
            class_3222 player = (class_3222)this.getPlayer();
            if (player != null) {
                player.field_13987.field_14137 = 0;
            }
        }
        if (this.damageTimeout > 0) {
            --this.damageTimeout;
        }
        if (this.getDamageTaken() > 0.0f) {
            this.setDamageTaken(this.getDamageTaken() - 1.0f);
        }
        if (!this.field_6002.field_9236 && this.getHealth() > this.getMaxHealth() & this.goldenHeartsTimeout > (this.getOnGround() ? 300 : 100)) {
            this.setHealth(this.getHealth() - 1);
            this.goldenHeartsTimeout = 0;
        }
        if (this.goldenHeartsTimeout < 1000 && this.isPowered()) {
            ++this.goldenHeartsTimeout;
        }
        this.tickLerp();
    }

    protected float getMoveForward(class_1657 player) {
        return player.field_6250;
    }

    public void tickUpgrades() {
        ArrayList upgradesToRemove = new ArrayList();
        this.upgrades.forEach((rl, upgrade) -> {
            upgrade.tick();
            if (upgrade.removed) {
                upgradesToRemove.add(rl);
            }
        });
        for (class_2960 name : upgradesToRemove) {
            this.upgrades.remove(name);
        }
        if (!this.field_6002.field_9236 && this.field_6012 % this.networkUpdateInterval == 0) {
            this.upgrades.forEach((rl, upgrade) -> {
                if (upgrade.updateClient) {
                    UpdateUpgradePacket.send(rl, false, this);
                    upgrade.updateClient = false;
                }
            });
        }
    }

    public int getFuelCost() {
        return 1;
    }

    protected TempMotionVars getMotionVars() {
        TEMP_MOTION_VARS.reset();
        PlaneEntity.TEMP_MOTION_VARS.maxPushSpeed = this.getMaxSpeed() * 10.0f;
        return TEMP_MOTION_VARS;
    }

    protected void tickDeltaRotation(class_1158 q) {
        MathUtil.EulerAngles angles = MathUtil.toEulerAngles(q);
        this.method_36457((float)angles.pitch);
        this.method_36456((float)angles.yaw);
        this.rotationRoll = (float)angles.roll;
        float d = (float)MathUtil.wrapSubtractDegrees(this.field_5982, this.method_36454());
        if (this.rotationRoll >= 90.0f && this.prevRotationRoll <= 90.0f) {
            d = 0.0f;
        }
        int diff = 3;
        this.deltaRotationTicks = Math.min(10, Math.max((int)Math.abs(this.deltaRotationLeft) * 5, this.deltaRotationTicks));
        this.deltaRotationLeft = (float)((double)this.deltaRotationLeft * 0.7);
        this.deltaRotationLeft += d;
        this.deltaRotationLeft = class_3532.method_15393((float)this.deltaRotationLeft);
        this.deltaRotation = Math.min(Math.abs(this.deltaRotationLeft), (float)diff) * Math.signum(this.deltaRotationLeft);
        this.deltaRotationLeft -= this.deltaRotation;
        if (!(this.deltaRotation > 0.0f)) {
            --this.deltaRotationTicks;
        }
    }

    protected float getRotationSpeedMultiplier() {
        return 1.0f;
    }

    protected void tickPitch(TempMotionVars tempMotionVars) {
        float pitch;
        if (this.getHealth() <= 0) {
            pitch = 10.0f;
        } else {
            if (this.getPitchUp() > 0) {
                this.pitchSpeed += 0.5f * this.getRotationSpeedMultiplier();
            } else if (this.getPitchUp() < 0) {
                this.pitchSpeed -= 0.5f * this.getRotationSpeedMultiplier();
            } else if (this.pitchSpeed < 0.0f) {
                this.pitchSpeed += 0.5f * this.getRotationSpeedMultiplier();
            } else if (this.pitchSpeed > 0.0f) {
                this.pitchSpeed -= 0.5f * this.getRotationSpeedMultiplier();
            }
            pitch = this.pitchSpeed = class_3532.method_15363((float)this.pitchSpeed, (float)(-5.0f * this.getRotationSpeedMultiplier()), (float)(5.0f * this.getRotationSpeedMultiplier()));
        }
        this.method_36457(this.method_36455() + pitch);
    }

    protected void tickYaw() {
        float yaw;
        if (this.getHealth() <= 0) {
            yaw = 10.0f;
        } else {
            if (this.getYawRight() > 0) {
                this.yawSpeed += 0.5f * this.getRotationSpeedMultiplier();
            } else if (this.getYawRight() < 0) {
                this.yawSpeed -= 0.5f * this.getRotationSpeedMultiplier();
            } else if (this.yawSpeed < 0.0f) {
                this.yawSpeed += 0.5f * this.getRotationSpeedMultiplier();
            } else if (this.yawSpeed > 0.0f) {
                this.yawSpeed -= 0.5f * this.getRotationSpeedMultiplier();
            }
            yaw = this.yawSpeed = class_3532.method_15363((float)this.yawSpeed, (float)(-2.5f * this.getRotationSpeedMultiplier()), (float)(2.5f * this.getRotationSpeedMultiplier()));
        }
        this.method_36456(this.method_36454() + yaw);
    }

    protected void tickRoll(TempMotionVars tempMotionVars) {
        if (this.getHealth() <= 0) {
            this.rotationRoll += this.method_5628() % 2 == 0 ? 10.0f : -10.0f;
            return;
        }
        double turn = 0.0;
        if (this.getOnGround() || this.isOnWater()) {
            turn = tempMotionVars.moveStrafing > 0.0f ? 3.0 : (tempMotionVars.moveStrafing == 0.0f ? 0.0 : -3.0);
            this.rotationRoll = MathUtil.lerpAngle(0.1f, this.rotationRoll, 0.0f);
        } else {
            if (tempMotionVars.moveStrafing > 0.0f) {
                this.rollSpeed += 0.5f;
            } else if (tempMotionVars.moveStrafing < 0.0f) {
                this.rollSpeed -= 0.5f;
            } else if (this.rollSpeed < 0.0f) {
                this.rollSpeed += 0.5f;
            } else if (this.rollSpeed > 0.0f) {
                this.rollSpeed -= 0.5f;
            }
            this.rollSpeed = class_3532.method_15363((float)this.rollSpeed, (float)-5.0f, (float)5.0f);
            this.rotationRoll += this.rollSpeed;
        }
        this.method_36456((float)((double)this.method_36454() - turn));
    }

    protected void tickMotion(TempMotionVars tempMotionVars) {
        class_243 pushVec;
        if (!this.isPowered()) {
            tempMotionVars.push = 0.0f;
        }
        class_243 motion = this.method_18798();
        double speed = motion.method_1033();
        double brakesMul = this.getThrottle() == 0 ? 5.0 : 1.0;
        speed -= (speed * speed * tempMotionVars.dragQuad + speed * tempMotionVars.dragMul + tempMotionVars.drag) * brakesMul;
        if ((speed = Math.max(speed, 0.0)) > tempMotionVars.maxSpeed) {
            speed = class_3532.method_16436((double)0.2, (double)speed, (double)tempMotionVars.maxSpeed);
        }
        if (speed == 0.0) {
            motion = class_243.field_1353;
        }
        if (motion.method_1033() > 0.0) {
            motion = motion.method_1021(speed / motion.method_1033());
        }
        if ((pushVec = new class_243(this.getTickPush(tempMotionVars))).method_1033() != 0.0 && motion.method_1033() > 0.1) {
            double dot = MathUtil.normalizedDotProduct(pushVec, motion);
            pushVec = pushVec.method_1021(class_3532.method_15350((double)(1.0 - dot * speed / (tempMotionVars.maxPushSpeed * ((double)tempMotionVars.push + 0.05))), (double)0.0, (double)2.0));
        }
        motion = motion.method_1019(pushVec);
        motion = motion.method_1031(0.0, tempMotionVars.gravity, 0.0);
        this.method_18799(motion);
    }

    protected class_1160 getTickPush(TempMotionVars tempMotionVars) {
        return this.transformPos(new class_1160(0.0f, 0.0f, tempMotionVars.push));
    }

    protected boolean tickOnGround(TempMotionVars tempMotionVars) {
        this.notMovingTime = this.method_18798().method_1027() < 0.01 && this.getOnGround() ? ++this.notMovingTime : 0;
        if (this.notMovingTime > 200 && this.getHealth() < this.getMaxHealth() && this.getPlayer() != null) {
            this.setHealth(this.getHealth() + 1);
            this.notMovingTime = 100;
        }
        boolean speedingUp = true;
        this.onGroundTicks = this.onGroundTicks < 0 ? 5 : --this.onGroundTicks;
        float pitch = this.getGroundPitch();
        if (this.isPowered() && this.getPitchUp() > 0 || this.isOnWater()) {
            pitch = 0.0f;
        } else if (this.method_18798().method_1033() > tempMotionVars.takeOffSpeed) {
            pitch /= 2.0f;
        }
        this.method_36457(MathUtil.lerpAngle(0.1f, this.method_36455(), pitch));
        if (MathUtil.degreesDifferenceAbs(this.method_36455(), 0.0) > 1.0 && this.method_18798().method_1033() < 0.1) {
            tempMotionVars.push /= 5.0f;
        }
        if (this.method_18798().method_1033() < tempMotionVars.takeOffSpeed) {
            speedingUp = false;
        }
        if (this.getPitchUp() < 0) {
            tempMotionVars.push = -tempMotionVars.groundPush;
        } else if (this.getPitchUp() > 0 && tempMotionVars.push < tempMotionVars.groundPush) {
            tempMotionVars.push = tempMotionVars.groundPush;
        }
        if (!this.isPowered()) {
            tempMotionVars.push = 0.0f;
        }
        class_2338 pos = new class_2338(this.method_23317(), this.method_23318() - 1.0, this.method_23321());
        float f = this.field_6002.method_8320(pos).method_26204().method_9499();
        tempMotionVars.dragMul *= (double)(20.0f * (3.0f - f));
        return speedingUp;
    }

    protected float getGroundPitch() {
        return 5.0f;
    }

    protected class_1158 tickRotateMotion(TempMotionVars tempMotionVars, class_1158 q, class_243 motion) {
        float d;
        float yaw = MathUtil.getYaw(motion);
        float pitch = MathUtil.getPitch(motion);
        if (MathUtil.degreesDifferenceAbs(yaw, this.method_36454()) > 5.0 && (this.getOnGround() || this.isOnWater())) {
            this.method_18799(motion.method_1021(0.98));
        }
        if ((d = (float)MathUtil.degreesDifferenceAbs(pitch, this.method_36455())) > 180.0f) {
            d -= 180.0f;
        }
        d /= 60.0f;
        d = Math.min(1.0f, d);
        d *= d;
        d = 1.0f - d;
        double speed = this.method_18798().method_1033();
        double lift = Math.min(speed * tempMotionVars.liftFactor, (double)tempMotionVars.maxLift) * (double)d;
        if (this.getHealth() <= 0) {
            lift = 0.0;
        }
        this.method_18799(MathUtil.rotationToVector(MathUtil.lerpAngle180(0.1f, yaw, this.method_36454()), (double)MathUtil.lerpAngle180(tempMotionVars.pitchToMotion * d, pitch, this.method_36455()) + lift, speed));
        if (!this.getOnGround() && !this.isOnWater() && motion.method_1033() > 0.1) {
            if (MathUtil.degreesDifferenceAbs(pitch, this.method_36455()) > 90.0) {
                pitch = class_3532.method_15393((float)(pitch + 180.0f));
            }
            if (Math.abs(this.method_36455()) < 85.0f) {
                yaw = MathUtil.getYaw(this.method_18798());
                if (MathUtil.degreesDifferenceAbs(yaw, this.method_36454()) > 90.0) {
                    yaw -= 180.0f;
                }
                class_1158 q1 = MathUtil.toQuaternion(yaw, pitch, this.rotationRoll);
                q = MathUtil.lerpQ(tempMotionVars.motionToRotation, q, q1);
            }
        }
        return q;
    }

    public class_1160 transformPos(class_1160 relPos) {
        MathUtil.EulerAngles angles = MathUtil.toEulerAngles(this.getQ_Client());
        angles.yaw = -angles.yaw;
        angles.roll = -angles.roll;
        relPos.method_19262(MathUtil.toQuaternion(angles.yaw, angles.pitch, angles.roll));
        return relPos;
    }

    @javax.annotation.Nullable
    public class_1297 method_5642() {
        List list = this.method_5685();
        return list.isEmpty() ? null : (class_1297)list.get(0);
    }

    public void method_5749(class_2487 compound) {
        if (compound.method_10545("max_speed")) {
            this.field_6011.method_12778(MAX_SPEED, (Object)Float.valueOf(compound.method_10583("max_speed")));
        }
        if (compound.method_10545("max_health")) {
            int maxHealth = compound.method_10550("max_health");
            if (maxHealth <= 0) {
                maxHealth = 20;
            }
            this.field_6011.method_12778(MAX_HEALTH, (Object)maxHealth);
        }
        if (compound.method_10545("health")) {
            int health = compound.method_10550("health");
            this.field_6011.method_12778(HEALTH, (Object)health);
        }
        if (compound.method_10545("material")) {
            this.setMaterial(compound.method_10558("material"));
        }
        if (compound.method_10545("upgrades")) {
            class_2487 upgradesNBT = compound.method_10562("upgrades");
            this.deserializeUpgrades(upgradesNBT);
        }
        this.setQ(new class_1158(this.method_36455(), this.method_36454(), 0.0f, true));
    }

    private void deserializeUpgrades(class_2487 upgradesNBT) {
        for (String key : upgradesNBT.method_10541()) {
            class_2960 resourceLocation = new class_2960(key);
            UpgradeType upgradeType = (UpgradeType)SimplePlanesRegistries.UPGRADE_TYPES.method_10223(resourceLocation);
            if (upgradeType == null) continue;
            Upgrade upgrade = upgradeType.instanceSupplier.apply(this);
            upgrade.deserializeNBT(upgradesNBT.method_10562(key));
            this.upgrades.put(resourceLocation, upgrade);
            if (!upgradeType.isEngine) continue;
            this.engineUpgrade = (EngineUpgrade)upgrade;
        }
    }

    public void method_5652(class_2487 compound) {
        compound.method_10569("health", ((Integer)this.field_6011.method_12789(HEALTH)).intValue());
        compound.method_10569("max_health", ((Integer)this.field_6011.method_12789(MAX_HEALTH)).intValue());
        compound.method_10548("max_speed", ((Float)this.field_6011.method_12789(MAX_SPEED)).floatValue());
        compound.method_10582("material", (String)this.field_6011.method_12789(MATERIAL));
        compound.method_10566("upgrades", (class_2520)this.getUpgradesNBT());
    }

    private class_2487 getUpgradesNBT() {
        class_2487 upgradesNBT = new class_2487();
        for (Upgrade upgrade : this.upgrades.values()) {
            upgradesNBT.method_10566(SimplePlanesRegistries.UPGRADE_TYPES.method_10221((Object)upgrade.getType()).toString(), (class_2520)upgrade.serializeNBT());
        }
        return upgradesNBT;
    }

    protected boolean method_5860(class_1297 entityIn) {
        return true;
    }

    public boolean method_5788() {
        return this.upgrades.containsKey(SimplePlanesRegistries.UPGRADE_TYPES.method_10221((Object)SimplePlanesUpgrades.FLOATY_BEDDING));
    }

    public boolean method_30948() {
        return true;
    }

    public class_2596<?> method_18002() {
        return ServerPlayNetworking.createS2CPacket((class_2960)SpawnPlanePacket.ID, (class_2540)SpawnPlanePacket.createBuffer(this));
    }

    public void method_5674(class_2940<?> key) {
        super.method_5674(key);
        if (MATERIAL.equals(key) && this.field_6002.method_8608()) {
            class_2248 block = (class_2248)class_2378.field_11146.method_10223(new class_2960((String)this.field_6011.method_12789(MATERIAL)));
            this.planksMaterial = block == null ? class_2246.field_10161 : block;
        } else if (Q.equals(key) && this.field_6002.method_8608() && !this.method_5787()) {
            if (this.field_5953) {
                this.lerpStepsQ = 0;
                this.setQ_Client(this.getQ());
                this.setQ_prev(this.getQ());
            } else {
                this.lerpStepsQ = 10;
            }
        }
    }

    public double method_5621() {
        return 0.5;
    }

    public boolean method_5679(class_1282 source) {
        if (source.method_5535()) {
            return false;
        }
        if (source.method_5534() && this.planksMaterial.method_40142().method_40220(FIREPROOF_MATERIALS_TAG)) {
            return true;
        }
        if (source.method_5526() != null && source.method_5526().method_5794((class_1297)this)) {
            return true;
        }
        return super.method_5679(source);
    }

    public boolean method_5753() {
        return this.planksMaterial.method_40142().method_40220(FIREPROOF_MATERIALS_TAG);
    }

    protected void method_5623(double y, boolean onGroundIn, class_2680 state, class_2338 pos) {
        if (onGroundIn || this.isOnWater()) {
            double y1 = this.transformPos(new class_1160(0.0f, 1.0f, 0.0f)).method_4945();
            if (y1 < Math.cos(Math.toRadians(this.getLandingAngle()))) {
                state.method_26204().method_9554(this.field_6002, state, pos, (class_1297)this, (float)(this.method_18798().method_1033() * 5.0));
            }
            this.field_6017 = 0.0f;
        }
    }

    protected int getLandingAngle() {
        return 30;
    }

    public boolean method_5747(float fallDistance, float damageMultiplier, class_1282 p_146830_) {
        if (MathUtil.degreesDifferenceAbs(this.rotationRoll, 0.0) > 45.0) {
            this.crash(fallDistance * damageMultiplier);
        }
        return false;
    }

    public void crash(float damage) {
        if (!this.field_6002.field_9236 && this.method_5805()) {
            for (class_1297 entity : this.method_5685()) {
                float damageMod = Math.min(1.0f, 1.0f - (float)this.getHealth() / (float)this.getMaxHealth());
                entity.method_5643(SimplePlanesMod.DAMAGE_SOURCE_PLANE_CRASH, damage * damageMod);
            }
            this.method_5643(SimplePlanesMod.DAMAGE_SOURCE_PLANE_CRASH, damage + 2.0f);
        }
    }

    public boolean isCreative() {
        return this.method_5642() instanceof class_1657 && ((class_1657)this.method_5642()).method_7337();
    }

    public boolean getOnGround() {
        return this.field_5952 || this.onGroundTicks > 1;
    }

    public boolean isOnWater() {
        return this.field_6002.method_8320(new class_2338(this.method_19538().method_1031(0.0, 0.4, 0.0))).method_26204() == class_2246.field_10382;
    }

    public boolean canAddUpgrade(UpgradeType upgradeType) {
        if (upgradeType.isEngine && this.engineUpgrade != null) {
            return false;
        }
        return !this.upgrades.containsKey(SimplePlanesRegistries.UPGRADE_TYPES.method_10221((Object)upgradeType));
    }

    public void method_5865(class_1297 passenger) {
        this.positionRiderGeneric(passenger);
        int index = this.method_5685().indexOf(passenger);
        if (index == 0) {
            class_1160 pos = this.transformPos(new class_1160(0.0f, (float)(this.method_5621() + passenger.method_5678()), 0.0f));
            passenger.method_5814(this.method_23317() + (double)pos.method_4943(), this.method_23318() + (double)pos.method_4945(), this.method_23321() + (double)pos.method_4947());
        } else if (index == 1) {
            class_1160 pos = this.transformPos(new class_1160(-1.0f, (float)(this.method_5621() + passenger.method_5678()), -1.3f));
            passenger.method_5814(this.method_23317() + (double)pos.method_4943(), this.method_23318() + (double)pos.method_4945(), this.method_23321() + (double)pos.method_4947());
        } else if (index == 2) {
            class_1160 pos = this.transformPos(new class_1160(1.0f, (float)(this.method_5621() + passenger.method_5678()), -1.3f));
            passenger.method_5814(this.method_23317() + (double)pos.method_4943(), this.method_23318() + (double)pos.method_4945(), this.method_23321() + (double)pos.method_4947());
        }
    }

    protected void positionRiderGeneric(class_1297 passenger) {
        boolean local;
        super.method_5865(passenger);
        boolean bl = local = passenger instanceof class_1657 && ((class_1657)passenger).method_7340();
        if (this.method_5626(passenger) && !local) {
            this.applyYawToEntity(passenger);
        }
    }

    public void applyYawToEntity(class_1297 entityToUpdate) {
        entityToUpdate.method_5847(entityToUpdate.method_5791() + this.deltaRotation);
        entityToUpdate.field_5982 += this.deltaRotation;
        entityToUpdate.method_5636(this.method_36454());
        entityToUpdate.method_5847(entityToUpdate.method_36454());
    }

    public class_243 method_24829(class_1309 livingEntity) {
        class_1657 player;
        if (this.upgrades.containsKey(SimplePlanesRegistries.UPGRADE_TYPES.method_10221((Object)SimplePlanesUpgrades.FOLDING)) && livingEntity instanceof class_1657 && !(player = (class_1657)livingEntity).method_7337() && this.method_5685().size() == 0 && this.method_5805()) {
            class_1799 itemStack = this.getItemStack();
            if (!player.method_7270(itemStack)) {
                player.method_7328(itemStack, false);
            }
            this.method_5768();
            return player.method_19538();
        }
        if (this.method_5685().size() == 0) {
            this.setThrottle(0);
            this.setPitchUp((byte)0);
            this.setYawRight((byte)0);
        }
        return super.method_24829(livingEntity);
    }

    public class_1799 getItemStack() {
        class_1799 itemStack = this.getItem().method_7854();
        class_2487 compound = new class_2487();
        this.method_5652(compound);
        compound.method_10569("health", ((Integer)this.field_6011.method_12789(MAX_HEALTH)).intValue());
        compound.method_10556("Used", true);
        itemStack.method_7959("EntityTag", (class_2520)compound);
        return itemStack;
    }

    protected class_1792 getItem() {
        return SimplePlanesItems.PLANE_ITEM;
    }

    private void tickLerp() {
        if (this.method_5787()) {
            this.lerpSteps = 0;
            this.lerpStepsQ = 0;
            this.method_43391(this.method_23317(), this.method_23318(), this.method_23321());
            return;
        }
        if (this.lerpSteps > 0) {
            double d0 = this.method_23317() + (this.lerpX - this.method_23317()) / (double)this.lerpSteps;
            double d1 = this.method_23318() + (this.lerpY - this.method_23318()) / (double)this.lerpSteps;
            double d2 = this.method_23321() + (this.lerpZ - this.method_23321()) / (double)this.lerpSteps;
            --this.lerpSteps;
            this.method_5814(d0, d1, d2);
        }
        if (this.lerpStepsQ > 0) {
            this.setQ_prev(this.getQ_Client());
            this.setQ_Client(MathUtil.lerpQ(1.0f / (float)this.lerpStepsQ, this.getQ_Client(), this.getQ()));
            --this.lerpStepsQ;
        } else if (this.lerpStepsQ == 0) {
            this.setQ_prev(this.getQ_Client());
            this.setQ_Client(this.getQ());
            --this.lerpStepsQ;
        }
    }

    public void method_5759(double x, double y, double z, float yaw, float pitch, int posRotationIncrements, boolean teleport) {
        if (x == this.method_23317() && y == this.method_23318() && z == this.method_23321()) {
            return;
        }
        this.lerpX = x;
        this.lerpY = y;
        this.lerpZ = z;
        this.lerpSteps = 10;
    }

    public void method_5641(double x, double y, double z, float yaw, float pitch) {
        double d0 = class_3532.method_15350((double)x, (double)-3.0E7, (double)3.0E7);
        double d1 = class_3532.method_15350((double)z, (double)-3.0E7, (double)3.0E7);
        this.field_6038 = d0;
        this.field_5971 = y;
        this.field_5989 = d1;
        this.method_5814(d0, y, d1);
        this.method_36456(yaw % 360.0f);
        this.method_36457(pitch % 360.0f);
        this.field_5982 = this.method_36454();
        this.field_6004 = this.method_36455();
    }

    protected void method_5627(class_1297 passenger) {
        super.method_5627(passenger);
        if (this.method_5787() && this.lerpSteps > 0) {
            this.lerpSteps = 0;
            this.method_5641(this.lerpX, this.lerpY, this.lerpZ, this.method_36454(), this.method_36455());
        }
    }

    public class_1657 getPlayer() {
        if (this.method_5642() instanceof class_1657) {
            return (class_1657)this.method_5642();
        }
        return null;
    }

    public void setTimeSinceHit(int timeSinceHit) {
        this.field_6011.method_12778(TIME_SINCE_HIT, (Object)timeSinceHit);
    }

    public int getTimeSinceHit() {
        return (Integer)this.field_6011.method_12789(TIME_SINCE_HIT);
    }

    public void setDamageTaken(float damageTaken) {
        this.field_6011.method_12778(DAMAGE_TAKEN, (Object)Float.valueOf(damageTaken));
    }

    public float getDamageTaken() {
        return ((Float)this.field_6011.method_12789(DAMAGE_TAKEN)).floatValue();
    }

    public double getCameraDistanceMultiplayer() {
        return 1.0;
    }

    public void method_31471(class_2604 clientboundAddEntityPacket) {
        super.method_31471(clientboundAddEntityPacket);
    }

    public void writeUpdateUpgradePacket(class_2960 upgradeID, class_2540 buffer) {
        buffer.method_10804(this.method_5628());
        buffer.method_10812(upgradeID);
        this.upgrades.get(upgradeID).writePacket(buffer);
    }

    public void readUpdateUpgradePacket(class_2960 upgradeID, class_2540 buffer, boolean newUpgrade) {
        if (newUpgrade) {
            UpgradeType upgradeType = (UpgradeType)SimplePlanesRegistries.UPGRADE_TYPES.method_10223(upgradeID);
            Upgrade upgrade = upgradeType.instanceSupplier.apply(this);
            this.upgrades.put(upgradeID, upgrade);
            if (upgradeType.isEngine) {
                this.engineUpgrade = (EngineUpgrade)upgrade;
            }
        }
        this.upgrades.get(upgradeID).readPacket(buffer);
    }

    public void writeSpawnData(class_2540 buffer) {
        Collection<Upgrade> upgrades = this.upgrades.values();
        buffer.method_10804(upgrades.size());
        for (Upgrade upgrade : upgrades) {
            class_2960 upgradeID = SimplePlanesRegistries.UPGRADE_TYPES.method_10221((Object)upgrade.getType());
            buffer.method_10812(upgradeID);
            upgrade.writePacket(buffer);
        }
    }

    public void readSpawnData(class_2540 additionalData) {
        int upgradesSize = additionalData.method_10816();
        for (int i = 0; i < upgradesSize; ++i) {
            class_2960 upgradeID = additionalData.method_10810();
            UpgradeType upgradeType = (UpgradeType)SimplePlanesRegistries.UPGRADE_TYPES.method_10223(upgradeID);
            Upgrade upgrade = upgradeType.instanceSupplier.apply(this);
            this.upgrades.put(upgradeID, upgrade);
            if (upgradeType.isEngine) {
                this.engineUpgrade = (EngineUpgrade)upgrade;
            }
            upgrade.readPacket(additionalData);
        }
    }

    public void removeUpgrade(class_2960 upgradeID) {
        Upgrade upgrade = this.upgrades.remove(upgradeID);
        if (upgrade != null) {
            upgrade.onRemoved();
            upgrade.remove();
            if (!this.field_6002.field_9236) {
                SUpgradeRemovedPacket.send(upgradeID, this.method_5628(), this);
            }
        }
    }

    public void changeThrottle(ChangeThrottlePacket.Type type) {
        int throttle = this.getThrottle();
        if (type == ChangeThrottlePacket.Type.UP) {
            if (throttle < 5 || this.upgrades.containsKey(SimplePlanesRegistries.UPGRADE_TYPES.method_10221((Object)SimplePlanesUpgrades.BOOSTER)) && throttle < 10) {
                this.setThrottle(throttle + 1);
            }
        } else if (throttle > 0) {
            this.setThrottle(throttle - 1);
        }
    }

    public int getThrottle() {
        return (Integer)this.field_6011.method_12789(THROTTLE);
    }

    public void setThrottle(int value) {
        this.field_6011.method_12778(THROTTLE, (Object)value);
    }

    public byte getPitchUp() {
        return (Byte)this.field_6011.method_12789(PITCH_UP);
    }

    public void setPitchUp(byte pitchUp) {
        this.field_6011.method_12778(PITCH_UP, (Object)pitchUp);
    }

    public byte getYawRight() {
        return (Byte)this.field_6011.method_12789(YAW_RIGHT);
    }

    public void setYawRight(byte yawRight) {
        this.field_6011.method_12778(YAW_RIGHT, (Object)yawRight);
    }

    protected static class TempMotionVars {
        public float moveForward;
        public double turnThreshold;
        public float moveStrafing;
        double maxSpeed;
        double maxPushSpeed;
        double takeOffSpeed;
        float maxLift;
        double liftFactor;
        double gravity;
        double drag;
        double dragMul;
        double dragQuad;
        float push;
        float groundPush;
        float passiveEnginePush;
        float motionToRotation;
        float pitchToMotion;
        float yawMultiplayer;

        public TempMotionVars() {
            this.reset();
        }

        public void reset() {
            this.moveForward = 0.0f;
            this.turnThreshold = 0.0;
            this.moveStrafing = 0.0f;
            this.maxSpeed = 3.0;
            this.takeOffSpeed = 0.3;
            this.maxLift = 2.0f;
            this.liftFactor = 10.0;
            this.gravity = -0.03;
            this.drag = 0.001;
            this.dragMul = 5.0E-4;
            this.dragQuad = 0.001;
            this.push = 0.0f;
            this.groundPush = 0.01f;
            this.passiveEnginePush = 0.025f;
            this.motionToRotation = 0.05f;
            this.pitchToMotion = 0.2f;
            this.yawMultiplayer = 0.5f;
        }
    }
}

