/*
 * Decompiled with CFR 0.152.
 */
package xyz.przemyk.simpleplanes.misc;

import net.minecraft.class_1158;
import net.minecraft.class_243;
import net.minecraft.class_3532;

public class MathUtil {
    public static double getHorizontalDistanceSqr(class_243 vec3) {
        return Math.sqrt(vec3.field_1352 * vec3.field_1352 + vec3.field_1350 * vec3.field_1350);
    }

    public static double normalizedDotProduct(class_243 v1, class_243 v2) {
        return v1.method_1026(v2) / (v1.method_1033() * v2.method_1033());
    }

    public static float getPitch(class_243 motion) {
        double y = motion.field_1351;
        return (float)Math.toDegrees(Math.atan2(y, Math.sqrt(motion.field_1352 * motion.field_1352 + motion.field_1350 * motion.field_1350)));
    }

    public static float getYaw(class_243 motion) {
        return (float)Math.toDegrees(Math.atan2(-motion.field_1352, motion.field_1350));
    }

    public static float lerpAngle(float perc, float start, float end) {
        return start + perc * class_3532.method_15393((float)(end - start));
    }

    public static float lerpAngle180(float perc, float start, float end) {
        if (MathUtil.degreesDifferenceAbs(start, end) > 90.0) {
            end += 180.0f;
        }
        return start + perc * class_3532.method_15393((float)(end - start));
    }

    public static double lerpAngle180(double perc, double start, double end) {
        if (MathUtil.degreesDifferenceAbs(start, end) > 90.0) {
            end += 180.0;
        }
        return start + perc * class_3532.method_15338((double)(end - start));
    }

    public static double lerpAngle(double perc, double start, double end) {
        return start + perc * class_3532.method_15338((double)(end - start));
    }

    public static double degreesDifferenceAbs(double p_203301_0_, double p_203301_1_) {
        return Math.abs(MathUtil.wrapSubtractDegrees(p_203301_0_, p_203301_1_));
    }

    public static double wrapSubtractDegrees(double p_203302_0_, double p_203302_1_) {
        return class_3532.method_15338((double)(p_203302_1_ - p_203302_0_));
    }

    public static class_243 rotationToVector(double yaw, double pitch) {
        yaw = Math.toRadians(yaw);
        pitch = Math.toRadians(pitch);
        double xzLen = Math.cos(pitch);
        double x = -xzLen * Math.sin(yaw);
        double y = Math.sin(pitch);
        double z = xzLen * Math.cos(-yaw);
        return new class_243(x, y, z);
    }

    public static class_243 rotationToVector(double yaw, double pitch, double size) {
        class_243 vec = MathUtil.rotationToVector(yaw, pitch);
        return vec.method_1021(size / vec.method_1033());
    }

    public static EulerAngles toEulerAngles(class_1158 q) {
        EulerAngles angles = new EulerAngles();
        double sinr_cosp = 2.0f * (q.method_4924() * q.method_4923() + q.method_4921() * q.method_4922());
        double cosr_cosp = 1.0f - 2.0f * (q.method_4923() * q.method_4923() + q.method_4921() * q.method_4921());
        angles.roll = Math.toDegrees(Math.atan2(sinr_cosp, cosr_cosp));
        double sinp = 2.0f * (q.method_4924() * q.method_4921() - q.method_4922() * q.method_4923());
        angles.pitch = Math.abs(sinp) >= 0.999 ? -Math.toDegrees(Math.signum(sinp) * Math.PI / 2.0) : -Math.toDegrees(Math.asin(sinp));
        double siny_cosp = 2.0f * (q.method_4924() * q.method_4922() + q.method_4923() * q.method_4921());
        double cosy_cosp = 1.0f - 2.0f * (q.method_4921() * q.method_4921() + q.method_4922() * q.method_4922());
        angles.yaw = Math.toDegrees(Math.atan2(siny_cosp, cosy_cosp));
        return angles;
    }

    public static float fastInvSqrt(float number) {
        float f = 0.5f * number;
        int i = Float.floatToIntBits(number);
        i = 1597463007 - (i >> 1);
        number = Float.intBitsToFloat(i);
        return number * (1.5f - f * number * number);
    }

    public static class_1158 normalizeQuaternion(class_1158 q) {
        float f = q.method_4921() * q.method_4921() + q.method_4922() * q.method_4922() + q.method_4923() * q.method_4923() + q.method_4924() * q.method_4924();
        float x = q.method_4921();
        float y = q.method_4922();
        float z = q.method_4923();
        float w = q.method_4924();
        if (f > 1.0E-6f) {
            float f1 = MathUtil.fastInvSqrt(f);
            return new class_1158(x *= f1, y *= f1, z *= f1, w *= f1);
        }
        return new class_1158(0.0f, 0.0f, 0.0f, 0.0f);
    }

    public static class_1158 toQuaternion(double yaw, double pitch, double roll) {
        yaw = Math.toRadians(yaw);
        pitch = -Math.toRadians(pitch);
        roll = Math.toRadians(roll);
        double cy = Math.cos(yaw * 0.5);
        double sy = Math.sin(yaw * 0.5);
        double cp = Math.cos(pitch * 0.5);
        double sp = Math.sin(pitch * 0.5);
        double cr = Math.cos(roll * 0.5);
        double sr = Math.sin(roll * 0.5);
        float w = (float)(cr * cp * cy + sr * sp * sy);
        float z = (float)(sr * cp * cy - cr * sp * sy);
        float x = (float)(cr * sp * cy + sr * cp * sy);
        float y = (float)(cr * cp * sy - sr * sp * cy);
        return new class_1158(x, y, z, w);
    }

    public static class_1158 lerpQ(float perc, class_1158 start, class_1158 end) {
        double DOT_THRESHOLD;
        start = MathUtil.normalizeQuaternion(start);
        end = MathUtil.normalizeQuaternion(end);
        double dot = start.method_4921() * end.method_4921() + start.method_4922() * end.method_4922() + start.method_4923() * end.method_4923() + start.method_4924() * end.method_4924();
        if (dot < 0.0) {
            end = new class_1158(-end.method_4921(), -end.method_4922(), -end.method_4923(), -end.method_4924());
            dot = -dot;
        }
        if (dot > (DOT_THRESHOLD = 0.9995)) {
            class_1158 quaternion = new class_1158(start.method_4921() * (1.0f - perc) + end.method_4921() * perc, start.method_4922() * (1.0f - perc) + end.method_4922() * perc, start.method_4923() * (1.0f - perc) + end.method_4923() * perc, start.method_4924() * (1.0f - perc) + end.method_4924() * perc);
            return MathUtil.normalizeQuaternion(quaternion);
        }
        double theta_0 = Math.acos(dot);
        double theta = theta_0 * (double)perc;
        double sin_theta = Math.sin(theta);
        double sin_theta_0 = Math.sin(theta_0);
        float s0 = (float)(Math.cos(theta) - dot * sin_theta / sin_theta_0);
        float s1 = (float)(sin_theta / sin_theta_0);
        class_1158 quaternion = new class_1158(start.method_4921() * s0 + end.method_4921() * s1, start.method_4922() * s0 + end.method_4922() * s1, start.method_4923() * s0 + end.method_4923() * s1, start.method_4924() * s0 + end.method_4924() * s1);
        return MathUtil.normalizeQuaternion(quaternion);
    }

    public static class EulerAngles {
        public double pitch;
        public double yaw;
        public double roll;

        public EulerAngles() {
        }

        public EulerAngles(EulerAngles a) {
            this.pitch = a.pitch;
            this.yaw = a.yaw;
            this.roll = a.roll;
        }

        public EulerAngles copy() {
            return new EulerAngles(this);
        }

        public String toString() {
            return "EulerAngles{pitch=" + this.pitch + ", yaw=" + this.yaw + ", roll=" + this.roll + "}";
        }
    }
}

