/*
 * Decompiled with CFR 0.152.
 */
package xyz.przemyk.simpleplanes.setup;

import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import net.minecraft.class_1792;
import net.minecraft.class_2378;
import net.minecraft.class_2960;
import xyz.przemyk.simpleplanes.setup.SimplePlanesRegistries;
import xyz.przemyk.simpleplanes.upgrades.UpgradeType;
import xyz.przemyk.simpleplanes.upgrades.armor.ArmorUpgrade;
import xyz.przemyk.simpleplanes.upgrades.banner.BannerUpgrade;
import xyz.przemyk.simpleplanes.upgrades.booster.BoosterUpgrade;
import xyz.przemyk.simpleplanes.upgrades.engines.furnace.FurnaceEngineUpgrade;
import xyz.przemyk.simpleplanes.upgrades.floating.FloatingUpgrade;
import xyz.przemyk.simpleplanes.upgrades.folding.FoldingUpgrade;
import xyz.przemyk.simpleplanes.upgrades.heal.HealingUpgrade;
import xyz.przemyk.simpleplanes.upgrades.jukebox.JukeboxUpgrade;
import xyz.przemyk.simpleplanes.upgrades.payload.PayloadUpgrade;
import xyz.przemyk.simpleplanes.upgrades.seats.SeatsUpgrade;
import xyz.przemyk.simpleplanes.upgrades.shooter.ShooterUpgrade;
import xyz.przemyk.simpleplanes.upgrades.storage.ChestUpgrade;
import xyz.przemyk.simpleplanes.upgrades.supplycrate.SupplyCrateUpgrade;

public class SimplePlanesUpgrades {
    private static final Map<class_1792, UpgradeType> ITEM_UPGRADE_MAP = new HashMap<class_1792, UpgradeType>();
    private static final Map<class_1792, UpgradeType> LARGE_ITEM_UPGRADE_MAP = new HashMap<class_1792, UpgradeType>();
    public static final UpgradeType FLOATY_BEDDING = SimplePlanesUpgrades.register("floaty_bedding", new UpgradeType(FloatingUpgrade::new));
    public static final UpgradeType BOOSTER = SimplePlanesUpgrades.register("booster", new UpgradeType(BoosterUpgrade::new));
    public static final UpgradeType SHOOTER = SimplePlanesUpgrades.register("shooter", new UpgradeType(ShooterUpgrade::new));
    public static final UpgradeType HEALING = SimplePlanesUpgrades.register("healing", new UpgradeType(HealingUpgrade::new));
    public static final UpgradeType ARMOR = SimplePlanesUpgrades.register("armor", new UpgradeType(ArmorUpgrade::new));
    public static final UpgradeType FOLDING = SimplePlanesUpgrades.register("folding", new UpgradeType(FoldingUpgrade::new));
    public static final UpgradeType SEATS = SimplePlanesUpgrades.register("seats", new UpgradeType(SeatsUpgrade::new));
    public static final UpgradeType FURNACE_ENGINE = SimplePlanesUpgrades.register("furnace_engine", new UpgradeType(FurnaceEngineUpgrade::new, true));
    public static final UpgradeType BANNER = SimplePlanesUpgrades.register("banner", new UpgradeType(BannerUpgrade::new));
    public static final UpgradeType PAYLOAD = SimplePlanesUpgrades.register("payload", new UpgradeType(PayloadUpgrade::new));
    public static final UpgradeType CHEST = SimplePlanesUpgrades.register("chest", new UpgradeType(ChestUpgrade::new));
    public static final UpgradeType SUPPLY_CRATE = SimplePlanesUpgrades.register("supply_crate", new UpgradeType(SupplyCrateUpgrade::new));
    public static final UpgradeType JUKEBOX = SimplePlanesUpgrades.register("jukebox", new UpgradeType(JukeboxUpgrade::new));

    public static void init() {
    }

    public static void registerUpgradeItem(class_1792 item, UpgradeType upgradeType) {
        ITEM_UPGRADE_MAP.put(item, upgradeType);
    }

    public static void registerLargeUpgradeItem(class_1792 item, UpgradeType upgradeType) {
        LARGE_ITEM_UPGRADE_MAP.put(item, upgradeType);
    }

    public static Optional<UpgradeType> getUpgradeFromItem(class_1792 item) {
        if (ITEM_UPGRADE_MAP.containsKey(item)) {
            return Optional.of(ITEM_UPGRADE_MAP.get(item));
        }
        return Optional.empty();
    }

    public static Optional<UpgradeType> getLargeUpgradeFromItem(class_1792 item) {
        if (LARGE_ITEM_UPGRADE_MAP.containsKey(item)) {
            return Optional.of(LARGE_ITEM_UPGRADE_MAP.get(item));
        }
        return Optional.empty();
    }

    private static UpgradeType register(String id, UpgradeType upgradeType) {
        return (UpgradeType)class_2378.method_10230(SimplePlanesRegistries.UPGRADE_TYPES, (class_2960)new class_2960("simpleplanes", id), (Object)upgradeType);
    }
}

