/*
 * Decompiled with CFR 0.152.
 */
package xyz.przemyk.simpleplanes.upgrades.engines.furnace;

import java.util.function.Function;
import net.fabricmc.fabric.api.registry.FuelRegistry;
import net.minecraft.class_1263;
import net.minecraft.class_1277;
import net.minecraft.class_1306;
import net.minecraft.class_1735;
import net.minecraft.class_1799;
import net.minecraft.class_1935;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_2540;
import net.minecraft.class_310;
import net.minecraft.class_3915;
import net.minecraft.class_4587;
import xyz.przemyk.simpleplanes.client.ClientUtil;
import xyz.przemyk.simpleplanes.client.gui.PlaneInventoryScreen;
import xyz.przemyk.simpleplanes.container.FuelSlot;
import xyz.przemyk.simpleplanes.entities.PlaneEntity;
import xyz.przemyk.simpleplanes.setup.SimplePlanesItems;
import xyz.przemyk.simpleplanes.setup.SimplePlanesUpgrades;
import xyz.przemyk.simpleplanes.upgrades.engines.EngineUpgrade;

public class FurnaceEngineUpgrade
extends EngineUpgrade {
    public final class_1277 itemStackHandler = new class_1277(1);
    public int burnTime;
    public int burnTimeTotal;

    public FurnaceEngineUpgrade(PlaneEntity planeEntity) {
        super(SimplePlanesUpgrades.FURNACE_ENGINE, planeEntity);
    }

    @Override
    public void tick() {
        class_1799 itemStack;
        Integer itemBurnTime;
        if (this.burnTime > 0) {
            this.burnTime -= this.planeEntity.getFuelCost();
            this.updateClient();
        } else if (this.planeEntity.getThrottle() > 0 && (itemBurnTime = (Integer)FuelRegistry.INSTANCE.get((class_1935)(itemStack = this.itemStackHandler.method_5438(0)).method_7909())) != null && itemBurnTime > 0) {
            this.burnTimeTotal = itemBurnTime;
            this.burnTime = itemBurnTime;
            if (itemStack.method_7909().method_7857()) {
                this.itemStackHandler.method_5447(0, itemStack.method_7909().method_7858().method_7854());
            } else {
                itemStack.method_7971(1);
            }
            this.updateClient();
        }
    }

    @Override
    public boolean isPowered() {
        return this.burnTime > 0;
    }

    @Override
    public class_2487 serializeNBT() {
        class_2487 compound = new class_2487();
        compound.method_10566("item", (class_2520)this.itemStackHandler.method_5438(0).method_7953(new class_2487()));
        compound.method_10569("burnTime", this.burnTime);
        compound.method_10569("burnTimeTotal", this.burnTimeTotal);
        return compound;
    }

    @Override
    public void deserializeNBT(class_2487 compound) {
        this.itemStackHandler.method_5447(0, class_1799.method_7915((class_2487)compound.method_10562("item")));
        this.burnTime = compound.method_10550("burnTime");
        this.burnTimeTotal = compound.method_10550("burnTimeTotal");
    }

    @Override
    public void writePacket(class_2540 buffer) {
        buffer.method_10793(this.itemStackHandler.method_5438(0));
        buffer.method_10804(this.burnTime);
        buffer.method_10804(this.burnTimeTotal);
    }

    @Override
    public void readPacket(class_2540 buffer) {
        this.itemStackHandler.method_5447(0, buffer.method_10819());
        this.burnTime = buffer.method_10816();
        this.burnTimeTotal = buffer.method_10816();
    }

    @Override
    public void onRemoved() {
        this.planeEntity.method_5706((class_1935)SimplePlanesItems.FURNACE_ENGINE);
        this.planeEntity.method_5775(this.itemStackHandler.method_5438(0));
    }

    @Override
    public void renderPowerHUD(class_4587 matrixStack, class_1306 side, int scaledWidth, int scaledHeight, float partialTicks) {
        class_1799 itemStack;
        int i = scaledWidth / 2;
        class_310 mc = class_310.method_1551();
        if (side == class_1306.field_6182) {
            ClientUtil.blit(matrixStack, -90, i - 91 - 29, scaledHeight - 40, 0, 44, 22, 40);
        } else {
            ClientUtil.blit(matrixStack, -90, i + 91, scaledHeight - 40, 0, 44, 22, 40);
        }
        if (this.burnTime > 0) {
            int burnTimeTotal2 = this.burnTimeTotal == 0 ? 200 : this.burnTimeTotal;
            int burnLeftScaled = this.burnTime * 13 / burnTimeTotal2;
            if (side == class_1306.field_6182) {
                ClientUtil.blit(matrixStack, -90, i - 91 - 29 + 4, scaledHeight - 40 + 16 - burnLeftScaled, 22, 56 - burnLeftScaled, 14, burnLeftScaled + 1);
            } else {
                ClientUtil.blit(matrixStack, -90, i + 91 + 4, scaledHeight - 40 + 16 - burnLeftScaled, 22, 56 - burnLeftScaled, 14, burnLeftScaled + 1);
            }
        }
        if (!(itemStack = this.itemStackHandler.method_5438(0)).method_7960()) {
            int i2 = scaledHeight - 16 - 3;
            if (side == class_1306.field_6182) {
                ClientUtil.renderHotbarItem(matrixStack, i - 91 - 26, i2, partialTicks, itemStack, mc);
            } else {
                ClientUtil.renderHotbarItem(matrixStack, i + 91 + 3, i2, partialTicks, itemStack, mc);
            }
        }
    }

    @Override
    public void addContainerData(Function<class_1735, class_1735> addSlot, Function<class_3915, class_3915> addDataSlot) {
        addSlot.apply(new FuelSlot((class_1263)this.itemStackHandler, 0, 152, 62));
    }

    @Override
    public void renderScreenBg(class_4587 poseStack, int x, int y, float partialTicks, PlaneInventoryScreen screen) {
        screen.method_25302(poseStack, screen.getGuiLeft() + 151, screen.getGuiTop() + 44, 208, 0, 18, 35);
        if (this.burnTime > 0) {
            int burnLeftScaled = this.burnTime * 13 / (this.burnTimeTotal == 0 ? 200 : this.burnTimeTotal);
            screen.method_25302(poseStack, screen.getGuiLeft() + 152, screen.getGuiTop() + 57 - burnLeftScaled, 208, 47 - burnLeftScaled, 14, burnLeftScaled + 1);
        }
    }
}

