/*
 * Decompiled with CFR 0.152.
 */
package xyz.przemyk.simpleplanes.entities;

import java.util.List;
import java.util.Optional;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntitySelector;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.npc.Villager;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import org.joml.Vector3f;
import xyz.przemyk.simpleplanes.datapack.PayloadEntry;
import xyz.przemyk.simpleplanes.datapack.PlanePayloadReloadListener;
import xyz.przemyk.simpleplanes.entities.PlaneEntity;
import xyz.przemyk.simpleplanes.setup.SimplePlanesConfig;
import xyz.przemyk.simpleplanes.setup.SimplePlanesItems;
import xyz.przemyk.simpleplanes.setup.SimplePlanesUpgrades;
import xyz.przemyk.simpleplanes.upgrades.LargeUpgrade;
import xyz.przemyk.simpleplanes.upgrades.Upgrade;
import xyz.przemyk.simpleplanes.upgrades.UpgradeType;
import xyz.przemyk.simpleplanes.upgrades.payload.PayloadUpgrade;

public class LargePlaneEntity
extends PlaneEntity {
    public boolean hasLargeUpgrade = false;

    public LargePlaneEntity(EntityType<? extends LargePlaneEntity> entityTypeIn, Level worldIn) {
        super(entityTypeIn, worldIn);
    }

    @Override
    public void m_8119_() {
        super.m_8119_();
        List list = this.m_9236_().m_6249_((Entity)this, this.m_20191_().m_82377_((double)0.2f, (double)-0.01f, (double)0.2f), EntitySelector.m_20421_((Entity)this));
        for (Entity entity : list) {
            if (this.m_9236_().f_46443_ || this.m_6688_() instanceof Player || entity.m_20363_((Entity)this) || entity.m_20159_() || !(entity instanceof LivingEntity) || entity instanceof Player) continue;
            entity.m_20329_((Entity)this);
        }
    }

    @Override
    public boolean tryToAddUpgrade(Player playerEntity, ItemStack itemStack) {
        if (super.tryToAddUpgrade(playerEntity, itemStack)) {
            return true;
        }
        if (!this.hasLargeUpgrade && this.m_20197_().size() < 2) {
            Optional<UpgradeType> upgradeTypeOptional = SimplePlanesUpgrades.getLargeUpgradeFromItem(itemStack.m_41720_());
            if (upgradeTypeOptional.map(upgradeType -> {
                if (this.canAddUpgrade((UpgradeType)upgradeType)) {
                    Upgrade upgrade = upgradeType.instanceSupplier.apply(this);
                    this.addUpgrade(playerEntity, itemStack, upgrade);
                    return true;
                }
                return false;
            }).orElse(false).booleanValue()) {
                return true;
            }
            PayloadEntry payloadEntry = PlanePayloadReloadListener.payloadEntries.get(itemStack.m_41720_());
            if (payloadEntry != null) {
                this.addUpgrade(playerEntity, itemStack, new PayloadUpgrade(this, payloadEntry));
                return true;
            }
        }
        return false;
    }

    @Override
    protected float getGroundPitch() {
        return 0.0f;
    }

    @Override
    public int getFuelCost() {
        return (Integer)SimplePlanesConfig.LARGE_PLANE_FUEL_COST.get();
    }

    @Override
    protected boolean m_7310_(Entity passenger) {
        List passengers = this.m_20197_();
        if (passenger.m_20202_() == this || passenger instanceof PlaneEntity) {
            return false;
        }
        if (!this.upgrades.containsKey(SimplePlanesUpgrades.SEATS.getId())) {
            return passengers.size() <= 1 && (passengers.size() == 0 || !this.hasLargeUpgrade);
        }
        return this.hasLargeUpgrade ? passengers.size() < 3 : passengers.size() < 4;
    }

    @Override
    public void m_19956_(Entity passenger, Entity.MoveFunction moveFunction) {
        this.positionRiderGeneric(passenger);
        int index = this.m_20197_().indexOf(passenger);
        if (index == 0) {
            Vector3f pos = this.transformPos(new Vector3f(0.0f, (float)(this.m_6048_() + passenger.m_6049_()), 1.0f));
            moveFunction.m_20372_(passenger, this.m_20185_() + (double)pos.x(), this.m_20186_() + (double)pos.y(), this.m_20189_() + (double)pos.z());
        } else {
            if (this.hasLargeUpgrade) {
                ++index;
            }
            switch (index) {
                case 1: {
                    Vector3f pos = this.transformPos(new Vector3f(0.0f, (float)(this.m_6048_() + this.getEntityYOffset(passenger)), 0.0f));
                    moveFunction.m_20372_(passenger, this.m_20185_() + (double)pos.x(), this.m_20186_() + (double)pos.y(), this.m_20189_() + (double)pos.z());
                    break;
                }
                case 2: {
                    Vector3f pos = this.transformPos(new Vector3f(0.0f, (float)(this.m_6048_() + this.getEntityYOffset(passenger)), -1.0f));
                    moveFunction.m_20372_(passenger, this.m_20185_() + (double)pos.x(), this.m_20186_() + (double)pos.y(), this.m_20189_() + (double)pos.z());
                    break;
                }
                case 3: {
                    Vector3f pos = this.transformPos(new Vector3f(0.0f, (float)(this.m_6048_() + this.getEntityYOffset(passenger)), -1.8f));
                    moveFunction.m_20372_(passenger, this.m_20185_() + (double)pos.x(), this.m_20186_() + (double)pos.y(), this.m_20189_() + (double)pos.z());
                }
            }
        }
    }

    public double getEntityYOffset(Entity passenger) {
        if (passenger instanceof Villager) {
            return ((Villager)passenger).m_6162_() ? -0.1 : -0.3;
        }
        return passenger.m_6049_();
    }

    @Override
    public double getCameraDistanceMultiplayer() {
        return (Double)SimplePlanesConfig.LARGE_PLANE_CAMERA_DISTANCE_MULTIPLIER.get();
    }

    @Override
    protected Item getItem() {
        return (Item)SimplePlanesItems.LARGE_PLANE_ITEM.get();
    }

    public boolean hasStorageUpgrade() {
        if (this.hasLargeUpgrade) {
            for (Upgrade upgrade : this.upgrades.values()) {
                if (!(upgrade instanceof LargeUpgrade)) continue;
                LargeUpgrade largeUpgrade = (LargeUpgrade)upgrade;
                return largeUpgrade.hasStorage();
            }
        }
        return false;
    }

    @Override
    protected float getRotationSpeedMultiplier() {
        return 0.5f;
    }
}

