/*
 * Decompiled with CFR 0.152.
 */
package xyz.przemyk.simpleplanes.entities;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BarrelBlockEntity;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.items.ItemStackHandler;
import net.minecraftforge.network.NetworkHooks;
import xyz.przemyk.simpleplanes.setup.SimplePlanesEntities;
import xyz.przemyk.simpleplanes.setup.SimplePlanesItems;

public class ParachuteEntity
extends Entity {
    public static final EntityDataAccessor<Boolean> HAS_STORAGE_CRATE = SynchedEntityData.m_135353_(ParachuteEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    public static final double MOTION_DECAY = 0.9;
    private ItemStackHandler itemStackHandler;

    public ParachuteEntity(Level level) {
        super((EntityType)SimplePlanesEntities.PARACHUTE.get(), level);
    }

    public ParachuteEntity(EntityType<?> entityType, Level level) {
        super(entityType, level);
    }

    public ParachuteEntity(Level level, ItemStackHandler itemStackHandler) {
        super((EntityType)SimplePlanesEntities.PARACHUTE.get(), level);
        this.f_19804_.m_135381_(HAS_STORAGE_CRATE, (Object)true);
        this.itemStackHandler = itemStackHandler;
    }

    public boolean hasStorageCrate() {
        return (Boolean)this.f_19804_.m_135370_(HAS_STORAGE_CRATE);
    }

    public LivingEntity m_6688_() {
        Entity entity = this.m_146895_();
        if (entity instanceof LivingEntity) {
            LivingEntity entity2 = (LivingEntity)entity;
            return entity2;
        }
        return null;
    }

    public void m_8119_() {
        LivingEntity passenger = this.m_6688_();
        if (passenger == null && !this.hasStorageCrate() || !this.m_9236_().m_8055_(new BlockPos((int)this.m_20185_(), (int)this.m_20186_() - 1, (int)this.m_20189_())).m_247087_()) {
            this.m_6074_();
            this.m_19998_((ItemLike)SimplePlanesItems.PARACHUTE_ITEM.get());
            if (this.hasStorageCrate() && !this.m_9236_().f_46443_) {
                int i;
                BlockPos.MutableBlockPos mutableBlockPos = new BlockPos.MutableBlockPos(this.m_146903_(), this.m_146904_(), this.m_146907_());
                for (i = 0; i < 50; ++i) {
                    BlockState blockState = this.m_9236_().m_8055_((BlockPos)mutableBlockPos);
                    if (blockState.m_247087_()) {
                        this.m_9236_().m_7731_((BlockPos)mutableBlockPos, Blocks.f_50618_.m_49966_(), 3);
                        BlockEntity blockEntity = this.m_9236_().m_7702_((BlockPos)mutableBlockPos);
                        if (blockEntity instanceof BarrelBlockEntity) {
                            BarrelBlockEntity barrelBlockEntity = (BarrelBlockEntity)blockEntity;
                            for (int s = 0; s < 27; ++s) {
                                ItemStack itemStack = this.itemStackHandler.getStackInSlot(s);
                                if (itemStack.m_41619_()) continue;
                                barrelBlockEntity.m_6836_(s, itemStack);
                            }
                        }
                        return;
                    }
                    mutableBlockPos.m_122173_(Direction.UP);
                }
                for (i = 0; i < this.itemStackHandler.getSlots(); ++i) {
                    ItemStack itemStack = this.itemStackHandler.getStackInSlot(i);
                    if (itemStack.m_41619_()) continue;
                    this.m_19983_(itemStack);
                }
            }
        } else {
            super.m_8119_();
            this.f_19789_ = 0.0f;
            float moveStrafing = 0.0f;
            float moveForward = 0.0f;
            if (passenger instanceof LivingEntity) {
                LivingEntity livingEntity = passenger;
                float angle = (float)((double)livingEntity.m_146908_() * Math.PI / 180.0);
                float sin = Mth.m_14031_((float)angle);
                float cos = Mth.m_14089_((float)angle);
                moveStrafing = (cos * livingEntity.f_20900_ - sin * livingEntity.f_20902_) / 50.0f;
                moveForward = (sin * livingEntity.f_20900_ + cos * livingEntity.f_20902_) / 50.0f;
            }
            Vec3 motion = this.m_20184_();
            this.m_20334_(motion.f_82479_ * 0.9 + (double)moveStrafing, Math.max(-0.1, motion.f_82480_ - 0.005), motion.f_82481_ * 0.9 + (double)moveForward);
            this.m_6478_(MoverType.SELF, this.m_20184_());
        }
    }

    protected void m_8097_() {
        this.f_19804_.m_135372_(HAS_STORAGE_CRATE, (Object)false);
    }

    protected void m_7378_(CompoundTag compoundTag) {
        this.f_19804_.m_135381_(HAS_STORAGE_CRATE, (Object)compoundTag.m_128471_("has_storage_crate"));
        if (this.hasStorageCrate()) {
            this.itemStackHandler = new ItemStackHandler();
            this.itemStackHandler.deserializeNBT(compoundTag.m_128469_("items"));
        }
    }

    protected void m_7380_(CompoundTag compoundTag) {
        compoundTag.m_128379_("has_storage_crate", this.hasStorageCrate());
        if (this.hasStorageCrate()) {
            compoundTag.m_128365_("items", (Tag)this.itemStackHandler.serializeNBT());
        }
    }

    public Packet<ClientGamePacketListener> m_5654_() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }
}

