/*
 * Decompiled with CFR 0.152.
 */
package xyz.przemyk.simpleplanes.items;

import java.util.List;
import java.util.function.Predicate;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.stats.Stats;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntitySelector;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.registries.ForgeRegistries;
import xyz.przemyk.simpleplanes.entities.PlaneEntity;

public class PlaneItem
extends Item {
    private static final Predicate<Entity> ENTITY_PREDICATE = EntitySelector.f_20408_.and(Entity::m_6087_);
    private final Supplier<? extends EntityType<? extends PlaneEntity>> planeEntityType;

    public PlaneItem(Item.Properties properties, Supplier<? extends EntityType<? extends PlaneEntity>> planeEntityType) {
        super(properties.m_41487_(1));
        this.planeEntityType = planeEntityType;
    }

    public void m_7373_(ItemStack stack, @Nullable Level worldIn, List<Component> tooltip, TooltipFlag flagIn) {
        super.m_7373_(stack, worldIn, tooltip, flagIn);
        CompoundTag entityTag = stack.m_41737_("EntityTag");
        if (entityTag != null) {
            Block block;
            if (entityTag.m_128441_("material") && (block = (Block)ForgeRegistries.BLOCKS.getValue(new ResourceLocation(entityTag.m_128461_("material")))) != null) {
                tooltip.add((Component)Component.m_237115_((String)"simpleplanes.material").m_7220_((Component)block.m_49954_()));
            }
            if (entityTag.m_128441_("upgrades")) {
                CompoundTag upgradesNBT = entityTag.m_128469_("upgrades");
                for (String key : upgradesNBT.m_128431_()) {
                    CompoundTag upgradeNbt = upgradesNBT.m_128469_(key);
                    ResourceLocation resourceLocation = new ResourceLocation(key);
                    if (upgradeNbt.m_128441_("desc")) {
                        tooltip.add((Component)Component.m_237113_((String)upgradeNbt.m_128461_("desc")));
                        continue;
                    }
                    tooltip.add((Component)Component.m_237115_((String)("name." + resourceLocation.toString().replace(":", "."))));
                }
            }
        }
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level worldIn, Player playerIn, InteractionHand handIn) {
        ItemStack itemstack = playerIn.m_21120_(handIn);
        BlockHitResult hitResult = PlaneItem.m_41435_((Level)worldIn, (Player)playerIn, (ClipContext.Fluid)ClipContext.Fluid.ANY);
        if (hitResult.m_6662_() == HitResult.Type.MISS) {
            return InteractionResultHolder.m_19098_((Object)itemstack);
        }
        Vec3 vec3d = playerIn.m_20252_(1.0f);
        List list = worldIn.m_6249_((Entity)playerIn, playerIn.m_20191_().m_82369_(vec3d.m_82490_(5.0)).m_82400_(1.0), ENTITY_PREDICATE);
        if (!list.isEmpty()) {
            Vec3 vec3d1 = playerIn.m_20299_(1.0f);
            for (Entity entity : list) {
                AABB aabb = entity.m_20191_().m_82400_((double)entity.m_6143_());
                if (!aabb.m_82390_(vec3d1)) continue;
                return InteractionResultHolder.m_19098_((Object)itemstack);
            }
        }
        if (hitResult.m_6662_() == HitResult.Type.BLOCK) {
            PlaneEntity planeEntity = (PlaneEntity)this.planeEntityType.get().m_20615_(worldIn);
            planeEntity.m_6034_(hitResult.m_82450_().m_7096_(), hitResult.m_82450_().m_7098_(), hitResult.m_82450_().m_7094_());
            planeEntity.m_146922_(playerIn.m_146908_());
            planeEntity.f_19859_ = playerIn.f_19859_;
            planeEntity.m_6593_(itemstack.m_41786_());
            CompoundTag entityTag = itemstack.m_41737_("EntityTag");
            if (entityTag != null) {
                planeEntity.m_7378_(entityTag);
            }
            if (!worldIn.m_45756_((Entity)planeEntity, planeEntity.m_20191_().m_82400_(-0.1))) {
                return InteractionResultHolder.m_19100_((Object)itemstack);
            }
            if (!worldIn.f_46443_) {
                worldIn.m_7967_((Entity)planeEntity);
                if (!playerIn.m_150110_().f_35937_) {
                    itemstack.m_41774_(1);
                }
            }
            playerIn.m_36246_(Stats.f_12982_.m_12902_((Object)this));
            return InteractionResultHolder.m_19090_((Object)itemstack);
        }
        return InteractionResultHolder.m_19098_((Object)itemstack);
    }
}

