/*
 * Decompiled with CFR 0.152.
 */
package xyz.przemyk.simpleplanes.upgrades.payload;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.client.model.data.ModelData;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.registries.ForgeRegistries;
import xyz.przemyk.simpleplanes.datapack.PayloadEntry;
import xyz.przemyk.simpleplanes.entities.PlaneEntity;
import xyz.przemyk.simpleplanes.setup.SimplePlanesEntities;
import xyz.przemyk.simpleplanes.setup.SimplePlanesUpgrades;
import xyz.przemyk.simpleplanes.upgrades.LargeUpgrade;
import xyz.przemyk.simpleplanes.upgrades.UpgradeType;

public class PayloadUpgrade
extends LargeUpgrade {
    private PayloadEntry payloadEntry;

    public PayloadUpgrade(PlaneEntity planeEntity, PayloadEntry payloadEntry) {
        super((UpgradeType)SimplePlanesUpgrades.PAYLOAD.get(), planeEntity);
        this.payloadEntry = payloadEntry;
    }

    public PayloadUpgrade(PlaneEntity planeEntity) {
        super((UpgradeType)SimplePlanesUpgrades.PAYLOAD.get(), planeEntity);
    }

    @Override
    public void onItemRightClick(PlayerInteractEvent.RightClickItem event) {
        ItemStack itemStack = event.getEntity().m_21120_(event.getHand());
        if (itemStack.m_41720_() == Items.f_42409_) {
            itemStack.m_41622_(1, (LivingEntity)event.getEntity(), playerEntity -> playerEntity.m_21190_(event.getHand()));
            this.dropAsPayload();
        }
    }

    @Override
    public void render(PoseStack matrixStack, MultiBufferSource buffer, int packedLight, float partialTicks) {
        if (this.payloadEntry != null) {
            matrixStack.m_85836_();
            EntityType entityType = this.planeEntity.m_6095_();
            if (entityType == SimplePlanesEntities.HELICOPTER.get()) {
                matrixStack.m_85837_(0.0, -0.1, -1.28);
            } else {
                matrixStack.m_85837_(0.0, 0.0, 0.1);
            }
            matrixStack.m_252781_(Axis.f_252403_.m_252977_(180.0f));
            matrixStack.m_85837_(-0.4, -1.0, 0.3);
            matrixStack.m_85841_(0.82f, 0.82f, 0.82f);
            BlockState state = this.payloadEntry.renderBlock().m_49966_();
            Minecraft.m_91087_().m_91289_().renderSingleBlock(state, matrixStack, buffer, packedLight, OverlayTexture.f_118083_, ModelData.EMPTY, null);
            matrixStack.m_85849_();
        }
    }

    @Override
    public void writePacket(FriendlyByteBuf buffer) {
        buffer.m_130085_(ForgeRegistries.ITEMS.getKey((Object)this.payloadEntry.item()));
        buffer.m_130085_(ForgeRegistries.BLOCKS.getKey((Object)this.payloadEntry.renderBlock()));
        buffer.m_130085_(ForgeRegistries.ENTITY_TYPES.getKey(this.payloadEntry.dropSpawnEntity()));
        buffer.m_130079_(this.payloadEntry.compoundTag());
    }

    @Override
    public void readPacket(FriendlyByteBuf buffer) {
        Item item = (Item)ForgeRegistries.ITEMS.getValue(buffer.m_130281_());
        Block renderBlock = (Block)ForgeRegistries.BLOCKS.getValue(buffer.m_130281_());
        EntityType dropSpawnEntity = (EntityType)ForgeRegistries.ENTITY_TYPES.getValue(buffer.m_130281_());
        CompoundTag compoundTag = buffer.m_130260_();
        this.payloadEntry = new PayloadEntry(item, renderBlock, dropSpawnEntity, compoundTag);
    }

    @Override
    public CompoundTag serializeNBT() {
        CompoundTag compoundTag = new CompoundTag();
        compoundTag.m_128359_("item", ForgeRegistries.ITEMS.getKey((Object)this.payloadEntry.item()).toString());
        compoundTag.m_128359_("block", ForgeRegistries.BLOCKS.getKey((Object)this.payloadEntry.renderBlock()).toString());
        compoundTag.m_128359_("entity", ForgeRegistries.ENTITY_TYPES.getKey(this.payloadEntry.dropSpawnEntity()).toString());
        compoundTag.m_128365_("entityTag", (Tag)this.payloadEntry.compoundTag());
        return compoundTag;
    }

    @Override
    public void deserializeNBT(CompoundTag nbt) {
        Item item = (Item)ForgeRegistries.ITEMS.getValue(new ResourceLocation(nbt.m_128461_("item")));
        Block renderBlock = (Block)ForgeRegistries.BLOCKS.getValue(new ResourceLocation(nbt.m_128461_("block")));
        EntityType dropSpawnEntity = (EntityType)ForgeRegistries.ENTITY_TYPES.getValue(new ResourceLocation(nbt.m_128461_("entity")));
        this.payloadEntry = new PayloadEntry(item, renderBlock, dropSpawnEntity, nbt.m_128469_("entityTag"));
    }

    @Override
    public void onRemoved() {
        this.planeEntity.m_19998_((ItemLike)this.payloadEntry.item());
    }

    @Override
    public boolean canBeDroppedAsPayload() {
        return true;
    }

    @Override
    public void dropAsPayload() {
        if (this.payloadEntry != null) {
            Entity entity = this.payloadEntry.dropSpawnEntity().m_20615_(this.planeEntity.m_9236_());
            entity.m_20258_(this.payloadEntry.compoundTag());
            entity.m_146884_(this.planeEntity.m_20182_());
            entity.m_20256_(this.planeEntity.m_20184_());
            this.planeEntity.m_9236_().m_7967_(entity);
        }
        this.remove();
    }
}

