/*
 * Decompiled with CFR 0.152.
 */
package xyz.przemyk.simpleplanes.upgrades.solarpanel;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import javax.annotation.Nullable;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.ItemRenderer;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.Level;
import xyz.przemyk.simpleplanes.client.render.UpgradesModels;
import xyz.przemyk.simpleplanes.entities.LargePlaneEntity;
import xyz.przemyk.simpleplanes.entities.PlaneEntity;
import xyz.przemyk.simpleplanes.setup.SimplePlanesEntities;
import xyz.przemyk.simpleplanes.setup.SimplePlanesItems;
import xyz.przemyk.simpleplanes.setup.SimplePlanesUpgrades;
import xyz.przemyk.simpleplanes.upgrades.Upgrade;
import xyz.przemyk.simpleplanes.upgrades.UpgradeType;
import xyz.przemyk.simpleplanes.upgrades.engines.EngineUpgrade;
import xyz.przemyk.simpleplanes.upgrades.engines.electric.ElectricEngineUpgrade;

public class SolarPanelUpgrade
extends Upgrade {
    private final short MAX_PER_TICK;

    public SolarPanelUpgrade(PlaneEntity planeEntity) {
        super((UpgradeType)SimplePlanesUpgrades.SOLAR_PANEL.get(), planeEntity);
        this.MAX_PER_TICK = planeEntity instanceof LargePlaneEntity ? (short)10 : (short)5;
    }

    @Override
    public void tick() {
        PlaneEntity entity = this.getPlaneEntity();
        Level world = entity.m_9236_();
        if (SolarPanelUpgrade.canSeeSun(world, entity.m_20097_().m_7494_())) {
            float brightness = (float)this.MAX_PER_TICK * SolarPanelUpgrade.getSunBrightness(entity.m_9236_(), 1.0f);
            EngineUpgrade engineUpgrade = entity.engineUpgrade;
            if (engineUpgrade instanceof ElectricEngineUpgrade) {
                ElectricEngineUpgrade engine = (ElectricEngineUpgrade)engineUpgrade;
                engine.energyStorage.receiveEnergy((int)brightness, false);
            }
        }
    }

    @Override
    public void render(PoseStack matrixStack, MultiBufferSource buffer, int packedLight, float partialTicks) {
        EntityType entityType = this.planeEntity.m_6095_();
        UpgradesModels.ModelEntry modelEntry = UpgradesModels.MODEL_ENTRIES.get(this.getType());
        if (entityType == SimplePlanesEntities.PLANE.get()) {
            VertexConsumer vertexconsumer = ItemRenderer.m_115184_((MultiBufferSource)buffer, (RenderType)RenderType.m_110467_((ResourceLocation)modelEntry.normalTexture()), (boolean)false, (boolean)false);
            modelEntry.normal().m_7695_(matrixStack, vertexconsumer, packedLight, OverlayTexture.f_118083_, 1.0f, 1.0f, 1.0f, 1.0f);
        } else if (entityType == SimplePlanesEntities.LARGE_PLANE.get()) {
            VertexConsumer vertexconsumer = ItemRenderer.m_115184_((MultiBufferSource)buffer, (RenderType)RenderType.m_110467_((ResourceLocation)modelEntry.largeTexture()), (boolean)false, (boolean)false);
            modelEntry.large().m_7695_(matrixStack, vertexconsumer, packedLight, OverlayTexture.f_118083_, 1.0f, 1.0f, 1.0f, 1.0f);
        }
    }

    @Override
    public void writePacket(FriendlyByteBuf buffer) {
    }

    @Override
    public void readPacket(FriendlyByteBuf buffer) {
    }

    @Override
    public void onRemoved() {
        this.planeEntity.m_19983_(((Item)SimplePlanesItems.SOLAR_PANEL.get()).m_7968_());
    }

    private static boolean canSeeSun(@Nullable Level level, BlockPos pos) {
        return level != null && level.m_6042_().f_223549_() && level.m_7445_() < 4 && level.m_45527_(pos);
    }

    public static float getSunBrightness(Level world, float partialTicks) {
        float f = world.m_46942_(partialTicks);
        float f1 = 1.0f - (Mth.m_14089_((float)(f * ((float)Math.PI * 2))) * 2.0f + 0.2f);
        f1 = Mth.m_14036_((float)f1, (float)0.0f, (float)1.0f);
        f1 = 1.0f - f1;
        f1 = (float)((double)f1 * (1.0 - (double)(world.m_46722_(partialTicks) * 5.0f) / 16.0));
        f1 = (float)((double)f1 * (1.0 - (double)(world.m_46661_(partialTicks) * 5.0f) / 16.0));
        return f1 * 0.8f;
    }
}

