/*
 * Decompiled with CFR 0.152.
 */
package xyz.przemyk.simpleplanes.upgrades.engines.liquid;

import java.util.function.Function;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.HumanoidArm;
import net.minecraft.world.inventory.DataSlot;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.templates.FluidTank;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemStackHandler;
import net.minecraftforge.items.SlotItemHandler;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import xyz.przemyk.simpleplanes.client.ClientUtil;
import xyz.przemyk.simpleplanes.client.gui.PlaneInventoryScreen;
import xyz.przemyk.simpleplanes.datapack.PlaneLiquidFuelReloadListener;
import xyz.przemyk.simpleplanes.entities.PlaneEntity;
import xyz.przemyk.simpleplanes.setup.SimplePlanesConfig;
import xyz.przemyk.simpleplanes.setup.SimplePlanesItems;
import xyz.przemyk.simpleplanes.setup.SimplePlanesUpgrades;
import xyz.przemyk.simpleplanes.upgrades.UpgradeType;
import xyz.przemyk.simpleplanes.upgrades.engines.EngineUpgrade;

public class LiquidEngineUpgrade
extends EngineUpgrade {
    public final ItemStackHandler itemStackHandler = new ItemStackHandler(2);
    public final FluidTank fluidTank = new FluidTank(((Integer)SimplePlanesConfig.LIQUID_ENGINE_CAPACITY.get()).intValue(), fluidStack -> PlaneLiquidFuelReloadListener.fuelMap.containsKey(fluidStack.getFluid().getFluidType()));
    public final LazyOptional<ItemStackHandler> itemHandlerLazyOptional = LazyOptional.of(() -> this.itemStackHandler);
    public final LazyOptional<FluidTank> fluidTankLazyOptional = LazyOptional.of(() -> this.fluidTank);
    public int burnTime;

    public LiquidEngineUpgrade(PlaneEntity planeEntity) {
        super((UpgradeType)SimplePlanesUpgrades.LIQUID_ENGINE.get(), planeEntity);
    }

    @Override
    public void tick() {
        if (!this.planeEntity.m_9236_().f_46443_) {
            if (this.burnTime > 0) {
                this.burnTime -= this.planeEntity.getFuelCost();
                this.updateClient();
            } else if (this.planeEntity.getThrottle() > 0 && !this.fluidTank.isEmpty()) {
                this.burnTime = PlaneLiquidFuelReloadListener.fuelMap.getOrDefault(this.fluidTank.getFluid().getFluid().getFluidType(), 0);
                if (this.burnTime > 0) {
                    this.fluidTank.drain(1, IFluidHandler.FluidAction.EXECUTE);
                    this.updateClient();
                }
            }
            if (this.itemStackHandler.getStackInSlot(1).m_41619_()) {
                ItemStack itemStack = this.itemStackHandler.getStackInSlot(0);
                itemStack.getCapability(ForgeCapabilities.FLUID_HANDLER_ITEM).ifPresent(fluidHandlerItem -> {
                    FluidStack itemFluidStack = fluidHandlerItem.getFluidInTank(0);
                    if (itemFluidStack.isEmpty()) {
                        this.fluidTank.drain(fluidHandlerItem.fill(this.fluidTank.drain(fluidHandlerItem.getTankCapacity(0), IFluidHandler.FluidAction.SIMULATE), IFluidHandler.FluidAction.EXECUTE), IFluidHandler.FluidAction.EXECUTE);
                    } else {
                        fluidHandlerItem.drain(this.fluidTank.fill(fluidHandlerItem.drain(this.fluidTank.getSpace(), IFluidHandler.FluidAction.SIMULATE), IFluidHandler.FluidAction.EXECUTE), IFluidHandler.FluidAction.EXECUTE);
                    }
                    this.itemStackHandler.setStackInSlot(0, ItemStack.f_41583_);
                    this.itemStackHandler.setStackInSlot(1, fluidHandlerItem.getContainer());
                    this.updateClient();
                });
            }
        }
    }

    @Override
    public void onRemoved() {
        this.planeEntity.m_19983_(this.itemStackHandler.getStackInSlot(0));
        this.planeEntity.m_19983_(this.itemStackHandler.getStackInSlot(1));
    }

    @Override
    public ItemStack getItemStack() {
        return ((Item)SimplePlanesItems.LIQUID_ENGINE.get()).m_7968_();
    }

    @Override
    public boolean isPowered() {
        return !this.fluidTank.isEmpty();
    }

    public void invalidateCaps() {
        super.invalidateCaps();
        this.itemHandlerLazyOptional.invalidate();
        this.fluidTankLazyOptional.invalidate();
    }

    @Override
    public CompoundTag serializeNBT() {
        CompoundTag compoundTag = new CompoundTag();
        compoundTag.m_128365_("items", (Tag)this.itemStackHandler.serializeNBT());
        compoundTag.m_128365_("fluid", (Tag)this.fluidTank.writeToNBT(new CompoundTag()));
        compoundTag.m_128405_("burnTime", this.burnTime);
        return compoundTag;
    }

    @Override
    public void deserializeNBT(CompoundTag nbt) {
        this.itemStackHandler.deserializeNBT(nbt.m_128469_("items"));
        this.fluidTank.readFromNBT(nbt.m_128469_("fluid"));
        this.burnTime = nbt.m_128451_("burnTime");
    }

    @Override
    public void writePacket(FriendlyByteBuf buffer) {
        buffer.writeFluidStack(this.fluidTank.getFluid());
        buffer.m_130130_(this.burnTime);
    }

    @Override
    public void readPacket(FriendlyByteBuf buffer) {
        this.fluidTank.setFluid(buffer.readFluidStack());
        this.burnTime = buffer.m_130242_();
    }

    @NotNull
    public <T> LazyOptional<T> getCapability(@NotNull Capability<T> cap, @Nullable Direction side) {
        if (cap == ForgeCapabilities.ITEM_HANDLER) {
            return this.itemHandlerLazyOptional.cast();
        }
        if (cap == ForgeCapabilities.FLUID_HANDLER) {
            return this.fluidTankLazyOptional.cast();
        }
        return super.getCapability(cap, side);
    }

    @Override
    public void renderPowerHUD(GuiGraphics guiGraphics, HumanoidArm side, int scaledWidth, int scaledHeight, float partialTicks) {
    }

    @Override
    public void addContainerData(Function<Slot, Slot> addSlot, Function<DataSlot, DataSlot> addDataSlot) {
        addSlot.apply((Slot)new SlotItemHandler((IItemHandler)this.itemStackHandler, 0, 152, 8));
        addSlot.apply((Slot)new SlotItemHandler((IItemHandler)this.itemStackHandler, 1, 152, 62));
    }

    @Override
    public void renderScreen(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTicks, PlaneInventoryScreen planeInventoryScreen) {
        if (planeInventoryScreen.m_6774_(153, 27, 16, 32, mouseX, mouseY)) {
            FluidStack fluidStack = this.fluidTank.getFluid();
            guiGraphics.m_280557_(planeInventoryScreen.getMinecraft().f_91062_, (Component)Component.m_237110_((String)"simpleplanes.gui.fluid", (Object[])new Object[]{fluidStack.getDisplayName(), fluidStack.getAmount()}), mouseX, mouseY);
        }
    }

    @Override
    public void renderScreenBg(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTicks, PlaneInventoryScreen screen) {
        guiGraphics.m_280218_(PlaneInventoryScreen.GUI, screen.getGuiLeft() + 151, screen.getGuiTop() + 7, 176, 72, 18, 72);
        FluidStack fluidStack = this.fluidTank.getFluid();
        int height = 36;
        int width = 18;
        int amount = fluidStack.getAmount();
        int fluidHeight = amount * (height - 4) / this.fluidTank.getCapacity();
        if (!fluidStack.isEmpty()) {
            ClientUtil.renderLiquidEngineFluid(guiGraphics, screen, fluidStack, height, width, fluidHeight);
        }
        guiGraphics.m_280218_(PlaneInventoryScreen.GUI, screen.getGuiLeft() + 154, screen.getGuiTop() + 28, 194, 72, 12, 30);
    }
}

