/*
 * Decompiled with CFR 0.152.
 */
package xyz.przemyk.simpleplanes.upgrades.shooter;

import java.util.function.Function;
import net.minecraft.Util;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.StructureTags;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.entity.projectile.Arrow;
import net.minecraft.world.entity.projectile.EyeOfEnder;
import net.minecraft.world.entity.projectile.Fireball;
import net.minecraft.world.entity.projectile.FireworkRocketEntity;
import net.minecraft.world.entity.projectile.SmallFireball;
import net.minecraft.world.entity.projectile.SpectralArrow;
import net.minecraft.world.inventory.DataSlot;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemStackHandler;
import net.minecraftforge.items.SlotItemHandler;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.joml.Vector3f;
import xyz.przemyk.simpleplanes.client.gui.PlaneInventoryScreen;
import xyz.przemyk.simpleplanes.entities.PlaneEntity;
import xyz.przemyk.simpleplanes.setup.SimplePlanesItems;
import xyz.przemyk.simpleplanes.setup.SimplePlanesUpgrades;
import xyz.przemyk.simpleplanes.upgrades.Upgrade;
import xyz.przemyk.simpleplanes.upgrades.UpgradeType;

public class ShooterUpgrade
extends Upgrade {
    public final ItemStackHandler itemStackHandler = new ItemStackHandler();
    public final LazyOptional<ItemStackHandler> itemStackHandlerLazyOptional = LazyOptional.of(() -> this.itemStackHandler);

    public ShooterUpgrade(PlaneEntity planeEntity) {
        super((UpgradeType)SimplePlanesUpgrades.SHOOTER.get(), planeEntity);
    }

    public void use(Player player) {
        ServerLevel serverLevel;
        BlockPos blockpos;
        Vector3f motion1 = this.planeEntity.transformPos(new Vector3f(0.0f, -0.25f, (float)(1.0 + this.planeEntity.m_20184_().m_82553_())));
        Vec3 motion = new Vec3(motion1);
        Level level = player.m_9236_();
        RandomSource random = level.f_46441_;
        Vector3f pos = this.planeEntity.transformPos(new Vector3f(0.0f, 1.8f, 2.0f));
        this.updateClient();
        double x = (double)pos.x() + this.planeEntity.m_20185_();
        double y = (double)pos.y() + this.planeEntity.m_20186_();
        double z = (double)pos.z() + this.planeEntity.m_20189_();
        ItemStack itemStack = this.itemStackHandler.getStackInSlot(0);
        Item item = itemStack.m_41720_();
        if (item == Items.f_42688_) {
            FireworkRocketEntity fireworkrocketentity = new FireworkRocketEntity(level, itemStack, x, y, z, true);
            fireworkrocketentity.m_6686_(-motion.f_82479_, -motion.f_82480_, -motion.f_82481_, -((float)Math.max(0.5, motion.m_82553_() * 1.5)), 1.0f);
            level.m_7967_((Entity)fireworkrocketentity);
            if (!player.m_7500_()) {
                this.itemStackHandler.extractItem(0, 1, false);
            }
        } else if (item == Items.f_42613_) {
            double d3 = random.m_188583_() * 0.05 + 2.0 * motion.f_82479_;
            double d4 = random.m_188583_() * 0.05;
            double d5 = random.m_188583_() * 0.05 + 2.0 * motion.f_82481_;
            Fireball fireBallEntity = (Fireball)Util.m_137469_((Object)new SmallFireball(level, (LivingEntity)player, d3, d4, d5), p_229425_1_ -> p_229425_1_.m_37010_(itemStack));
            fireBallEntity.m_6034_(x, y, z);
            fireBallEntity.m_20256_(motion.m_82490_(2.0));
            level.m_7967_((Entity)fireBallEntity);
            if (!player.m_7500_()) {
                this.itemStackHandler.extractItem(0, 1, false);
            }
        } else if (item == Items.f_42412_) {
            Arrow arrowEntity = new Arrow(level, x, y, z);
            arrowEntity.m_5602_((Entity)player);
            arrowEntity.m_20256_(motion.m_82490_(Math.max(motion.m_82553_() * 1.5, 3.0) / motion.m_82553_()));
            if (!player.m_7500_()) {
                this.itemStackHandler.extractItem(0, 1, false);
                arrowEntity.f_36705_ = AbstractArrow.Pickup.ALLOWED;
            }
            level.m_7967_((Entity)arrowEntity);
        } else if (item == Items.f_42738_) {
            Arrow arrowEntity = new Arrow(level, x, y, z);
            arrowEntity.m_5602_((Entity)player);
            arrowEntity.m_36878_(itemStack);
            arrowEntity.m_20256_(motion.m_82490_(Math.max(motion.m_82553_() * 1.5, 3.0) / motion.m_82553_()));
            if (!player.m_7500_()) {
                this.itemStackHandler.extractItem(0, 1, false);
                arrowEntity.f_36705_ = AbstractArrow.Pickup.ALLOWED;
            }
            level.m_7967_((Entity)arrowEntity);
        } else if (item == Items.f_42737_) {
            SpectralArrow arrowEntity = new SpectralArrow(level, x, y, z);
            arrowEntity.m_5602_((Entity)player);
            arrowEntity.m_20256_(motion.m_82490_(Math.max(motion.m_82553_() * 1.5, 3.0) / motion.m_82553_()));
            if (!player.m_7500_()) {
                this.itemStackHandler.extractItem(0, 1, false);
                arrowEntity.f_36705_ = AbstractArrow.Pickup.ALLOWED;
            }
            level.m_7967_((Entity)arrowEntity);
        } else if (item == Items.f_42545_ && level instanceof ServerLevel && (blockpos = (serverLevel = (ServerLevel)level).m_215011_(StructureTags.f_215882_, new BlockPos((int)x, (int)y, (int)z), 100, false)) != null) {
            EyeOfEnder eyeOfEnder = new EyeOfEnder(level, x, y, z);
            eyeOfEnder.m_36972_(itemStack);
            eyeOfEnder.m_36967_(blockpos);
            level.m_7967_((Entity)eyeOfEnder);
            level.m_6263_(null, x, y, z, SoundEvents.f_11898_, SoundSource.NEUTRAL, 0.5f, 0.4f / random.m_188501_() * 0.4f + 0.8f);
            if (!player.m_7500_()) {
                this.itemStackHandler.extractItem(0, 1, false);
            }
        }
    }

    public void invalidateCaps() {
        super.invalidateCaps();
        this.itemStackHandlerLazyOptional.invalidate();
    }

    @Override
    public CompoundTag serializeNBT() {
        CompoundTag compoundTag = new CompoundTag();
        compoundTag.m_128365_("item", (Tag)this.itemStackHandler.serializeNBT());
        return compoundTag;
    }

    @Override
    public void deserializeNBT(CompoundTag compoundTag) {
        this.itemStackHandler.deserializeNBT(compoundTag.m_128469_("item"));
    }

    @Override
    public void writePacket(FriendlyByteBuf buffer) {
        buffer.m_130055_(this.itemStackHandler.getStackInSlot(0));
    }

    @Override
    public void readPacket(FriendlyByteBuf buffer) {
        this.itemStackHandler.setStackInSlot(0, buffer.m_130267_());
    }

    @NotNull
    public <T> LazyOptional<T> getCapability(@NotNull Capability<T> cap, @Nullable Direction side) {
        if (cap == ForgeCapabilities.ITEM_HANDLER) {
            return this.itemStackHandlerLazyOptional.cast();
        }
        return super.getCapability(cap, side);
    }

    @Override
    public void onRemoved() {
        this.planeEntity.m_19983_(this.itemStackHandler.getStackInSlot(0));
    }

    @Override
    public ItemStack getItemStack() {
        return ((Item)SimplePlanesItems.SHOOTER.get()).m_7968_();
    }

    @Override
    public void addContainerData(Function<Slot, Slot> addSlot, Function<DataSlot, DataSlot> addDataSlot) {
        addSlot.apply((Slot)new SlotItemHandler((IItemHandler)this.itemStackHandler, 0, 134, 62));
    }

    @Override
    public void renderScreenBg(GuiGraphics guiGraphics, int x, int y, float partialTicks, PlaneInventoryScreen screen) {
        guiGraphics.m_280218_(PlaneInventoryScreen.GUI, screen.getGuiLeft() + 133, screen.getGuiTop() + 61, 226, 0, 18, 18);
    }
}

