/*
 * Decompiled with CFR 0.152.
 */
package com.flanks255.simplylight.blocks;

import com.flanks255.simplylight.blocks.LampBase;
import java.util.function.BiConsumer;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.MapColor;
import net.minecraft.world.level.material.PushReaction;

public class LampBlock
extends LampBase {
    public final boolean Default;
    public static final BooleanProperty ON = BooleanProperty.create((String)"on");
    public final DyeColor color;

    public LampBlock(boolean Default, DyeColor colorIn) {
        super(BlockBehaviour.Properties.of().strength(1.0f).pushReaction(PushReaction.NORMAL).mapColor(state -> (Boolean)state.getValue((Property)ON) != false ? MapColor.COLOR_LIGHT_GRAY : MapColor.COLOR_BLACK).lightLevel(bState -> (Boolean)bState.getValue((Property)ON) != false ? 15 : 0));
        this.Default = Default;
        this.color = colorIn;
        this.registerDefaultState((BlockState)((BlockState)this.getStateDefinition().any()).setValue((Property)ON, (Comparable)Boolean.valueOf(Default)));
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> blockStateBuilder) {
        blockStateBuilder.add(new Property[]{ON});
    }

    @Nullable
    public BlockState getStateForPlacement(@Nonnull BlockPlaceContext context) {
        return (BlockState)this.defaultBlockState().setValue((Property)ON, (Comparable)Boolean.valueOf(this.Default));
    }

    public void setPlacedBy(@Nonnull Level pLevel, @Nonnull BlockPos pPos, @Nonnull BlockState pState, @Nullable LivingEntity pPlacer, @Nonnull ItemStack pStack) {
        super.setPlacedBy(pLevel, pPos, pState, pPlacer, pStack);
        boolean powered = pLevel.hasNeighborSignal(pPos);
        if (powered) {
            pLevel.setBlockAndUpdate(pPos, (BlockState)this.defaultBlockState().setValue((Property)ON, (Comparable)Boolean.valueOf(!this.Default)));
        }
    }

    public void neighborChanged(@Nonnull BlockState pState, @Nonnull Level pLevel, @Nonnull BlockPos pPos, @Nonnull Block pBlock, @Nonnull BlockPos pFromPos, boolean pIsMoving) {
        super.neighborChanged(pState, pLevel, pPos, pBlock, pFromPos, pIsMoving);
        boolean on = this.Default != pLevel.hasNeighborSignal(pPos);
        pLevel.setBlockAndUpdate(pPos, (BlockState)this.defaultBlockState().setValue((Property)ON, (Comparable)Boolean.valueOf(on)));
    }

    public boolean isSignalSource(@Nonnull BlockState pState) {
        return true;
    }

    @Override
    public void addLang(BiConsumer<String, String> consumer) {
        String base = this.getDescriptionId();
        if (this.color == DyeColor.WHITE) {
            consumer.accept(base, "Illuminant Block" + (this.Default ? "(Inverted)" : ""));
        } else {
            String colorname = switch (this.color) {
                case DyeColor.RED -> "Red";
                case DyeColor.BLUE -> "Blue";
                case DyeColor.CYAN -> "Cyan";
                case DyeColor.GRAY -> "Gray";
                case DyeColor.LIME -> "Lime";
                case DyeColor.MAGENTA -> "Magenta";
                case DyeColor.PINK -> "Pink";
                case DyeColor.BLACK -> "Black";
                case DyeColor.BROWN -> "Brown";
                case DyeColor.GREEN -> "Green";
                case DyeColor.ORANGE -> "Orange";
                case DyeColor.PURPLE -> "Purple";
                case DyeColor.YELLOW -> "Yellow";
                case DyeColor.LIGHT_BLUE -> "Light Blue";
                case DyeColor.LIGHT_GRAY -> "Light Gray";
                default -> "";
            };
            consumer.accept(base, "Illuminant " + colorname + " Block" + (this.Default ? " (Inverted)" : ""));
        }
        consumer.accept(base + ".info", "Simple light block,");
        if (this.Default) {
            consumer.accept(base + ".info2", "Deactivates by %s.");
        } else {
            consumer.accept(base + ".info2", "Activates by %s.");
        }
    }
}

