/*
 * Decompiled with CFR 0.152.
 */
package bl4ckscor3.mod.snowundertrees;

import bl4ckscor3.mod.snowundertrees.Configuration;
import java.util.List;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ChunkHolder;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.LeavesBlock;
import net.minecraft.world.level.block.SnowyDirtBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.chunk.LevelChunk;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraftforge.event.TickEvent;
import sereneseasons.api.season.Season;
import sereneseasons.api.season.SeasonHelper;
import sereneseasons.season.SeasonHooks;

public class SereneSeasonsHandler {
    public static void tryMeltSnowUnderTrees(TickEvent.WorldTickEvent event) {
        Season.SubSeason subSeason = SeasonHelper.getSeasonState((Level)event.world).getSubSeason();
        Season season = subSeason.getSeason();
        if (season != Season.WINTER) {
            ServerLevel world = (ServerLevel)event.world;
            world.m_7726_().f_8325_.m_140416_().forEach(chunkHolder -> {
                Optional optional = chunkHolder.m_140073_().getNow(ChunkHolder.f_139997_).left();
                if (optional.isPresent()) {
                    int meltRandomness;
                    switch (subSeason) {
                        case EARLY_SPRING: {
                            int n = 16;
                            break;
                        }
                        case MID_SPRING: {
                            int n = 12;
                            break;
                        }
                        case LATE_SPRING: {
                            int n = 8;
                            break;
                        }
                        default: {
                            int n = meltRandomness = 4;
                        }
                    }
                    if (world.f_46441_.nextInt(meltRandomness) == 0) {
                        BlockPos pos;
                        BlockState state;
                        LevelChunk chunk = (LevelChunk)optional.get();
                        ChunkPos chunkPos = chunk.m_7697_();
                        int chunkX = chunkPos.m_45604_();
                        int chunkY = chunkPos.m_45605_();
                        BlockPos randomPos = world.m_46496_(chunkX, 0, chunkY, 15);
                        Biome biome = world.m_46857_(randomPos);
                        boolean biomeDisabled = ((List)Configuration.CONFIG.filteredBiomes.get()).contains(biome.getRegistryName().toString());
                        if (!biomeDisabled && world.m_8055_(world.m_5452_(Heightmap.Types.MOTION_BLOCKING, randomPos).m_7495_()).m_60734_() instanceof LeavesBlock && (state = world.m_8055_(pos = world.m_5452_(Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, randomPos))).m_60734_() == Blocks.f_50125_ && SeasonHooks.getBiomeTemperature((Level)world, (Biome)biome, (BlockPos)pos) >= 0.15f) {
                            BlockPos downPos = pos.m_7495_();
                            BlockState below = world.m_8055_(downPos);
                            world.m_46597_(pos, Blocks.f_50016_.m_49966_());
                            if (below.m_61138_((Property)SnowyDirtBlock.f_56637_)) {
                                world.m_7731_(downPos, (BlockState)below.m_61124_((Property)SnowyDirtBlock.f_56637_, (Comparable)Boolean.valueOf(false)), 2);
                            }
                        }
                    }
                }
            });
        }
    }
}

