/*
 * Decompiled with CFR 0.152.
 */
package bl4ckscor3.mod.snowundertrees;

import bl4ckscor3.mod.snowundertrees.Configuration;
import bl4ckscor3.mod.snowundertrees.SnowUnderTreesFeature;
import com.mojang.serialization.Codec;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.Registry;
import net.minecraft.data.BuiltinRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.levelgen.GenerationStep;
import net.minecraft.world.level.levelgen.feature.ConfiguredFeature;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.configurations.DecoratorConfiguration;
import net.minecraft.world.level.levelgen.feature.configurations.FeatureConfiguration;
import net.minecraft.world.level.levelgen.feature.configurations.NoneFeatureConfiguration;
import net.minecraft.world.level.levelgen.placement.FeatureDecorator;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.event.world.BiomeLoadingEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.config.IConfigSpec;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.registries.ObjectHolder;

@Mod(value="snowundertrees")
@Mod.EventBusSubscriber(modid="snowundertrees", bus=Mod.EventBusSubscriber.Bus.MOD)
public class SnowUnderTrees {
    public static final String MODID = "snowundertrees";
    @ObjectHolder(value="snowundertrees:snow_under_trees")
    public static final Feature<NoneFeatureConfiguration> SNOW_UNDER_TREES_FEATURE = (Feature)new SnowUnderTreesFeature((Codec<NoneFeatureConfiguration>)NoneFeatureConfiguration.f_67815_).setRegistryName("snow_under_trees");
    public static final ConfiguredFeature<?, ?> SNOW_UNDER_TREES = SNOW_UNDER_TREES_FEATURE.m_65815_((FeatureConfiguration)FeatureConfiguration.f_67737_).m_7679_(FeatureDecorator.f_70681_.m_70720_((DecoratorConfiguration)DecoratorConfiguration.f_67591_));
    private static List<ResourceLocation> biomesToAddTo = new ArrayList<ResourceLocation>();

    public SnowUnderTrees() {
        ModLoadingContext.get().registerConfig(ModConfig.Type.COMMON, (IConfigSpec)Configuration.CONFIG_SPEC);
        MinecraftForge.EVENT_BUS.addListener(SnowUnderTrees::onBiomeLoading);
    }

    @SubscribeEvent
    public static void onRegisterFeature(RegistryEvent.Register<Feature<?>> event) {
        event.getRegistry().register(SNOW_UNDER_TREES_FEATURE);
        Registry.m_122961_((Registry)BuiltinRegistries.f_123861_, (String)"snowundertrees:snow_under_trees", SNOW_UNDER_TREES);
    }

    public static void onBiomeLoading(BiomeLoadingEvent event) {
        if (((Boolean)Configuration.CONFIG.enableBiomeFeature.get()).booleanValue() && (event.getClimate().f_47680_ == Biome.Precipitation.SNOW || biomesToAddTo.contains(event.getName())) && !((List)Configuration.CONFIG.filteredBiomes.get()).contains(event.getName().toString())) {
            event.getGeneration().m_47834_(GenerationStep.Decoration.TOP_LAYER_MODIFICATION.ordinal(), () -> SNOW_UNDER_TREES);
        }
    }

    public static void addSnowUnderTrees(Biome biome) {
        if (!biomesToAddTo.contains(biome.getRegistryName())) {
            biomesToAddTo.add(biome.getRegistryName());
        }
    }
}

