/*
 * Decompiled with CFR 0.152.
 */
package bl4ckscor3.mod.snowundertrees;

import bl4ckscor3.mod.snowundertrees.Configuration;
import bl4ckscor3.mod.snowundertrees.SnowUnderTrees;
import java.util.List;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ChunkHolder;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.BlockTags;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.block.SnowyDirtBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.chunk.LevelChunk;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraftforge.event.TickEvent;
import sereneseasons.api.season.Season;
import sereneseasons.api.season.SeasonHelper;
import sereneseasons.config.SeasonsConfig;
import sereneseasons.season.SeasonHooks;

public class SereneSeasonsHandler {
    public static void tryMeltSnowUnderTrees(TickEvent.LevelTickEvent event) {
        Season.SubSeason subSeason = SeasonHelper.getSeasonState((Level)event.level).getSubSeason();
        Season season = subSeason.getSeason();
        if (season != Season.WINTER) {
            ServerLevel level = (ServerLevel)event.level;
            level.m_7726_().f_8325_.m_140416_().forEach(chunkHolder -> {
                Optional optional = chunkHolder.m_140073_().getNow(ChunkHolder.f_139997_).left();
                if (optional.isPresent()) {
                    int meltRandomness;
                    switch (subSeason) {
                        case EARLY_SPRING: {
                            int n = 16;
                            break;
                        }
                        case MID_SPRING: {
                            int n = 12;
                            break;
                        }
                        case LATE_SPRING: {
                            int n = 8;
                            break;
                        }
                        default: {
                            int n = meltRandomness = 4;
                        }
                    }
                    if (SnowUnderTrees.RANDOM.m_188503_(meltRandomness) == 0) {
                        BlockState stateAfter;
                        BlockState stateNow;
                        BlockPos pos;
                        LevelChunk chunk = (LevelChunk)optional.get();
                        ChunkPos chunkPos = chunk.m_7697_();
                        int chunkX = chunkPos.m_45604_();
                        int chunkY = chunkPos.m_45605_();
                        BlockPos randomPos = level.m_46496_(chunkX, 0, chunkY, 15);
                        Holder biomeHolder = level.m_204166_(randomPos);
                        boolean biomeDisabled = ((List)Configuration.CONFIG.filteredBiomes.get()).contains(((ResourceKey)biomeHolder.m_203543_().get()).m_135782_().toString());
                        if (!biomeDisabled && level.m_8055_(level.m_5452_(Heightmap.Types.MOTION_BLOCKING, randomPos).m_7495_()).m_204336_(BlockTags.f_13035_) && SnowUnderTrees.isSnow((WorldGenLevel)level, pos = level.m_5452_(Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, randomPos)) && SeasonHooks.warmEnoughToRainSeasonal((LevelReader)level, (Holder)biomeHolder, (BlockPos)pos) && (stateNow = level.m_8055_(pos)) != (stateAfter = SnowUnderTrees.getStateAfterMelting(stateNow, (WorldGenLevel)level, pos))) {
                            BlockPos downPos = pos.m_7495_();
                            BlockState below = level.m_8055_(downPos);
                            level.m_46597_(pos, stateAfter);
                            if (below.m_61138_((Property)SnowyDirtBlock.f_56637_)) {
                                level.m_7731_(downPos, (BlockState)below.m_61124_((Property)SnowyDirtBlock.f_56637_, (Comparable)Boolean.valueOf(false)), 2);
                            }
                        }
                    }
                }
            });
        }
    }

    public static boolean coldEnoughToSnow(WorldGenLevel level, Holder<Biome> biome, BlockPos pos) {
        return SeasonHooks.coldEnoughToSnowSeasonal((LevelReader)level, biome, (BlockPos)pos);
    }

    public static boolean generateSnowAndIce() {
        return (Boolean)SeasonsConfig.generateSnowAndIce.get();
    }
}

