/*
 * Decompiled with CFR 0.152.
 */
package bl4ckscor3.mod.snowundertrees;

import bl4ckscor3.mod.snowundertrees.Configuration;
import bl4ckscor3.mod.snowundertrees.SereneSeasonsHandler;
import bl4ckscor3.mod.snowundertrees.SnowUnderTrees;
import java.util.List;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.registries.Registries;
import net.minecraft.server.level.ChunkHolder;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.BlockTags;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.block.SnowyDirtBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.chunk.LevelChunk;
import net.minecraft.world.level.levelgen.Heightmap;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.LogicalSide;
import net.neoforged.fml.common.Mod;
import net.neoforged.neoforge.event.TickEvent;

@Mod.EventBusSubscriber(modid="snowundertrees")
public class LevelTickHandler {
    @SubscribeEvent
    public static void onWorldTick(TickEvent.LevelTickEvent event) {
        if (event.side == LogicalSide.SERVER) {
            if (event.phase == TickEvent.Phase.START && event.level.isRaining() && ((Boolean)Configuration.CONFIG.enableWhenSnowing.get()).booleanValue()) {
                ServerLevel level = (ServerLevel)event.level;
                if (SnowUnderTrees.isSereneSeasonsLoaded() && !SereneSeasonsHandler.generateSnowAndIce()) {
                    return;
                }
                level.getChunkSource().chunkMap.getChunks().forEach(chunkHolder -> {
                    Optional optional = chunkHolder.getEntityTickingChunkFuture().getNow(ChunkHolder.UNLOADED_LEVEL_CHUNK).left();
                    if (optional.isPresent() && SnowUnderTrees.RANDOM.nextInt(16) == 0) {
                        BlockPos posBelow;
                        BlockState stateBelow;
                        BlockPos pos;
                        LevelChunk chunk = (LevelChunk)optional.get();
                        ChunkPos chunkPos = chunk.getPos();
                        int chunkX = chunkPos.getMinBlockX();
                        int chunkY = chunkPos.getMinBlockZ();
                        BlockPos randomPos = level.getBlockRandomPos(chunkX, 0, chunkY, 15);
                        Biome biome = (Biome)level.getBiome(randomPos).value();
                        boolean biomeDisabled = ((List)Configuration.CONFIG.filteredBiomes.get()).contains(level.registryAccess().registryOrThrow(Registries.BIOME).getKey((Object)biome).toString());
                        if (!biomeDisabled && level.getBlockState(level.getHeightmapPos(Heightmap.Types.MOTION_BLOCKING, randomPos).below()).is(BlockTags.LEAVES) && SnowUnderTrees.placeSnow((WorldGenLevel)level, pos = level.getHeightmapPos(Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, randomPos)) && (stateBelow = level.getBlockState(posBelow = pos.below())).hasProperty((Property)SnowyDirtBlock.SNOWY)) {
                            level.setBlock(posBelow, (BlockState)stateBelow.setValue((Property)SnowyDirtBlock.SNOWY, (Comparable)Boolean.valueOf(true)), 2);
                        }
                    }
                });
            } else if (event.phase == TickEvent.Phase.END && SnowUnderTrees.isSereneSeasonsLoaded()) {
                SereneSeasonsHandler.tryMeltSnowUnderTrees(event);
            }
        }
    }
}

