/*
 * Decompiled with CFR 0.152.
 */
package bl4ckscor3.mod.snowundertrees;

import bl4ckscor3.mod.snowundertrees.Configuration;
import bl4ckscor3.mod.snowundertrees.SnowUnderTrees;
import java.util.List;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ChunkHolder;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.BlockTags;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.block.SnowyDirtBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.chunk.LevelChunk;
import net.minecraft.world.level.levelgen.Heightmap;
import net.neoforged.neoforge.event.TickEvent;
import sereneseasons.api.season.Season;
import sereneseasons.api.season.SeasonHelper;
import sereneseasons.init.ModConfig;
import sereneseasons.season.SeasonHooks;

public class SereneSeasonsHandler {
    public static void tryMeltSnowUnderTrees(TickEvent.LevelTickEvent event) {
        Season.SubSeason subSeason = SeasonHelper.getSeasonState((Level)event.level).getSubSeason();
        Season season = subSeason.getSeason();
        if (season != Season.WINTER) {
            ServerLevel level = (ServerLevel)event.level;
            level.getChunkSource().chunkMap.getChunks().forEach(chunkHolder -> {
                Optional optional = chunkHolder.getEntityTickingChunkFuture().getNow(ChunkHolder.UNLOADED_LEVEL_CHUNK).left();
                if (optional.isPresent()) {
                    int meltRandomness;
                    switch (subSeason) {
                        case EARLY_SPRING: {
                            int n = 16;
                            break;
                        }
                        case MID_SPRING: {
                            int n = 12;
                            break;
                        }
                        case LATE_SPRING: {
                            int n = 8;
                            break;
                        }
                        default: {
                            int n = meltRandomness = 4;
                        }
                    }
                    if (SnowUnderTrees.RANDOM.nextInt(meltRandomness) == 0) {
                        BlockState stateAfter;
                        BlockState stateNow;
                        BlockPos pos;
                        LevelChunk chunk = (LevelChunk)optional.get();
                        ChunkPos chunkPos = chunk.getPos();
                        int chunkX = chunkPos.getMinBlockX();
                        int chunkY = chunkPos.getMinBlockZ();
                        BlockPos randomPos = level.getBlockRandomPos(chunkX, 0, chunkY, 15);
                        Holder biomeHolder = level.getBiome(randomPos);
                        boolean biomeDisabled = ((List)Configuration.CONFIG.filteredBiomes.get()).contains(((ResourceKey)biomeHolder.unwrapKey().get()).location().toString());
                        if (!biomeDisabled && level.getBlockState(level.getHeightmapPos(Heightmap.Types.MOTION_BLOCKING, randomPos).below()).is(BlockTags.LEAVES) && SnowUnderTrees.isSnow((WorldGenLevel)level, pos = level.getHeightmapPos(Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, randomPos)) && SeasonHooks.warmEnoughToRainSeasonal((LevelReader)level, (Holder)biomeHolder, (BlockPos)pos) && (stateNow = level.getBlockState(pos)) != (stateAfter = SnowUnderTrees.getStateAfterMelting(stateNow, (WorldGenLevel)level, pos))) {
                            BlockPos downPos = pos.below();
                            BlockState below = level.getBlockState(downPos);
                            level.setBlockAndUpdate(pos, stateAfter);
                            if (below.hasProperty((Property)SnowyDirtBlock.SNOWY)) {
                                level.setBlock(downPos, (BlockState)below.setValue((Property)SnowyDirtBlock.SNOWY, (Comparable)Boolean.valueOf(false)), 2);
                            }
                        }
                    }
                }
            });
        }
    }

    public static boolean coldEnoughToSnow(WorldGenLevel level, Holder<Biome> biome, BlockPos pos) {
        return SeasonHooks.coldEnoughToSnowSeasonal((LevelReader)level, biome, (BlockPos)pos);
    }

    public static boolean generateSnowAndIce() {
        return ModConfig.seasons.generateSnowAndIce;
    }
}

