/*
 * Decompiled with CFR 0.152.
 */
package nl.andrewlalis.speed_carts.mixin;

import com.mojang.datafixers.util.Pair;
import java.util.ArrayList;
import java.util.Collection;
import java.util.regex.Pattern;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1313;
import net.minecraft.class_1657;
import net.minecraft.class_1688;
import net.minecraft.class_1767;
import net.minecraft.class_1937;
import net.minecraft.class_2241;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2382;
import net.minecraft.class_243;
import net.minecraft.class_2442;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_2625;
import net.minecraft.class_2680;
import net.minecraft.class_2741;
import net.minecraft.class_2768;
import net.minecraft.class_2769;
import net.minecraft.class_2960;
import net.minecraft.class_3414;
import net.minecraft.class_3419;
import net.minecraft.class_3532;
import nl.andrewlalis.speed_carts.SpeedCarts;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={class_1688.class})
public abstract class AbstractMinecartMixin
extends class_1297 {
    private static final double DEFAULT_SPEED = SpeedCarts.config.getDefaultSpeed();
    private static final double MIN_SPEED = SpeedCarts.config.getMinimumSpeed();
    private static final double MAX_SPEED = SpeedCarts.config.getMaximumSpeed();
    private static final Pattern SIGN_PATTERN = Pattern.compile(SpeedCarts.config.getSignRegex());
    private static final long SPEED_UPDATE_COOLDOWN = 60L;
    private double maxSpeedBps = DEFAULT_SPEED;
    private long lastSpeedUpdate = 0L;
    private class_2338 lastUpdatedFrom = null;

    @Shadow
    public abstract class_243 method_7508(double var1, double var3, double var5);

    @Shadow
    private static Pair<class_2382, class_2382> method_22864(class_2768 shape) {
        return null;
    }

    @Shadow
    protected abstract double method_7504();

    @Inject(at={@At(value="HEAD")}, method={"getMaxOffRailSpeed"}, cancellable=true)
    public void getMaxOffRailSpeedOverwrite(CallbackInfoReturnable<Double> cir) {
        cir.setReturnValue((Object)(this.maxSpeedBps / 20.0));
    }

    @Shadow
    protected abstract void method_7525();

    @Shadow
    protected abstract boolean method_18803(class_2338 var1);

    public AbstractMinecartMixin(class_1299<?> type, class_1937 world) {
        super(type, world);
    }

    @Shadow
    protected abstract void method_7513(class_2338 var1, class_2680 var2);

    @Shadow
    public abstract class_2350 method_5755();

    @Inject(at={@At(value="HEAD")}, method={"moveOnRail"}, cancellable=true)
    public void moveOnRailOverwrite(class_2338 pos, class_2680 state, CallbackInfo ci) {
        this.updateForSpeedModifiers(pos);
        this.modifiedMoveOnRail(pos, state);
        ci.cancel();
    }

    private void updateForSpeedModifiers(class_2338 pos) {
        if (this.method_18798().method_1033() == 0.0) {
            this.maxSpeedBps = DEFAULT_SPEED;
            return;
        }
        for (class_2338 position : this.getPositionsToCheck(pos)) {
            class_2680 state;
            class_2350 dir;
            class_2625 sign;
            class_2586 blockEntity = this.field_6002.method_8321(position);
            if (!(blockEntity instanceof class_2625) || (sign = (class_2625)blockEntity).method_11016().equals((Object)this.lastUpdatedFrom) && this.field_6002.method_8510() <= this.lastSpeedUpdate + 60L || (dir = (class_2350)(state = this.field_6002.method_8320(position)).method_11656().get((Object)class_2741.field_12481)) != null && !dir.equals((Object)this.method_5755().method_10153()) || !this.updateSpeedForSign(sign)) continue;
            return;
        }
    }

    private boolean updateSpeedForSign(class_2625 sign) {
        class_2561 text = sign.method_30843(0, false);
        String s = text.method_10851();
        if (!SIGN_PATTERN.matcher(s).matches()) {
            return false;
        }
        try {
            double speed = Double.parseDouble(s);
            if (speed >= MIN_SPEED && speed <= MAX_SPEED) {
                class_1657 player;
                this.maxSpeedBps = speed;
                this.lastSpeedUpdate = this.field_6002.method_8510();
                this.lastUpdatedFrom = sign.method_11016();
                if (this.method_5817() && (player = (class_1657)this.method_31483()) != null) {
                    player.method_17356(new class_3414(new class_2960("block.note_block.bell")), class_3419.field_15248, 1.0f, 1.0f);
                }
                return true;
            }
            sign.method_11299(0, class_2561.method_30163((String)"Invalid speed!"));
            sign.method_11299(1, class_2561.method_30163((String)("Min: " + MIN_SPEED)));
            sign.method_11299(2, class_2561.method_30163((String)("Max: " + MAX_SPEED)));
            sign.method_34270(true);
            sign.method_16127(class_1767.field_7964);
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        return false;
    }

    private Collection<class_2338> getPositionsToCheck(class_2338 pos) {
        int blockRange = Math.max(1, (int)Math.ceil(this.maxSpeedBps / 20.0));
        ArrayList<class_2338> positionsToCheck = new ArrayList<class_2338>(6 * blockRange);
        for (int i = 0; i < blockRange; ++i) {
            positionsToCheck.add(pos.method_10095());
            positionsToCheck.add(pos.method_10072());
            positionsToCheck.add(pos.method_10078());
            positionsToCheck.add(pos.method_10067());
            positionsToCheck.add(pos.method_10084());
            positionsToCheck.add(pos.method_10074());
            pos = pos.method_10081(this.method_5755().method_10163());
        }
        return positionsToCheck;
    }

    private void modifiedMoveOnRail(class_2338 pos, class_2680 state) {
        double af;
        class_243 vec3d7;
        double w;
        double v;
        double x;
        this.field_6017 = 0.0f;
        double d = this.method_23317();
        double e = this.method_23318();
        double f = this.method_23321();
        class_243 vec3d = this.method_7508(d, e, f);
        e = pos.method_10264();
        boolean onPoweredRail = false;
        boolean onNormalRail = false;
        if (state.method_27852(class_2246.field_10425)) {
            onPoweredRail = (Boolean)state.method_11654((class_2769)class_2442.field_11364);
            onNormalRail = !onPoweredRail;
        }
        double g = 0.0078125;
        if (this.method_5799()) {
            g *= 0.2;
        }
        class_243 velocity = this.method_18798();
        class_2768 railShape = (class_2768)state.method_11654(((class_2241)state.method_26204()).method_9474());
        switch (railShape) {
            case field_12667: {
                this.method_18799(velocity.method_1031(-g, 0.0, 0.0));
                e += 1.0;
                break;
            }
            case field_12666: {
                this.method_18799(velocity.method_1031(g, 0.0, 0.0));
                e += 1.0;
                break;
            }
            case field_12670: {
                this.method_18799(velocity.method_1031(0.0, 0.0, g));
                e += 1.0;
                break;
            }
            case field_12668: {
                this.method_18799(velocity.method_1031(0.0, 0.0, -g));
                e += 1.0;
            }
        }
        velocity = this.method_18798();
        Pair<class_2382, class_2382> adjacentRailPositions = AbstractMinecartMixin.method_22864(railShape);
        class_2382 vec3i = (class_2382)adjacentRailPositions.getFirst();
        class_2382 vec3i2 = (class_2382)adjacentRailPositions.getSecond();
        double h = vec3i2.method_10263() - vec3i.method_10263();
        double i = vec3i2.method_10260() - vec3i.method_10260();
        double j = Math.sqrt(h * h + i * i);
        double k = velocity.field_1352 * h + velocity.field_1350 * i;
        if (k < 0.0) {
            h = -h;
            i = -i;
        }
        double l = Math.min(2.0, velocity.method_37267());
        if (this.maxSpeedBps <= DEFAULT_SPEED) {
            this.method_18799(new class_243(l * h / j, velocity.field_1351, l * i / j));
        } else {
            double speed = this.maxSpeedBps / 20.0;
            this.method_18799(new class_243(Math.max(Math.min(speed, velocity.field_1352), -speed), velocity.field_1351, Math.max(Math.min(speed, velocity.field_1350), -speed)));
        }
        class_1297 entity = this.method_31483();
        if (entity instanceof class_1657) {
            class_243 playerVelocity = entity.method_18798();
            double m = playerVelocity.method_37268();
            double n = this.method_18798().method_37268();
            if (m > 1.0E-4 && n < 0.01) {
                this.method_18799(this.method_18798().method_1031(playerVelocity.field_1352 * 0.1, 0.0, playerVelocity.field_1350 * 0.1));
                onNormalRail = false;
            }
        }
        if (onNormalRail) {
            double p = this.method_18798().method_37267();
            if (p < 0.03) {
                this.method_18799(class_243.field_1353);
            } else {
                this.method_18799(this.method_18798().method_18805(0.5, 0.0, 0.5));
            }
        }
        double p = (double)pos.method_10263() + 0.5 + (double)vec3i.method_10263() * 0.5;
        double q = (double)pos.method_10260() + 0.5 + (double)vec3i.method_10260() * 0.5;
        double r = (double)pos.method_10263() + 0.5 + (double)vec3i2.method_10263() * 0.5;
        double s = (double)pos.method_10260() + 0.5 + (double)vec3i2.method_10260() * 0.5;
        h = r - p;
        i = s - q;
        if (h == 0.0) {
            x = f - (double)pos.method_10260();
        } else if (i == 0.0) {
            x = d - (double)pos.method_10263();
        } else {
            v = d - p;
            w = f - q;
            x = (v * h + w * i) * 2.0;
        }
        d = p + h * x;
        f = q + i * x;
        this.method_5814(d, e, f);
        v = this.method_5782() ? 0.75 : 1.0;
        w = this.method_7504();
        velocity = this.method_18798();
        class_243 movement = new class_243(class_3532.method_15350((double)(v * velocity.field_1352), (double)(-w), (double)w), 0.0, class_3532.method_15350((double)(v * velocity.field_1350), (double)(-w), (double)w));
        this.method_5784(class_1313.field_6308, movement);
        if (vec3i.method_10264() != 0 && class_3532.method_15357((double)this.method_23317()) - pos.method_10263() == vec3i.method_10263() && class_3532.method_15357((double)this.method_23321()) - pos.method_10260() == vec3i.method_10260()) {
            this.method_5814(this.method_23317(), this.method_23318() + (double)vec3i.method_10264(), this.method_23321());
        } else if (vec3i2.method_10264() != 0 && class_3532.method_15357((double)this.method_23317()) - pos.method_10263() == vec3i2.method_10263() && class_3532.method_15357((double)this.method_23321()) - pos.method_10260() == vec3i2.method_10260()) {
            this.method_5814(this.method_23317(), this.method_23318() + (double)vec3i2.method_10264(), this.method_23321());
        }
        this.method_7525();
        class_243 vec3d4 = this.method_7508(this.method_23317(), this.method_23318(), this.method_23321());
        if (vec3d4 != null && vec3d != null) {
            double aa = (vec3d.field_1351 - vec3d4.field_1351) * 0.05;
            vec3d7 = this.method_18798();
            af = vec3d7.method_37267();
            if (af > 0.0) {
                this.method_18799(vec3d7.method_18805((af + aa) / af, 1.0, (af + aa) / af));
            }
            this.method_5814(this.method_23317(), vec3d4.field_1351, this.method_23321());
        }
        int ac = class_3532.method_15357((double)this.method_23317());
        int ad = class_3532.method_15357((double)this.method_23321());
        if (ac != pos.method_10263() || ad != pos.method_10260()) {
            vec3d7 = this.method_18798();
            af = vec3d7.method_37267();
            this.method_18800(af * (double)(ac - pos.method_10263()), vec3d7.field_1351, af * (double)(ad - pos.method_10260()));
        }
        if (onPoweredRail) {
            vec3d7 = this.method_18798();
            af = vec3d7.method_37267();
            if (af > 0.01) {
                this.method_18799(vec3d7.method_1031(vec3d7.field_1352 / af * 0.06, 0.0, vec3d7.field_1350 / af * 0.06));
            } else {
                class_243 vec3d8 = this.method_18798();
                double ah = vec3d8.field_1352;
                double ai = vec3d8.field_1350;
                if (railShape == class_2768.field_12674) {
                    if (this.method_18803(pos.method_10067())) {
                        ah = 0.02;
                    } else if (this.method_18803(pos.method_10078())) {
                        ah = -0.02;
                    }
                } else {
                    if (railShape != class_2768.field_12665) {
                        return;
                    }
                    if (this.method_18803(pos.method_10095())) {
                        ai = 0.02;
                    } else if (this.method_18803(pos.method_10072())) {
                        ai = -0.02;
                    }
                }
                this.method_18800(ah, vec3d8.field_1351, ai);
            }
        }
    }
}

