/*
 * Decompiled with CFR 0.152.
 */
package com.terraforged.mod.client.screen;

import com.terraforged.mod.platform.ClientAPI;
import com.terraforged.mod.worldgen.GeneratorPreset;
import java.util.function.Predicate;
import net.minecraft.Util;
import net.minecraft.client.gui.components.CycleButton;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.worldselection.CreateWorldScreen;
import net.minecraft.client.gui.screens.worldselection.WorldPreset;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.resources.ResourceLocation;

public class ScreenUtil {
    private static final String WORLD_TYPE = "selectWorld.mapType";
    private static final Predicate<String> TF_PRESET = s -> s.equals(GeneratorPreset.TRANSLATION_KEY);
    private static final Predicate<String> DEFAULT_PRESET = s -> s.equals(GeneratorPreset.TRANSLATION_KEY);

    public static void enforceDefaultPreset(CreateWorldScreen screen, String name) {
        CycleButton<?> button = ScreenUtil.getPresetButton((Screen)screen);
        if (button == null) {
            return;
        }
        Object start = button.m_168883_();
        Predicate<String> keyPredicate = ScreenUtil.createKeyPredicate(name);
        while (!ScreenUtil.isPresetSelected(button, keyPredicate)) {
            button.m_5691_();
            if (button.m_168883_() != start) continue;
            return;
        }
    }

    public static boolean isPresetEnabled(CreateWorldScreen screen) {
        CycleButton<?> button = ScreenUtil.getPresetButton((Screen)screen);
        if (button == null) {
            return false;
        }
        if (!ClientAPI.get().hasPreset()) {
            return ScreenUtil.isPresetSelected(button, DEFAULT_PRESET);
        }
        return ScreenUtil.isPresetSelected(button, TF_PRESET);
    }

    private static Predicate<String> createKeyPredicate(String name) {
        if (name.equals("terraforged")) {
            return TF_PRESET;
        }
        ResourceLocation location = new ResourceLocation(name);
        String key = Util.m_137492_((String)"generator", (ResourceLocation)location);
        if (location.m_135827_().equals("minecraft")) {
            String key0 = "generator." + location.m_135815_();
            return s -> s.equals(key) || s.equals(key0);
        }
        return s -> s.equals(key);
    }

    private static boolean isPresetSelected(CycleButton<?> button, Predicate<String> predicate) {
        WorldPreset preset = (WorldPreset)button.m_168883_();
        Component component = preset.m_101523_();
        if (component instanceof TranslatableComponent) {
            TranslatableComponent description = (TranslatableComponent)component;
            return predicate.test(description.m_131328_());
        }
        return false;
    }

    private static CycleButton<?> getPresetButton(Screen screen) {
        for (GuiEventListener child : screen.m_6702_()) {
            CycleButton button;
            if (!(child instanceof CycleButton) || !ScreenUtil.isPresetButtonText((button = (CycleButton)child).m_6035_())) continue;
            return button;
        }
        return null;
    }

    private static boolean isPresetButtonText(Component component) {
        if (component instanceof TranslatableComponent) {
            TranslatableComponent translatable = (TranslatableComponent)component;
            if (translatable.m_131328_().equals(WORLD_TYPE)) {
                return true;
            }
            for (Object arg : translatable.m_131329_()) {
                Component argText;
                if (!(arg instanceof Component) || !ScreenUtil.isPresetButtonText(argText = (Component)arg)) continue;
                return true;
            }
        }
        return false;
    }
}

