/*
 * Decompiled with CFR 0.152.
 */
package com.terraforged.mod.platform.forge.client;

import com.terraforged.mod.client.Client;
import com.terraforged.mod.client.screen.ScreenUtil;
import com.terraforged.mod.platform.ClientAPI;
import com.terraforged.mod.platform.forge.client.TFPreset;
import com.terraforged.mod.util.DemoHandler;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.worldselection.CreateWorldScreen;
import net.minecraftforge.client.event.RenderGameOverlayEvent;
import net.minecraftforge.client.event.ScreenEvent;
import net.minecraftforge.common.ForgeConfig;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;

public class TFClient {
    public TFClient() {
        ClientAPI.HOLDER.set(new ForgeClientAPI());
        FMLJavaModLoadingContext.get().getModEventBus().addListener(this::onClientInit);
        MinecraftForge.EVENT_BUS.addListener(this::onRenderOverlay);
        MinecraftForge.EVENT_BUS.addListener(EventPriority.LOWEST, this::onScreenOpen);
    }

    void onClientInit(FMLClientSetupEvent event) {
        event.enqueueWork(Client.INSTANCE::init);
        event.enqueueWork(TFPreset::makeDefault);
    }

    void onRenderOverlay(RenderGameOverlayEvent event) {
        DemoHandler.renderOverlay(event.getMatrixStack());
    }

    void onScreenOpen(ScreenEvent.InitScreenEvent.Post event) {
        Screen screen = event.getScreen();
        if (screen instanceof CreateWorldScreen) {
            CreateWorldScreen createWorldScreen = (CreateWorldScreen)screen;
            String name = (String)ForgeConfig.COMMON.defaultWorldType.get();
            ScreenUtil.enforceDefaultPreset(createWorldScreen, name);
        }
    }

    private static class ForgeClientAPI
    implements ClientAPI {
        private ForgeClientAPI() {
        }

        @Override
        public boolean hasPreset() {
            return true;
        }

        @Override
        public boolean isDefaultPreset() {
            return ((String)ForgeConfig.COMMON.defaultWorldType.get()).equals("terraforged");
        }

        @Override
        public boolean isPresetSelected(CreateWorldScreen screen) {
            return ScreenUtil.isPresetEnabled(screen);
        }
    }
}

