/*
 * Decompiled with CFR 0.152.
 */
package com.terraforged.mod.registry.hooks;

import com.mojang.serialization.Lifecycle;
import com.terraforged.mod.TerraForged;
import com.terraforged.mod.registry.ModRegistries;
import com.terraforged.mod.registry.hooks.RegistryAccessUtil;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.core.MappedRegistry;
import net.minecraft.core.Registry;
import net.minecraft.core.RegistryAccess;
import net.minecraft.resources.RegistryResourceAccess;
import net.minecraft.resources.ResourceKey;

public class BuiltinHook {
    public static Map<? extends ResourceKey<? extends Registry<?>>, MappedRegistry<?>> addRegistries(Map<? extends ResourceKey<? extends Registry<?>>, ? extends MappedRegistry<?>> registries) {
        HashMap map = new HashMap(registries);
        for (ModRegistries.Holder<?> holder : ModRegistries.getHolders()) {
            map.put(holder.key(), new MappedRegistry(holder.key(), Lifecycle.stable()));
        }
        return map;
    }

    public static void injectBuiltin(RegistryAccess.RegistryHolder builtin, RegistryResourceAccess.InMemoryStorage storage) {
        TerraForged.LOG.info("Injecting world-gen registry defaults");
        RegistryAccess.RegistryHolder context = BuiltinHook.getExtendedHolder(builtin);
        for (ModRegistries.Holder<?> holder : ModRegistries.getHolders()) {
            try {
                BuiltinHook.injectRegistry(holder, context, storage);
            }
            catch (Throwable t) {
                throw new Error("Failed to inject holder: " + holder.key(), t);
            }
        }
    }

    private static <T> void injectRegistry(ModRegistries.Holder<T> holder, RegistryAccess.RegistryHolder context, RegistryResourceAccess.InMemoryStorage storage) {
        Registry<T> registry = holder.registry();
        for (Map.Entry entry : registry.m_6579_()) {
            Object value = entry.getValue();
            try {
                storage.m_195921_(context, (ResourceKey)entry.getKey(), holder.direct(), registry.m_7447_(value), value, registry.m_6228_(value));
            }
            catch (Throwable t) {
                throw new Error("Failed to inject entry: " + entry.getKey() + "=" + value, t);
            }
        }
        RegistryAccessUtil.printRegistryContents(registry);
    }

    private static RegistryAccess.RegistryHolder getExtendedHolder(RegistryAccess.RegistryHolder builtin) {
        RegistryAccess.RegistryHolder extended = new RegistryAccess.RegistryHolder();
        for (RegistryAccess.RegistryData registryData : RegistryAccess.m_194613_()) {
            RegistryAccessUtil.copy(builtin.m_175512_(registryData.f_123101_()), extended);
        }
        for (ModRegistries.Holder holder : ModRegistries.getHolders()) {
            RegistryAccessUtil.copy(holder.registry(), extended);
        }
        return extended;
    }
}

