/*
 * Decompiled with CFR 0.152.
 */
package com.terraforged.mod.registry.hooks;

import com.google.gson.JsonParseException;
import com.mojang.serialization.DataResult;
import com.terraforged.mod.TerraForged;
import com.terraforged.mod.registry.ModRegistries;
import com.terraforged.mod.registry.hooks.RegistryAccessUtil;
import com.terraforged.mod.registry.hooks.StructureConfigHook;
import java.util.Optional;
import net.minecraft.core.MappedRegistry;
import net.minecraft.core.RegistryAccess;
import net.minecraft.resources.RegistryReadOps;

public class DataLoadHook {
    public static void loadData(RegistryAccess access, RegistryReadOps<?> ops) {
        TerraForged.LOG.info("Loading world-gen registry content from data");
        for (ModRegistries.Holder<?> holder : ModRegistries.getHolders()) {
            try {
                DataLoadHook.loadData(holder, access, ops);
            }
            catch (Throwable t) {
                throw new Error("Failed to load holder: " + holder.key(), t);
            }
        }
        StructureConfigHook.injectStructureConfigs(access);
    }

    private static <T> void loadData(ModRegistries.Holder<T> holder, RegistryAccess access, RegistryReadOps<?> ops) {
        Optional registry = access.m_142664_(holder.key());
        if (registry.isEmpty()) {
            return;
        }
        MappedRegistry mappedRegistry = (MappedRegistry)registry.get();
        DataResult result = ops.m_135662_(mappedRegistry, holder.key(), holder.direct());
        RegistryAccessUtil.printRegistryContents(mappedRegistry);
        result.error().ifPresent(partialResult -> {
            throw new JsonParseException("Error loading registry data: " + partialResult.message());
        });
    }
}

