/*
 * Decompiled with CFR 0.152.
 */
package com.terraforged.mod.registry.hooks;

import com.google.common.collect.ImmutableMap;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.UnboundedMapCodec;
import com.terraforged.mod.TerraForged;
import com.terraforged.mod.registry.hooks.RegistryAccessUtil;
import java.util.Map;
import net.minecraft.core.Registry;
import net.minecraft.core.RegistryAccess;

public class NetworkCodecHook {
    public static <K, V> Codec<RegistryAccess.RegistryHolder> createCodec(UnboundedMapCodec<K, V> codec) {
        TerraForged.LOG.info("Injecting safe world-gen network codec");
        return codec.xmap(NetworkCodecHook::createHolder, holder -> {
            ImmutableMap.Builder builder = ImmutableMap.builder();
            for (RegistryAccess.RegistryData known : RegistryAccess.m_194613_()) {
                if (!known.m_123111_()) continue;
                builder.put((Object)known.f_123101_(), (Object)holder.m_175512_(known.f_123101_()));
            }
            return builder.build();
        });
    }

    private static <K, V> RegistryAccess.RegistryHolder createHolder(Map<K, V> map) {
        RegistryAccess.RegistryHolder holder = new RegistryAccess.RegistryHolder();
        for (Map.Entry<K, V> entry : map.entrySet()) {
            Registry registry = (Registry)entry.getValue();
            RegistryAccessUtil.copy(registry, holder);
        }
        return holder;
    }
}

