/*
 * Decompiled with CFR 0.152.
 */
package com.terraforged.mod.registry.hooks;

import com.google.gson.JsonElement;
import com.mojang.serialization.Lifecycle;
import com.terraforged.mod.Common;
import com.terraforged.mod.codec.Codecs;
import com.terraforged.mod.registry.ModRegistry;
import com.terraforged.mod.worldgen.asset.StructureConfig;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.OptionalInt;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import net.minecraft.core.Registry;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.WritableRegistry;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.levelgen.NoiseGeneratorSettings;
import net.minecraft.world.level.levelgen.StructureSettings;
import net.minecraft.world.level.levelgen.feature.ConfiguredStructureFeature;
import net.minecraft.world.level.levelgen.feature.StructureFeature;
import net.minecraft.world.level.levelgen.feature.configurations.StructureFeatureConfiguration;

public class StructureConfigHook {
    private static final ThreadLocal<Holder> LOCAL_ACCESS = ThreadLocal.withInitial(Holder::new);

    public static void injectStructureConfigs(RegistryAccess access) {
        try (Holder holder = LOCAL_ACCESS.get().assign(access);){
            WritableRegistry configRegistry = access.m_175512_(ModRegistry.STRUCTURE_CONFIG.get());
            WritableRegistry noiseRegistry = access.m_175512_(Registry.f_122878_);
            NoiseGeneratorSettings overworld = (NoiseGeneratorSettings)noiseRegistry.m_123013_(NoiseGeneratorSettings.f_64432_);
            HashMap configs = new HashMap(overworld.m_64457_().m_64590_());
            for (Map.Entry entry : configRegistry.m_6579_()) {
                StructureFeature structure = (StructureFeature)Registry.f_122841_.m_7745_(((ResourceKey)entry.getKey()).m_135782_());
                if (structure == null) continue;
                configs.putIfAbsent(structure, ((StructureConfig)entry.getValue()).createConfig());
            }
            StructureSettings structures = StructureConfigHook.createStructureSettings(overworld.m_64457_(), configs);
            NoiseGeneratorSettings noiseSettings = StructureConfigHook.createNoiseSettings(overworld, structures);
            noiseRegistry.m_7794_(OptionalInt.empty(), NoiseGeneratorSettings.f_64432_, (Object)noiseSettings, Lifecycle.stable());
        }
    }

    public static void injectStructureBiomeConfigs(BiConsumer<ConfiguredStructureFeature<?, ?>, ResourceKey<Biome>> consumer) {
        if (!Common.INSTANCE.isDone()) {
            return;
        }
        LOCAL_ACCESS.get().access(access -> {
            WritableRegistry configRegistry = access.m_175512_(ModRegistry.STRUCTURE_CONFIG.get());
            if (configRegistry.m_142427_()) {
                return;
            }
            for (StructureConfig config : configRegistry) {
                config.inject((RegistryAccess)access, consumer);
            }
        });
    }

    private static StructureSettings createStructureSettings(StructureSettings settings, Map<StructureFeature<?>, StructureFeatureConfiguration> configs) {
        return new StructureSettings(Optional.ofNullable(settings.m_64597_()), configs);
    }

    private static NoiseGeneratorSettings createNoiseSettings(NoiseGeneratorSettings overworld, StructureSettings structureSettings) {
        return Codecs.modify(overworld, NoiseGeneratorSettings.f_64430_, json -> {
            JsonElement settings = Codecs.encode(structureSettings, StructureSettings.f_64579_);
            json.add("structures", settings);
            return json;
        });
    }

    private static class Holder
    implements AutoCloseable {
        private RegistryAccess access;

        private Holder() {
        }

        public Holder assign(RegistryAccess access) {
            this.access = access;
            return this;
        }

        public void access(Consumer<RegistryAccess> consumer) {
            if (this.access == null) {
                return;
            }
            consumer.accept(this.access);
        }

        @Override
        public void close() {
            this.access = null;
        }
    }
}

