/*
 * Decompiled with CFR 0.152.
 */
package com.terraforged.mod.util;

import com.terraforged.noise.util.NoiseUtil;

public class MathUtil {
    public static final float EPSILON = 0.99999f;

    public static int clamp(int value, int min, int max) {
        if (value < min) {
            return min;
        }
        if (value > max) {
            return max;
        }
        return value;
    }

    public static int hash(int seed, int x) {
        return NoiseUtil.hash(seed, x);
    }

    public static int hash(int seed, int x, int z) {
        return NoiseUtil.hash2D(seed, x, z);
    }

    public static float randX(int hash) {
        return MathUtil.rand(hash, 1619);
    }

    public static float randZ(int hash) {
        return MathUtil.rand(hash, 31337);
    }

    public static float rand(int seed, int offset) {
        return MathUtil.rand(MathUtil.hash(seed, offset));
    }

    public static float rand(int n) {
        n ^= 0x653;
        float value = (float)((n ^= 0x7A69) * n * n * 60493) / 2.1474836E9f;
        return NoiseUtil.map(value, -1.0f, 1.0f, 2.0f);
    }

    public static float sum(float[] values) {
        float sum = 0.0f;
        for (float value : values) {
            sum += value;
        }
        return sum;
    }
}

