/*
 * Decompiled with CFR 0.152.
 */
package com.terraforged.mod.worldgen;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.terraforged.mod.codec.WorldGenCodec;
import com.terraforged.mod.worldgen.GeneratorPreset;
import com.terraforged.mod.worldgen.GeneratorResource;
import com.terraforged.mod.worldgen.VanillaGen;
import com.terraforged.mod.worldgen.biome.BiomeGenerator;
import com.terraforged.mod.worldgen.biome.Source;
import com.terraforged.mod.worldgen.noise.INoiseGenerator;
import com.terraforged.mod.worldgen.terrain.TerrainCache;
import com.terraforged.mod.worldgen.terrain.TerrainData;
import com.terraforged.mod.worldgen.terrain.TerrainLevels;
import com.terraforged.mod.worldgen.util.ChunkUtil;
import com.terraforged.mod.worldgen.util.ThreadPool;
import java.util.Arrays;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Registry;
import net.minecraft.core.RegistryAccess;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.WorldGenRegion;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.LevelHeightAccessor;
import net.minecraft.world.level.NoiseColumn;
import net.minecraft.world.level.StructureFeatureManager;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.biome.BiomeManager;
import net.minecraft.world.level.biome.BiomeSource;
import net.minecraft.world.level.biome.Climate;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.ChunkAccess;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.levelgen.GenerationStep;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.levelgen.blending.Blender;
import net.minecraft.world.level.levelgen.feature.StructureFeature;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureManager;
import org.jetbrains.annotations.Nullable;

public class Generator
extends ChunkGenerator {
    public static final Codec<Generator> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.LONG.optionalFieldOf("seed", (Object)0L).forGetter(g -> g.seed), (App)TerrainLevels.CODEC.optionalFieldOf("levels", (Object)TerrainLevels.DEFAULT).forGetter(g -> g.levels), (App)WorldGenCodec.CODEC.forGetter(Generator::getRegistries)).apply((Applicative)instance, instance.stable(GeneratorPreset::build)));
    protected final long seed;
    protected final Source f_62137_;
    protected final TerrainLevels levels;
    protected final VanillaGen vanillaGen;
    protected final BiomeGenerator biomeGenerator;
    protected final INoiseGenerator noiseGenerator;
    protected final TerrainCache terrainCache;
    protected final ChunkGenerator structureGenerator;
    protected final ThreadLocal<GeneratorResource> localResource = ThreadLocal.withInitial(GeneratorResource::new);

    public Generator(long seed, TerrainLevels levels, VanillaGen vanillaGen, Source biomeSource, BiomeGenerator biomeGenerator, INoiseGenerator noiseGenerator) {
        super((BiomeSource)biomeSource, (BiomeSource)biomeSource, vanillaGen.getStructureSettings(), seed);
        this.seed = seed;
        this.levels = levels;
        this.vanillaGen = vanillaGen;
        this.f_62137_ = biomeSource;
        this.biomeGenerator = biomeGenerator;
        this.noiseGenerator = noiseGenerator;
        this.terrainCache = new TerrainCache(levels, noiseGenerator);
        this.structureGenerator = vanillaGen.createStructureGenerator(seed, this);
    }

    protected RegistryAccess getRegistries() {
        return this.f_62137_.getRegistries();
    }

    public VanillaGen getVanillaGen() {
        return this.vanillaGen;
    }

    public INoiseGenerator getNoiseGenerator() {
        return this.noiseGenerator;
    }

    public TerrainData getChunkData(ChunkPos pos) {
        return this.terrainCache.getNow(pos);
    }

    public CompletableFuture<TerrainData> getChunkDataAsync(ChunkPos pos) {
        return this.terrainCache.getAsync(pos);
    }

    public Codec<? extends ChunkGenerator> m_6909_() {
        return CODEC;
    }

    public ChunkGenerator m_6819_(long seed) {
        INoiseGenerator noiseGenerator = this.noiseGenerator.with(seed, this.levels);
        Source biomeSource = new Source(seed, noiseGenerator, this.f_62137_);
        VanillaGen vanillaGen = new VanillaGen(seed, biomeSource, this.vanillaGen);
        BiomeGenerator biomeGenerator = new BiomeGenerator(seed, this.biomeGenerator);
        return new Generator(seed, this.levels, vanillaGen, biomeSource, biomeGenerator, noiseGenerator);
    }

    public int m_142062_() {
        return this.levels.minY;
    }

    public int m_6337_() {
        return this.levels.seaLevel;
    }

    public int m_6331_() {
        return this.levels.maxY;
    }

    public Source getBiomeSource() {
        return this.f_62137_;
    }

    public Climate.Sampler m_183403_() {
        return Source.NoopSampler.INSTANCE;
    }

    public boolean m_62172_(ChunkPos pos) {
        return this.structureGenerator.m_62172_(pos);
    }

    @Nullable
    public BlockPos m_62161_(ServerLevel server, StructureFeature<?> feature, BlockPos pos, int i, boolean first) {
        return this.structureGenerator.m_62161_(server, feature, pos, i, first);
    }

    public void m_62199_(RegistryAccess access, StructureFeatureManager structureFeatures, ChunkAccess chunk, StructureManager structures, long seed) {
        this.terrainCache.hint(chunk.m_7697_());
        this.structureGenerator.m_62199_(access, structureFeatures, chunk, structures, seed);
    }

    public void m_62177_(WorldGenLevel level, StructureFeatureManager structureFeatures, ChunkAccess chunk) {
        this.terrainCache.hint(chunk.m_7697_());
        this.structureGenerator.m_62177_(level, structureFeatures, chunk);
    }

    public CompletableFuture<ChunkAccess> m_196423_(Registry<Biome> registry, Executor executor, Blender blender, StructureFeatureManager structures, ChunkAccess chunk) {
        this.terrainCache.hint(chunk.m_7697_());
        return CompletableFuture.supplyAsync(() -> {
            ChunkUtil.fillNoiseBiomes(chunk, this.f_62137_, this.m_183403_(), this.localResource.get());
            return chunk;
        }, ThreadPool.EXECUTOR);
    }

    public CompletableFuture<ChunkAccess> m_183489_(Executor executor, Blender blender, StructureFeatureManager structureManager, ChunkAccess chunkAccess) {
        return this.terrainCache.combineAsync(executor, chunkAccess, (chunk, terrainData) -> {
            ChunkUtil.fillChunk(this.m_6337_(), chunk, terrainData, ChunkUtil.FILLER, this.localResource.get());
            ChunkUtil.primeHeightmaps(this.m_6337_(), chunk, terrainData, ChunkUtil.FILLER);
            ChunkUtil.buildStructureTerrain(chunk, terrainData, structureManager);
            return chunk;
        });
    }

    public void m_183621_(WorldGenRegion region, StructureFeatureManager structures, ChunkAccess chunk) {
        this.biomeGenerator.surface(chunk, region, structures, this);
    }

    public void m_183516_(WorldGenRegion region, long seed, BiomeManager biomes, StructureFeatureManager structures, ChunkAccess chunk, GenerationStep.Carving stage) {
        this.biomeGenerator.carve(seed, chunk, region, biomes, stage, this);
    }

    public void m_183372_(WorldGenLevel region, ChunkAccess chunk, StructureFeatureManager structures) {
        this.biomeGenerator.decorate(chunk, region, structures, this);
        this.terrainCache.drop(chunk.m_7697_());
    }

    public void m_6929_(WorldGenRegion region) {
        this.vanillaGen.getVanillaGenerator().m_6929_(region);
    }

    public int m_142647_(int x, int z, Heightmap.Types types, LevelHeightAccessor levelHeightAccessor) {
        int height = this.terrainCache.getHeight(x, z);
        return switch (types) {
            default -> throw new IncompatibleClassChangeError();
            case Heightmap.Types.WORLD_SURFACE, Heightmap.Types.WORLD_SURFACE_WG, Heightmap.Types.MOTION_BLOCKING, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES -> Math.max(this.m_6337_(), height) + 1;
            case Heightmap.Types.OCEAN_FLOOR, Heightmap.Types.OCEAN_FLOOR_WG -> height + 1;
        };
    }

    public NoiseColumn m_141914_(int x, int z, LevelHeightAccessor levelHeightAccessor) {
        int height = this.terrainCache.getHeight(x, z);
        int surface = Math.max(this.m_6337_(), height);
        Object[] states = new BlockState[surface];
        Arrays.fill(states, 0, height, Blocks.f_50069_.m_49966_());
        if (surface > height) {
            Arrays.fill(states, height, surface, Blocks.f_49990_.m_49966_());
        }
        return new NoiseColumn(height, (BlockState[])states);
    }
}

