/*
 * Decompiled with CFR 0.152.
 */
package com.terraforged.mod.worldgen.asset;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.terraforged.mod.codec.LazyCodec;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.BiConsumer;
import net.minecraft.core.Registry;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.WritableRegistry;
import net.minecraft.data.BuiltinRegistries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.levelgen.StructureSettings;
import net.minecraft.world.level.levelgen.feature.ConfiguredStructureFeature;
import net.minecraft.world.level.levelgen.feature.StructureFeature;
import net.minecraft.world.level.levelgen.feature.configurations.StructureFeatureConfiguration;

public class StructureConfig {
    private static final Codec<Map<ResourceLocation, List<ResourceLocation>>> MAP_CODEC = Codec.unboundedMap((Codec)ResourceLocation.f_135803_, (Codec)ResourceLocation.f_135803_.listOf());
    public static final Codec<StructureConfig> CODEC = LazyCodec.record(instance -> instance.group((App)Codec.INT.fieldOf("salt").forGetter(c -> c.salt), (App)Codec.INT.fieldOf("separation").forGetter(c -> c.separation), (App)Codec.INT.fieldOf("spacing").forGetter(c -> c.spacing), (App)MAP_CODEC.fieldOf("feature_biomes").forGetter(c -> c.featureBiomes)).apply((Applicative)instance, StructureConfig::new));
    private final int salt;
    private final int separation;
    private final int spacing;
    private final Map<ResourceLocation, List<ResourceLocation>> featureBiomes;

    public StructureConfig(int salt, int separation, int spacing, Map<ResourceLocation, List<ResourceLocation>> featureBiomes) {
        this.salt = salt;
        this.separation = separation;
        this.spacing = spacing;
        this.featureBiomes = featureBiomes;
    }

    public StructureFeatureConfiguration createConfig() {
        return new StructureFeatureConfiguration(this.spacing, this.separation, this.salt);
    }

    public void inject(RegistryAccess access, BiConsumer<ConfiguredStructureFeature<?, ?>, ResourceKey<Biome>> consumer) {
        WritableRegistry features = access.m_175512_(Registry.f_122882_);
        for (Map.Entry<ResourceLocation, List<ResourceLocation>> entry : this.featureBiomes.entrySet()) {
            ConfiguredStructureFeature<?, ?> feature = StructureConfig.parseFeature(entry.getKey(), features);
            if (feature == null) continue;
            for (ResourceLocation biome : entry.getValue()) {
                ResourceKey<Biome> biomeKey = StructureConfig.parseBiomeKey(biome);
                consumer.accept(feature, biomeKey);
            }
        }
    }

    private static ConfiguredStructureFeature<?, ?> parseFeature(ResourceLocation name, Registry<ConfiguredStructureFeature<?, ?>> registry) {
        return registry.m_6612_(name).orElseGet(() -> (ConfiguredStructureFeature)BuiltinRegistries.f_123862_.m_7745_(name));
    }

    private static ResourceKey<Biome> parseBiomeKey(ResourceLocation name) {
        return ResourceKey.m_135785_((ResourceKey)Registry.f_122885_, (ResourceLocation)name);
    }

    private static ResourceLocation encodeFeature(ConfiguredStructureFeature<?, ?> feature, Registry<ConfiguredStructureFeature<?, ?>> registry) {
        ResourceLocation name = registry.m_7981_(feature);
        if (name != null) {
            return name;
        }
        return BuiltinRegistries.f_123862_.m_7981_(feature);
    }

    public static StructureConfig create(StructureFeature<?> structure, StructureSettings settings, RegistryAccess access) {
        WritableRegistry features = access.m_175512_(Registry.f_122882_);
        StructureFeatureConfiguration structureConfig = settings.m_64593_(structure);
        if (structureConfig == null) {
            return null;
        }
        HashMap<ResourceLocation, List<ResourceLocation>> biomeMappings = new HashMap<ResourceLocation, List<ResourceLocation>>();
        for (Map.Entry entry : settings.m_189371_(structure).asMap().entrySet()) {
            ResourceLocation feature = StructureConfig.encodeFeature((ConfiguredStructureFeature)entry.getKey(), features);
            List biomes = biomeMappings.computeIfAbsent(feature, f -> new ArrayList());
            for (ResourceKey biome : (Collection)entry.getValue()) {
                biomes.add(biome.m_135782_());
            }
        }
        return new StructureConfig(structureConfig.m_68179_(), structureConfig.m_68176_(), structureConfig.m_68171_(), biomeMappings);
    }
}

