/*
 * Decompiled with CFR 0.152.
 */
package com.terraforged.mod.worldgen.asset;

import com.google.common.base.Suppliers;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.terraforged.engine.world.terrain.Terrain;
import com.terraforged.mod.codec.LazyCodec;
import com.terraforged.mod.util.map.WeightMap;
import com.terraforged.mod.util.seed.ContextSeedable;
import com.terraforged.mod.worldgen.asset.TerrainType;
import com.terraforged.mod.worldgen.noise.NoiseCodec;
import com.terraforged.noise.Module;
import com.terraforged.noise.Source;
import java.util.function.Supplier;

public class TerrainNoise
implements ContextSeedable<TerrainNoise>,
WeightMap.Weighted {
    public static final TerrainNoise NONE = new TerrainNoise((Supplier<TerrainType>)Suppliers.ofInstance((Object)TerrainType.NONE), 0.0f, Source.ZERO);
    public static final Codec<TerrainNoise> CODEC = LazyCodec.record(instance -> instance.group((App)TerrainType.CODEC.fieldOf("type").forGetter(TerrainNoise::type), (App)Codec.FLOAT.fieldOf("weight").forGetter(TerrainNoise::weight), (App)NoiseCodec.CODEC.fieldOf("noise").forGetter(TerrainNoise::noise)).apply((Applicative)instance, TerrainNoise::new));
    private final Supplier<TerrainType> type;
    private final float weight;
    private final Module noise;
    private final Supplier<Terrain> terrain;

    public TerrainNoise(TerrainType type, float weight, Module noise) {
        this((Supplier<TerrainType>)Suppliers.ofInstance((Object)type), weight, noise);
    }

    public TerrainNoise(Supplier<TerrainType> type, float weight, Module noise) {
        this.type = type;
        this.weight = weight;
        this.noise = noise;
        this.terrain = Suppliers.memoize(() -> ((TerrainType)type.get()).getTerrain());
    }

    @Override
    public TerrainNoise withSeed(long seed) {
        Module heightmap = this.withSeed(seed, this.noise(), Module.class);
        return new TerrainNoise(this.type, this.weight, heightmap);
    }

    @Override
    public float weight() {
        return this.weight;
    }

    public Supplier<TerrainType> type() {
        return this.type;
    }

    public Terrain terrain() {
        return this.terrain.get();
    }

    public Module noise() {
        return this.noise;
    }

    public String toString() {
        return "TerrainConfig{terrain=" + this.terrain + ", weight=" + this.weight + ", noise=" + this.noise + "}";
    }
}

