/*
 * Decompiled with CFR 0.152.
 */
package com.terraforged.mod.worldgen.asset;

import com.google.common.base.Suppliers;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.terraforged.mod.codec.LazyCodec;
import com.terraforged.mod.util.seed.ContextSeedable;
import com.terraforged.mod.worldgen.asset.BiomeTag;
import com.terraforged.mod.worldgen.biome.viability.Viability;
import com.terraforged.mod.worldgen.biome.viability.ViabilityCodec;
import java.util.function.Supplier;

public class VegetationConfig
implements ContextSeedable<VegetationConfig> {
    public static final VegetationConfig NONE = new VegetationConfig(0.0f, 0.0f, 0.0f, (Supplier<BiomeTag>)Suppliers.ofInstance((Object)BiomeTag.NONE), Viability.NONE);
    public static final Codec<VegetationConfig> CODEC = LazyCodec.record(instance -> instance.group((App)Codec.FLOAT.optionalFieldOf("frequency", (Object)Float.valueOf(1.0f)).forGetter(VegetationConfig::frequency), (App)Codec.FLOAT.optionalFieldOf("jitter", (Object)Float.valueOf(1.0f)).forGetter(VegetationConfig::jitter), (App)Codec.FLOAT.optionalFieldOf("density", (Object)Float.valueOf(1.0f)).forGetter(VegetationConfig::density), (App)BiomeTag.CODEC.fieldOf("biomes").forGetter(VegetationConfig::biomes), (App)ViabilityCodec.CODEC.fieldOf("viability").forGetter(VegetationConfig::viability)).apply((Applicative)instance, VegetationConfig::new));
    private final float frequency;
    private final float jitter;
    private final float density;
    private final Supplier<BiomeTag> biomes;
    private final Viability viability;

    public VegetationConfig(float frequency, float jitter, float density, Supplier<BiomeTag> biomes, Viability viability) {
        this.biomes = biomes;
        this.frequency = frequency;
        this.jitter = jitter;
        this.density = density;
        this.viability = viability;
    }

    @Override
    public VegetationConfig withSeed(long seed) {
        Viability viability = this.withSeed(seed, this.viability(), Viability.class);
        return new VegetationConfig(this.frequency, this.jitter, this.density, this.biomes, viability);
    }

    public Supplier<BiomeTag> biomes() {
        return this.biomes;
    }

    public float frequency() {
        return this.frequency;
    }

    public float jitter() {
        return this.jitter;
    }

    public float density() {
        return this.density;
    }

    public Viability viability() {
        return this.viability;
    }

    public String toString() {
        return "VegetationConfig{frequency=" + this.frequency + ", jitter=" + this.jitter + ", density=" + this.density + ", biomes=" + this.biomes + ", viability=" + this.viability + "}";
    }
}

