/*
 * Decompiled with CFR 0.152.
 */
package com.terraforged.mod.worldgen.biome;

import com.terraforged.engine.cell.Cell;
import com.terraforged.engine.world.biome.type.BiomeType;
import com.terraforged.engine.world.climate.ClimateModule;
import com.terraforged.engine.world.heightmap.ControlPoints;
import com.terraforged.mod.TerraForged;
import com.terraforged.mod.util.map.WeightMap;
import com.terraforged.mod.worldgen.biome.IBiomeSampler;
import com.terraforged.mod.worldgen.biome.util.BiomeMapManager;
import com.terraforged.mod.worldgen.noise.INoiseGenerator;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.biome.Biomes;

public class BiomeSampler
extends IBiomeSampler.Sampler
implements IBiomeSampler {
    protected final BiomeMapManager biomeMapManager;

    public BiomeSampler(INoiseGenerator noiseGenerator, BiomeMapManager biomeMapManager) {
        super(noiseGenerator);
        this.biomeMapManager = biomeMapManager;
    }

    public Biome sampleBiome(int x, int z) {
        Biome biome;
        IBiomeSampler.ClimateSample sample = this.sample(x, z);
        WeightMap<Biome> map = this.biomeMapManager.getBiomeMap().get((Object)sample.cell.biome);
        if (map == null || map.isEmpty()) {
            TerraForged.LOG.debug("Missing biome for type: {}", (Object)sample.cell.biome);
            biome = (Biome)this.biomeMapManager.getBiomes().m_123013_(Biomes.f_48202_);
        } else {
            biome = map.getValue(sample.cell.biomeRegionId);
        }
        return this.getBiome(biome, sample);
    }

    @Override
    public ClimateModule getClimate() {
        return this.climateModule;
    }

    @Override
    public float getShape(int x, int z) {
        IBiomeSampler.ClimateSample sample = ((IBiomeSampler.ClimateSample)this.localSample.get()).reset();
        Cell cell = sample.cell;
        this.climateModule.apply(cell, x, z);
        return sample.cell.biomeRegionEdge;
    }

    @Override
    public IBiomeSampler.ClimateSample sample(int x, int z) {
        float px = (float)x * this.noiseGenerator.getLevels().frequency;
        float pz = (float)z * this.noiseGenerator.getLevels().frequency;
        IBiomeSampler.ClimateSample sample = ((IBiomeSampler.ClimateSample)this.localSample.get()).reset();
        this.noiseGenerator.getContinent().sampleContinent(px, pz, sample);
        this.noiseGenerator.getContinent().sampleRiver(px, pz, sample, sample.riverCache);
        Cell cell = sample.cell;
        cell.value = sample.heightNoise;
        cell.terrain = sample.terrainType;
        cell.riverMask = sample.riverNoise;
        cell.continentEdge = sample.continentNoise;
        this.climateModule.apply(cell, x, z);
        return sample;
    }

    protected Biome getBiome(Biome input, IBiomeSampler.ClimateSample sample) {
        BiomeType biomeType = sample.cell.biome;
        ControlPoints controls = this.noiseGenerator.getContinent().getControlPoints();
        if (sample.continentNoise < controls.shallowOcean && sample.continentNoise < controls.beach) {
            return switch (biomeType) {
                case BiomeType.TAIGA, BiomeType.COLD_STEPPE -> this.biomeMapManager.get((ResourceKey<Biome>)Biomes.f_48171_);
                case BiomeType.TUNDRA -> this.biomeMapManager.get((ResourceKey<Biome>)Biomes.f_48172_);
                case BiomeType.DESERT, BiomeType.SAVANNA, BiomeType.TROPICAL_RAINFOREST -> this.biomeMapManager.get((ResourceKey<Biome>)Biomes.f_48170_);
                default -> this.biomeMapManager.get((ResourceKey<Biome>)Biomes.f_48225_);
            };
        }
        if (sample.continentNoise < controls.beach) {
            return switch (biomeType) {
                case BiomeType.TAIGA, BiomeType.COLD_STEPPE -> this.biomeMapManager.get((ResourceKey<Biome>)Biomes.f_48168_);
                case BiomeType.TUNDRA -> this.biomeMapManager.get((ResourceKey<Biome>)Biomes.f_48211_);
                case BiomeType.DESERT, BiomeType.SAVANNA, BiomeType.TROPICAL_RAINFOREST -> this.biomeMapManager.get((ResourceKey<Biome>)Biomes.f_48166_);
                default -> this.biomeMapManager.get((ResourceKey<Biome>)Biomes.f_48174_);
            };
        }
        if ((sample.cell.terrain.isRiver() || sample.cell.terrain.isLake()) && sample.cell.value < this.noiseGenerator.getLevels().heightMin) {
            return biomeType == BiomeType.TUNDRA ? this.biomeMapManager.get((ResourceKey<Biome>)Biomes.f_48212_) : this.biomeMapManager.get((ResourceKey<Biome>)Biomes.f_48208_);
        }
        return input;
    }
}

