/*
 * Decompiled with CFR 0.152.
 */
package com.terraforged.mod.worldgen.biome.decorator;

import com.terraforged.mod.worldgen.Generator;
import com.terraforged.mod.worldgen.biome.decorator.VanillaDecorator;
import com.terraforged.mod.worldgen.biome.feature.PositionSampler;
import com.terraforged.mod.worldgen.biome.vegetation.BiomeVegetation;
import com.terraforged.mod.worldgen.biome.vegetation.BiomeVegetationManager;
import com.terraforged.mod.worldgen.biome.vegetation.VegetationFeatures;
import com.terraforged.mod.worldgen.terrain.TerrainData;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.concurrent.CompletableFuture;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.SectionPos;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.StructureFeatureManager;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.chunk.ChunkAccess;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.levelgen.GenerationStep;
import net.minecraft.world.level.levelgen.LegacyRandomSource;
import net.minecraft.world.level.levelgen.RandomSource;
import net.minecraft.world.level.levelgen.RandomSupport;
import net.minecraft.world.level.levelgen.WorldgenRandom;
import net.minecraft.world.level.levelgen.feature.StructureFeature;
import net.minecraft.world.level.levelgen.placement.PlacedFeature;

public class FeatureDecorator {
    public static final GenerationStep.Decoration[] STAGES = GenerationStep.Decoration.values();
    private static final int MAX_DECORATION_STAGE = GenerationStep.Decoration.TOP_LAYER_MODIFICATION.ordinal();
    private final BiomeVegetationManager vegetation;
    private final Map<GenerationStep.Decoration, List<Supplier<StructureFeature<?>>>> structures;

    public FeatureDecorator(RegistryAccess access) {
        this.vegetation = new BiomeVegetationManager(access);
        this.structures = VanillaDecorator.buildStructureMap(access);
    }

    public BiomeVegetationManager getVegetationManager() {
        return this.vegetation;
    }

    public List<Supplier<StructureFeature<?>>> getStageStructures(int stage) {
        return this.structures.get(STAGES[stage]);
    }

    public List<Supplier<PlacedFeature>> getStageFeatures(int stage, Biome biome) {
        List stages = biome.m_47536_().m_47818_();
        if (stage >= stages.size()) {
            return Collections.emptyList();
        }
        return (List)stages.get(stage);
    }

    public void decorate(ChunkAccess chunk, WorldGenLevel level, StructureFeatureManager structures, CompletableFuture<TerrainData> terrain, Generator generator) {
        BlockPos origin = FeatureDecorator.getOrigin(level, chunk);
        Biome biome = level.m_46857_(origin);
        WorldgenRandom random = FeatureDecorator.getRandom();
        long seed = random.m_64690_(level.m_7328_(), origin.m_123341_(), origin.m_123343_());
        this.decoratePre(seed, origin, biome, chunk, level, generator, random, structures);
        this.decorateTrees(seed, chunk, level, terrain, generator, random);
        this.decorateOther(seed, origin, biome, level, generator, random);
        this.decoratePost(seed, origin, biome, chunk, level, generator, random, structures);
    }

    private void decoratePre(long seed, BlockPos origin, Biome biome, ChunkAccess chunk, WorldGenLevel level, Generator generator, WorldgenRandom random, StructureFeatureManager structureManager) {
        VanillaDecorator.decorate(seed, 0, VegetationFeatures.STAGE - 1, origin, biome, chunk, level, generator, random, structureManager, this);
    }

    private void decoratePost(long seed, BlockPos origin, Biome biome, ChunkAccess chunk, WorldGenLevel level, Generator generator, WorldgenRandom random, StructureFeatureManager structureManager) {
        VanillaDecorator.decorate(seed, VegetationFeatures.STAGE + 1, MAX_DECORATION_STAGE, origin, biome, chunk, level, generator, random, structureManager, this);
    }

    private void decorateTrees(long seed, ChunkAccess chunk, WorldGenLevel level, CompletableFuture<TerrainData> terrain, Generator generator, WorldgenRandom random) {
        PositionSampler.place(seed, chunk, level, terrain, generator, random, this);
    }

    private void decorateOther(long seed, BlockPos origin, Biome biome, WorldGenLevel level, Generator generator, WorldgenRandom random) {
        BiomeVegetation vegetation = this.getVegetationManager().getVegetation(biome);
        if (vegetation.features == VegetationFeatures.NONE) {
            return;
        }
        int offset = 245889;
        for (PlacedFeature other : vegetation.features.other()) {
            random.m_190064_(seed, offset++, VegetationFeatures.STAGE);
            other.m_191806_(level, (ChunkGenerator)generator, (Random)random, origin);
        }
    }

    private static BlockPos getOrigin(WorldGenLevel level, ChunkAccess chunk) {
        ChunkPos chunkPos = chunk.m_7697_();
        SectionPos sectionPos = SectionPos.m_123196_((ChunkPos)chunkPos, (int)level.m_151560_());
        return sectionPos.m_123249_();
    }

    private static WorldgenRandom getRandom() {
        return new WorldgenRandom((RandomSource)new LegacyRandomSource(RandomSupport.m_189328_()));
    }
}

