/*
 * Decompiled with CFR 0.152.
 */
package com.terraforged.mod.worldgen.biome.decorator;

import com.terraforged.mod.worldgen.Generator;
import com.terraforged.mod.worldgen.biome.decorator.FeatureDecorator;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Registry;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.SectionPos;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.LevelHeightAccessor;
import net.minecraft.world.level.StructureFeatureManager;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.chunk.ChunkAccess;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.levelgen.GenerationStep;
import net.minecraft.world.level.levelgen.WorldgenRandom;
import net.minecraft.world.level.levelgen.feature.StructureFeature;
import net.minecraft.world.level.levelgen.placement.PlacedFeature;
import net.minecraft.world.level.levelgen.structure.BoundingBox;

public class VanillaDecorator {
    public static void decorate(long seed, int from, int to, BlockPos origin, Biome biome, ChunkAccess chunk, WorldGenLevel level, Generator generator, WorldgenRandom random, StructureFeatureManager structureManager, FeatureDecorator decorator) {
        for (int stage = from; stage <= to; ++stage) {
            List<Supplier<StructureFeature<?>>> structures = decorator.getStageStructures(stage);
            List<Supplier<PlacedFeature>> features = decorator.getStageFeatures(stage, biome);
            int offset = structures.size();
            VanillaDecorator.placeStructures(seed, stage, chunk, level, generator, random, structureManager, structures);
            VanillaDecorator.placeFeatures(seed, offset, stage, origin, level, generator, random, features);
        }
    }

    private static void placeStructures(long seed, int stage, ChunkAccess chunk, WorldGenLevel level, Generator generator, WorldgenRandom random, StructureFeatureManager structureManager, List<Supplier<StructureFeature<?>>> structures) {
        ChunkPos chunkPos = chunk.m_7697_();
        SectionPos sectionPos = SectionPos.m_123196_((ChunkPos)chunkPos, (int)level.m_151560_());
        for (int i = 0; i < structures.size(); ++i) {
            random.m_190064_(seed, i, stage);
            StructureFeature<?> structure = structures.get(i).get();
            structureManager.m_186610_(sectionPos, structure).forEach(start -> start.m_7129_(level, structureManager, (ChunkGenerator)generator, (Random)random, VanillaDecorator.getWritableArea(chunk), chunkPos));
        }
    }

    private static void placeFeatures(long seed, int offset, int stage, BlockPos origin, WorldGenLevel level, Generator generator, WorldgenRandom random, List<Supplier<PlacedFeature>> features) {
        for (int i = 0; i < features.size(); ++i) {
            random.m_190064_(seed, offset + i, stage);
            PlacedFeature feature = features.get(i).get();
            feature.m_191806_(level, (ChunkGenerator)generator, (Random)random, origin);
        }
    }

    public static Map<GenerationStep.Decoration, List<Supplier<StructureFeature<?>>>> buildStructureMap(RegistryAccess access) {
        EnumMap map = new EnumMap(GenerationStep.Decoration.class);
        Registry registry = access.m_175515_(Registry.f_122840_);
        for (Map.Entry entry : registry.m_6579_()) {
            ResourceKey key = (ResourceKey)entry.getKey();
            StructureFeature value = (StructureFeature)entry.getValue();
            map.computeIfAbsent(value.m_67095_(), s -> new ArrayList()).add(() -> (StructureFeature)registry.m_6246_(key));
        }
        for (GenerationStep.Decoration stage : FeatureDecorator.STAGES) {
            if (map.containsKey(stage)) continue;
            map.put(stage, Collections.emptyList());
        }
        return map;
    }

    private static BoundingBox getWritableArea(ChunkAccess chunkAccess) {
        ChunkPos chunkPos = chunkAccess.m_7697_();
        int minX = chunkPos.m_45604_();
        int minZ = chunkPos.m_45605_();
        LevelHeightAccessor levelHeightAccessor = chunkAccess.m_183618_();
        int minY = levelHeightAccessor.m_141937_() + 1;
        int maxY = levelHeightAccessor.m_151558_() - 1;
        return new BoundingBox(minX, minY, minZ, minX + 15, maxY, minZ + 15);
    }
}

