/*
 * Decompiled with CFR 0.152.
 */
package com.terraforged.mod.worldgen.biome.feature;

import com.terraforged.mod.util.MathUtil;
import com.terraforged.mod.worldgen.Generator;
import com.terraforged.mod.worldgen.asset.VegetationConfig;
import com.terraforged.mod.worldgen.biome.decorator.FeatureDecorator;
import com.terraforged.mod.worldgen.biome.feature.SamplerContext;
import com.terraforged.mod.worldgen.biome.vegetation.BiomeVegetation;
import com.terraforged.mod.worldgen.biome.vegetation.VegetationFeatures;
import com.terraforged.mod.worldgen.biome.viability.Viability;
import com.terraforged.mod.worldgen.terrain.TerrainData;
import com.terraforged.noise.util.NoiseUtil;
import java.util.Random;
import java.util.concurrent.CompletableFuture;
import net.minecraft.core.BlockPos;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.chunk.ChunkAccess;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.levelgen.WorldgenRandom;
import net.minecraft.world.level.levelgen.placement.PlacedFeature;

public class PositionSampler {
    protected static final float BORDER = 6.0f;
    protected static final int OFFSET_START = 23189045;
    public static final float SQUASH_FACTOR = 2.0f / NoiseUtil.sqrt(3.0f);

    public static void place(long seed, ChunkAccess chunk, WorldGenLevel level, CompletableFuture<TerrainData> terrain, Generator generator, WorldgenRandom random, FeatureDecorator decorator) {
        SamplerContext context = SamplerContext.get();
        context.chunk = chunk;
        context.region = level;
        context.random = random;
        context.generator = generator;
        context.viabilityContext.terrainData = terrain;
        context.viabilityContext.biomeSampler = generator.getBiomeSource().getBiomeSampler();
        PositionSampler.populate(context, decorator);
        int x = chunk.m_7697_().m_45604_();
        int z = chunk.m_7697_().m_45605_();
        int offset = 23189045;
        for (int i = 0; i < context.biomeList.size(); ++i) {
            Biome biome = context.biomeList.get(i);
            BiomeVegetation vegetation = decorator.getVegetationManager().getVegetation(biome);
            VegetationConfig config = vegetation.config;
            context.push(biome, vegetation);
            if (config == VegetationConfig.NONE) {
                offset = PositionSampler.placeAt(seed, 23189045, x, z, context);
                continue;
            }
            offset = PositionSampler.sample(seed, offset, x, z, config.frequency(), config.jitter(), context, PositionSampler::placeAt);
            offset = PositionSampler.placeGrassAt(seed, offset, x, z, context);
        }
    }

    public static void populate(SamplerContext context, FeatureDecorator decorator) {
        ChunkAccess chunk = context.chunk;
        int startX = chunk.m_7697_().m_45604_();
        int startZ = chunk.m_7697_().m_45605_();
        for (int dz = 0; dz < 16; ++dz) {
            for (int dx = 0; dx < 16; ++dx) {
                int x = startX + dx;
                int z = startZ + dz;
                int y = context.getHeight(dx, dz);
                Biome biome = context.getBiome(x, y, z);
                BiomeVegetation vegetation = decorator.getVegetationManager().getVegetation(biome);
                Viability viability = vegetation.config.viability();
                float value = viability.getFitness(x, z, context.viabilityContext);
                context.viability.set(dx, dz, value);
                context.biomeList.add(biome);
            }
        }
    }

    public static <T> int sample(long seed, int offset, int x, int z, float freq, float jitter, T context, Sampler<T> sampler) {
        float freqX = freq;
        float freqZ = freq * SQUASH_FACTOR;
        int minX = NoiseUtil.floor(((float)x - 6.0f) * freqX);
        int minZ = NoiseUtil.floor(((float)z - 6.0f) * freqZ);
        int maxX = NoiseUtil.floor(((float)(x + 15) + 6.0f) * freqX);
        int maxZ = NoiseUtil.floor(((float)(z + 15) + 6.0f) * freqZ);
        return PositionSampler.sample(seed, offset, minX, minZ, maxX, maxZ, freqX, freqZ, jitter, context, sampler);
    }

    public static <T> int sample(long seed, int offset, int minX, int minZ, int maxX, int maxZ, float freqX, float freqZ, float jitter, T context, Sampler<T> sampler) {
        int cellSeed = (int)seed;
        for (int pz = minZ; pz <= maxZ; ++pz) {
            float ox = (float)(pz & 1) * 0.5f;
            for (int px = minX; px <= maxX; ++px) {
                int hash = MathUtil.hash(cellSeed, px, pz);
                float dx = MathUtil.randX(hash);
                float dz = MathUtil.randZ(hash);
                float sx = (float)px + ox + dx * jitter * 0.65f;
                float sz = (float)pz + dz * jitter;
                int posX = NoiseUtil.floor(sx / freqX);
                int posZ = NoiseUtil.floor(sz / freqZ);
                offset = sampler.sample(seed, offset, hash, posX, posZ, context);
            }
        }
        return offset;
    }

    private static int placeAt(long seed, int offset, int x, int z, SamplerContext context) {
        int chunkX = x >> 4;
        int chunkZ = z >> 4;
        if (chunkX != context.chunk.m_7697_().f_45578_ || chunkZ != context.chunk.m_7697_().f_45579_) {
            return offset;
        }
        int y = context.chunk.m_5885_(Heightmap.Types.OCEAN_FLOOR_WG, x, z);
        if (y <= context.generator.m_6337_()) {
            return offset;
        }
        context.pos.m_122178_(x, y, z);
        for (PlacedFeature feature : context.features.trees()) {
            context.random.m_190064_(seed, offset++, VegetationFeatures.STAGE);
            feature.m_191806_(context.region, (ChunkGenerator)context.generator, (Random)context.random, (BlockPos)context.pos);
        }
        for (PlacedFeature feature : context.features.grass()) {
            context.random.m_190064_(seed, offset++, VegetationFeatures.STAGE);
            feature.m_191806_(context.region, (ChunkGenerator)context.generator, (Random)context.random, (BlockPos)context.pos);
        }
        return offset;
    }

    private static int placeAt(long seed, int offset, int hash, int x, int z, SamplerContext context) {
        float noise;
        if (!PositionSampler.isFeatureChunk(x, z, context)) {
            return offset;
        }
        int y = context.chunk.m_5885_(Heightmap.Types.OCEAN_FLOOR_WG, x, z);
        if (y <= context.generator.m_6337_()) {
            return offset;
        }
        context.pos.m_122178_(x, y, z);
        Biome biome = context.region.m_46857_((BlockPos)context.pos);
        if (biome != context.biome) {
            return offset;
        }
        float viability = context.viability.get(x & 0xF, z & 0xF);
        if (viability < (noise = (1.0f - context.vegetation.density()) * MathUtil.rand(hash))) {
            return offset;
        }
        for (PlacedFeature feature : context.features.trees()) {
            context.random.m_190064_(seed, offset++, VegetationFeatures.STAGE);
            feature.m_191806_(context.region, (ChunkGenerator)context.generator, (Random)context.random, (BlockPos)context.pos);
        }
        return offset;
    }

    private static int placeGrassAt(long seed, int offset, int x, int z, SamplerContext context) {
        WorldGenLevel region = context.region;
        Generator generator = context.generator;
        WorldgenRandom random = context.random;
        BlockPos.MutableBlockPos pos = context.pos.m_122178_(x, 0, z);
        int passes = 2;
        passes += NoiseUtil.floor(2.0f * (1.0f - context.maxViability));
        passes += NoiseUtil.floor(4.0f * context.terrainData().getWater().get(8, 8));
        passes -= NoiseUtil.floor(5 * context.terrainData().getHeight(8, 8));
        passes = Math.max(2, passes);
        for (int i = 0; i < passes; ++i) {
            for (PlacedFeature feature : context.features.grass()) {
                random.m_190064_(seed, offset++, VegetationFeatures.STAGE);
                feature.m_191806_(region, (ChunkGenerator)generator, (Random)random, (BlockPos)pos);
            }
        }
        return offset;
    }

    private static boolean isFeatureChunk(int x, int z, SamplerContext context) {
        int chunkX = x >> 4;
        int chunkZ = z >> 4;
        return chunkX == context.chunk.m_7697_().f_45578_ && chunkZ == context.chunk.m_7697_().f_45579_;
    }

    public static interface Sampler<T> {
        public int sample(long var1, int var3, int var4, int var5, int var6, T var7);
    }
}

