/*
 * Decompiled with CFR 0.152.
 */
package com.terraforged.mod.worldgen.biome.surface;

import com.terraforged.mod.worldgen.terrain.TerrainData;
import com.terraforged.noise.util.NoiseUtil;
import net.minecraft.core.BlockPos;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.Tag;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.SnowLayerBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.chunk.ChunkAccess;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.levelgen.Heightmap;

public class Surface {
    protected static final Tag<Block> ERODABLE = BlockTags.f_144274_;

    public static void apply(TerrainData terrainData, ChunkAccess chunk, ChunkGenerator generator) {
        float norm = 55.0f * ((float)generator.m_6331_() / 255.0f);
        BlockPos.MutableBlockPos pos = new BlockPos.MutableBlockPos();
        for (int dz = 0; dz < 16; ++dz) {
            for (int dx = 0; dx < 16; ++dx) {
                BlockState solid;
                int y;
                float gradient = terrainData.getGradient(dx, dz, norm);
                if (y < generator.m_6337_() || gradient < 0.6f || (solid = Surface.findSolid(pos.m_122178_(dx, y, dz), chunk)) == null) continue;
                int bottom = pos.m_123342_();
                for (y = chunk.m_5885_(Heightmap.Types.OCEAN_FLOOR_WG, dx, dz); y > bottom; --y) {
                    chunk.m_6978_((BlockPos)pos.m_142448_(y), solid, false);
                }
            }
        }
    }

    public static void applyPost(ChunkAccess chunk, TerrainData terrainData, ChunkGenerator generator) {
        float norm = 70.0f * ((float)generator.m_6331_() / 255.0f);
        BlockPos.MutableBlockPos pos = new BlockPos.MutableBlockPos();
        for (int dz = 0; dz < 16; ++dz) {
            for (int dx = 0; dx < 16; ++dx) {
                int y = chunk.m_5885_(Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, dx, dz) + 1;
                pos.m_122178_(dx, y, dz);
                BlockState state = chunk.m_8055_((BlockPos)pos);
                float gradient = terrainData.getGradient(dx, dz, norm);
                if (gradient < 0.625f) {
                    if (!(state.m_60734_() instanceof SnowLayerBlock)) continue;
                    Surface.smoothSnow(pos, state, chunk, terrainData);
                    continue;
                }
                if (state.m_60795_()) {
                    state = chunk.m_8055_((BlockPos)pos.m_142448_(y - 1));
                }
                if (!BlockTags.f_144279_.m_8110_((Object)state.m_60734_())) continue;
                Surface.erodeSnow(pos, chunk);
            }
        }
    }

    protected static void smoothSnow(BlockPos.MutableBlockPos pos, BlockState state, ChunkAccess chunk, TerrainData terrain) {
        float height = terrain.getHeight().get(pos.m_123341_(), pos.m_123343_());
        float delta = height - (float)terrain.getLevels().getHeight(height);
        int layers = 1 + NoiseUtil.floor(delta * 7.9999f);
        state = (BlockState)state.m_61124_((Property)SnowLayerBlock.f_56581_, (Comparable)Integer.valueOf(layers));
        chunk.m_6978_((BlockPos)pos, state, false);
    }

    protected static void erodeSnow(BlockPos.MutableBlockPos pos, ChunkAccess chunk) {
        chunk.m_6978_((BlockPos)pos, Blocks.f_50016_.m_49966_(), false);
        int y0 = pos.m_123342_() - 1;
        int y1 = Math.max(pos.m_123342_() - 15, 0);
        for (int y = y0; y > y1; --y) {
            pos.m_142448_(y);
            BlockState state = chunk.m_8055_((BlockPos)pos);
            if (!Surface.isErodible(state)) {
                return;
            }
            chunk.m_6978_((BlockPos)pos, Blocks.f_50069_.m_49966_(), false);
        }
    }

    public static boolean isErodible(BlockState state) {
        return ERODABLE.m_8110_((Object)state.m_60734_()) || BlockTags.f_144279_.m_8110_((Object)state.m_60734_());
    }

    protected static BlockState findSolid(BlockPos.MutableBlockPos pos, ChunkAccess chunk) {
        BlockState state = chunk.m_8055_((BlockPos)pos);
        if (!Surface.isErodible(state)) {
            return null;
        }
        int bottom = Math.max(0, pos.m_123342_() - 20);
        for (int y = pos.m_123342_() - 1; y > bottom; --y) {
            state = chunk.m_8055_((BlockPos)pos.m_142448_(y));
            if (Surface.isErodible(state)) continue;
            return state;
        }
        return null;
    }
}

