/*
 * Decompiled with CFR 0.152.
 */
package com.terraforged.mod.worldgen.biome.surface;

import com.terraforged.mod.worldgen.util.delegate.DelegateBiomeManager;
import net.minecraft.core.BlockPos;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.biome.BiomeManager;

public class SurfaceBiomeManager
extends DelegateBiomeManager {
    private static final ThreadLocal<SurfaceBiomeManager> LOCAL_SURFACE_MANAGER = ThreadLocal.withInitial(SurfaceBiomeManager::new);
    protected ChunkPos chunkPos;
    protected final Biome[] surfaceCache = new Biome[256];
    protected final BlockPos.MutableBlockPos pos = new BlockPos.MutableBlockPos();

    SurfaceBiomeManager set(ChunkPos chunkPos, BiomeManager biomeManager) {
        super.set(biomeManager);
        this.chunkPos = chunkPos;
        int startX = chunkPos.m_45604_();
        int startZ = chunkPos.m_45605_();
        for (int dz = 0; dz < 16; ++dz) {
            for (int dx = 0; dx < 16; ++dx) {
                this.pos.m_122178_(startX + dx, 0, startZ + dz);
                this.surfaceCache[SurfaceBiomeManager.index((int)dx, (int)dz)] = biomeManager.m_47881_((BlockPos)this.pos);
            }
        }
        return this;
    }

    @Override
    public Biome m_47881_(BlockPos pos) {
        int chunkX = pos.m_123341_() >> 4;
        int chunkZ = pos.m_123343_() >> 4;
        if (chunkX == this.chunkPos.f_45578_ && chunkZ == this.chunkPos.f_45579_) {
            int dx = pos.m_123341_() - (chunkX << 4);
            int dz = pos.m_123343_() - (chunkZ << 4);
            return this.surfaceCache[SurfaceBiomeManager.index(dx, dz)];
        }
        return super.m_47881_(pos);
    }

    protected static int index(int x, int z) {
        return z << 4 | x;
    }

    public static BiomeManager assign(ChunkPos chunkPos, BiomeManager biomeManager) {
        return LOCAL_SURFACE_MANAGER.get().set(chunkPos, biomeManager);
    }
}

